/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PrependStringBuffer;

public abstract class TreeNode {
    public static final int NAME_LEN = 511;
    public static final int DESC_LEN = 1023;
    protected String _name;
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER";
    private String _description;
    protected Noun _parent;
    protected boolean _alive;

    public TreeNode(Noun noun, String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), noun, string, string2}, "Malformed TreeNode: " + noun + ":" + string + ":" + string2));
        }
        this._name = DMSUtil.sanitize(string, 511, false, false);
        this._description = DMSUtil.sanitize(string2, 1023, false, false);
        this._parent = noun;
        this._alive = true;
        State state = StatisticsProducer._nodes_state;
        if (state != null) {
            state.increment(1);
        }
    }

    public TreeNode(Noun noun, String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), noun, string, string2}, "Malformed TreeNode: " + noun + ":" + string + ":" + string2));
        }
        if (bl) {
            this._name = DMSUtil.sanitize(string, 511, true, true);
            this._description = DMSUtil.sanitize(string2, 1023, false, false);
        } else {
            this._name = string;
            this._description = string2;
        }
        this._parent = noun;
        this._alive = true;
        State state = StatisticsProducer._nodes_state;
        if (state != null) {
            state.increment(1);
        }
    }

    public Noun getParent() {
        return this._parent;
    }

    public String getName() {
        return this._name;
    }

    public synchronized String toString() {
        Noun noun = Noun.getRoot();
        if (this == noun) {
            return "/";
        }
        PrependStringBuffer prependStringBuffer = new PrependStringBuffer(50, this._name);
        Noun noun2 = this._parent;
        while (noun2 != noun) {
            prependStringBuffer.prepend('/');
            prependStringBuffer.prepend(noun2._name);
            noun2 = noun2._parent;
        }
        prependStringBuffer.prepend('/');
        return prependStringBuffer.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void destroy() {
        this._alive = false;
        State state = StatisticsProducer._nodes_state;
        if (state != null) {
            state.increment(-1);
        }
    }

    void setName(String string) {
        this._name = string;
    }
}

