/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.Noun;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Publisher;
import oracle.dms.spy.PublisherError;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Spy {
    public static final String PUBLISHER_CLASSES = "oracle.dms.publisher.classes";
    public static final String HTTP_PUBLISHER_CLASS = "oracle.dms.http.Httpd";
    private static final String PUBLISHER_DELIMITORS = ",;";
    private static StatisticsProducer _spy;
    private static Vector _sPublisher;
    private static volatile boolean s_active;
    private static volatile boolean _sPublishInited;
    private static String _defaultDumpFile;
    private static final String PUBLISHER_NOT_FOUND = "PUBLISHER_NOT_FOUND";
    private static final String PUBLISHER_EXCEPTION = "PUBLISHER_EXCEPTION";
    private static final String LOGGER_INIT_FAILED = "LOGGER_INIT_FAILED";
    private static final String LOGGER_EXIT_FAILED = "LOGGER_EXIT_FAILED";
    private static final String NOT_ALIVE = "NOT_ALIVE";
    private static final String PREFIX = "SPY_";
    private static final String SPY = "Spy";
    private static final String PUBINIT = "pubInit";
    private static final String SPYEXIT = "spyExit";

    private Spy() {
    }

    public static synchronized void init() throws ConfigurationError, PublisherError {
        Spy.init("", null);
    }

    public static synchronized void init(String string, Properties properties) throws ConfigurationError, PublisherError {
        if (Spy.isActive()) {
            return;
        }
        Spy.setActive(true);
        DMSProperties.init(properties);
        try {
            Log.init();
        }
        catch (ConfigurationError configurationError) {
            ConfigurationError configurationError2 = new ConfigurationError("logging configuration failed", configurationError);
            throw configurationError2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            ConfigurationError configurationError = new ConfigurationError("logging security error", privilegedActionException);
            throw configurationError;
        }
        if (string == null) {
            string = "";
        }
        _spy = new StatisticsProducer(string);
        Spy.initPublisher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initPublisher() throws ConfigurationError, PublisherError {
        if (!Spy.isActive() || _sPublishInited) {
            return;
        }
        String string = DMSProperties.getProperty(PUBLISHER_CLASSES);
        if (string == null) {
            return;
        }
        _sPublishInited = true;
        boolean bl = true;
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, PUBLISHER_DELIMITORS);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    Class<?> clazz = Class.forName(string2);
                    Publisher publisher = (Publisher)clazz.newInstance();
                    _sPublisher.addElement(publisher);
                    Log.log(DMSUtil.genCompNounPath("Spy/pubInit"), DMSNLSupport.getString("SPY_pubInit"), Level.DEBUG, new Object[]{string2});
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ConfigurationError configurationError = new ConfigurationError("Class: " + string + " not found.", classNotFoundException);
                throw configurationError;
            }
            catch (InstantiationException instantiationException) {
                PublisherError publisherError = new PublisherError("Failed creating: " + string, instantiationException);
                throw publisherError;
            }
            catch (IllegalAccessException illegalAccessException) {
                PublisherError publisherError = new PublisherError("Failed creating: " + string, illegalAccessException);
                throw publisherError;
            }
            catch (ClassCastException classCastException) {
                PublisherError publisherError = new PublisherError("Failed creating: " + string, classCastException);
                throw publisherError;
            }
            catch (Exception exception) {
                PublisherError publisherError = new PublisherError("Failed creating: " + string, exception);
                throw publisherError;
            }
        }
        catch (Throwable throwable) {
            Object var7_17 = null;
            if (!bl) throw throwable;
            Enumeration enumeration2 = _sPublisher.elements();
            while (enumeration2.hasMoreElements()) {
                ((Publisher)enumeration2.nextElement()).publisherExit();
            }
            throw throwable;
        }
    }

    public static synchronized boolean isActive() {
        return s_active;
    }

    private static synchronized void setActive(boolean bl) {
        s_active = bl;
    }

    public static Vector getPublisher() {
        return (Vector)_sPublisher.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setName(String string) {
        Noun noun;
        if (!Spy.isActive() || string == null || string.length() == 0) {
            return;
        }
        Noun noun2 = noun = Noun.getRoot();
        synchronized (noun2) {
            String string2 = noun.getName();
            if (string2 == null || string2.length() == 0) {
                noun.setName(string);
            }
        }
    }

    public static String getName() {
        return Noun.getRoot().getName();
    }

    public static synchronized void exit() {
        Spy.exit(true);
    }

    public static synchronized void exit(boolean bl) {
        if (!Spy.isActive()) {
            return;
        }
        Log.log(DMSUtil.genCompNounPath("Spy/spyExit"), DMSNLSupport.getString("SPY_spyExit"), Level.DEBUG, null);
        if (bl) {
            Spy.dump();
        }
        Log.shutdown();
        Enumeration enumeration = _sPublisher.elements();
        while (enumeration.hasMoreElements()) {
            Publisher publisher = (Publisher)enumeration.nextElement();
            publisher.publisherExit();
        }
        _sPublisher.clear();
        _sPublishInited = false;
        _spy.exit();
        _spy = null;
        DMSProperties.exit();
        DMSUtil.exit();
        _defaultDumpFile = "dms.log";
        Spy.setActive(false);
    }

    public static synchronized void setDumpFile(String string) {
        if (string != null) {
            _defaultDumpFile = string;
        }
    }

    public static synchronized String getDumpFile() {
        return _defaultDumpFile;
    }

    public static synchronized Noun getRoot() {
        return Noun.getRoot();
    }

    private static void checkAlive() {
        if (!Spy.isActive()) {
            throw new IllegalOperation(DMSNLSupport.getMessage(NOT_ALIVE, new Object[]{SPY, ""}));
        }
    }

    public static synchronized TreeNode getTreeNode(String string) {
        Spy.checkAlive();
        Noun noun = Noun.get(string);
        if (noun != null) {
            return noun;
        }
        noun = Noun.get(DMSUtil.getParentFromPath(string));
        String string2 = DMSUtil.getLeafFromPath(string);
        if (noun == null) {
            return null;
        }
        Vector vector = noun.getMetrics();
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                Metric metric = (Metric)vector.elementAt(i);
                if (!metric.getName().equals(string2)) continue;
                return metric;
            }
        }
        return null;
    }

    public static Object getMetricValue(String string) {
        TreeNode treeNode = Spy.getTreeNode(string);
        if (treeNode == null) {
            return null;
        }
        if (!(treeNode instanceof Metric)) {
            return null;
        }
        Metric metric = (Metric)treeNode;
        Object object = metric.getValue();
        return object;
    }

    public static Vector getMetrics(String string) {
        return null;
    }

    public static synchronized void dump() {
        Spy.dump(_defaultDumpFile, true, true);
    }

    public static synchronized void dump(String string, boolean bl, boolean bl2) {
        Spy.checkAlive();
        try {
            FileWriter fileWriter = new FileWriter(string, bl2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            _spy.dump(printWriter, bl);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void dump(PrintWriter printWriter, boolean bl) throws IOException {
        Spy.checkAlive();
        _spy.dump(printWriter, bl);
    }

    public static synchronized Object[] getValues(Metric[] metricArray) {
        return Metric.getValues(metricArray);
    }

    static {
        _sPublisher = new Vector(4);
        s_active = false;
        _sPublishInited = false;
        _defaultDumpFile = "dms.log";
    }
}

