/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import oracle.dms.http.Request;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.spy.Metric;
import oracle.dms.spy.TreeNode;

abstract class TreeletReporter
extends Reporter {
    private static final String[] ROOT_NAME = new String[]{"/"};
    private byte m_includeDescendant = 1;
    private HashMap m_metricValueTable = new HashMap();
    private ArrayList m_metricList = new ArrayList();
    NounTreeletNode m_root = new NounTreeletNode(Noun.getRoot());

    TreeletReporter(Request request) {
        super(request);
    }

    public final void printResponse(PrintWriter printWriter) {
        if (this.m_op == 1) {
            this.printResetResponse(printWriter);
        } else if (this.m_op == 2) {
            this.printSetResponse(printWriter);
        } else {
            this.m_includeDescriptions = this.m_request.includeDescription();
            this.m_includeUnits = this.m_request.includeUnits();
            this.m_includeValues = this.m_request.includeValues();
            this.printGetResponse(printWriter);
        }
    }

    public void clear() {
        this.m_metricValueTable.clear();
        this.m_metricList.clear();
        this.m_root.clear();
    }

    private void startWalkTree(PrintWriter printWriter) {
        printWriter.print("<statistics>\n");
    }

    private void endWalkTree(PrintWriter printWriter) {
        printWriter.print("</statistics>\n");
    }

    abstract void printHeading(PrintWriter var1);

    abstract void printEnding(PrintWriter var1);

    abstract void startPrintNounNode(NounTreeletNode var1, PrintWriter var2);

    abstract void endPrintNounNode(NounTreeletNode var1, PrintWriter var2);

    abstract void printMetricNode(MetricTreeletNode var1, PrintWriter var2);

    private void printGetResponse(PrintWriter printWriter) {
        HashSet hashSet = new HashSet(7);
        HashSet hashSet2 = new HashSet(7);
        this.getTreeletNodes(hashSet, hashSet2, null);
        if (this.m_includeValues) {
            this.queryMetricValues();
        }
        this.printHeading(printWriter);
        this.startWalkTree(printWriter);
        this.walk(this.m_root, printWriter);
        this.endWalkTree(printWriter);
        this.printBadParams(hashSet, hashSet2, printWriter);
        this.printEnding(printWriter);
        hashSet.clear();
        hashSet2.clear();
    }

    private void printSetResponse(PrintWriter printWriter) {
        String string;
        HashSet hashSet = new HashSet(7);
        HashSet hashSet2 = new HashSet(7);
        HashSet hashSet3 = new HashSet();
        this.getTreeletNodes(hashSet, hashSet2, hashSet3);
        if (hashSet3.size() <= 0 || (string = this.m_request.getNewValue()) == null || string.length() > 0) {
            // empty if block
        }
        this.printHeading(printWriter);
        this.printBadParams(hashSet, hashSet2, printWriter);
        this.printEnding(printWriter);
        hashSet.clear();
        hashSet2.clear();
        hashSet3.clear();
    }

    private void printResetResponse(PrintWriter printWriter) {
        HashSet hashSet = new HashSet(7);
        HashSet hashSet2 = new HashSet(7);
        HashSet hashSet3 = new HashSet();
        this.getTreeletNodes(hashSet, hashSet2, hashSet3);
        if (hashSet3.size() > 0) {
            Iterator iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Sensor)) continue;
                ((Sensor)e).reset();
            }
        }
        this.printHeading(printWriter);
        this.printBadParams(hashSet, hashSet2, printWriter);
        this.printEnding(printWriter);
        hashSet.clear();
        hashSet2.clear();
        hashSet3.clear();
    }

    private void getTreeletNodes(Collection collection, Collection collection2, Collection collection3) {
        this.m_includeDescendant = this.m_request.includeDescendents("children") ? (byte)2 : (this.m_request.includeDescendents("none") ? (byte)0 : (this.m_request.includeDescendents("all") ? (byte)1 : (this.m_op == 3 ? (byte)1 : (this.m_op == 1 ? (byte)2 : (byte)0))));
        String[] stringArray = this.m_request.getTables();
        this.getTreeletNodeByTables(stringArray, collection2, this.m_root, collection3);
        String[] stringArray2 = this.m_request.getNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            if (stringArray == null || stringArray.length == 0) {
                stringArray2 = ROOT_NAME;
            } else {
                return;
            }
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (string.length() == 0) continue;
            if (string.charAt(0) != '/') {
                collection.add(string);
                continue;
            }
            TreeletNode treeletNode = this.getDescendant(this.m_root, string.substring(1), string.charAt(0), collection3);
            if (treeletNode != null) continue;
            collection.add(string);
        }
    }

    final Object getMetricValue(MetricTreeletNode metricTreeletNode) {
        Metric metric = (Metric)metricTreeletNode.getNode();
        return this.m_metricValueTable.get(metric);
    }

    private TreeletNode getDescendant(NounTreeletNode nounTreeletNode, String string, char c, Collection collection) {
        Object object;
        String string2;
        if (nounTreeletNode == null || string == null) {
            return null;
        }
        if (string.length() == 0) {
            this.getDescendants(nounTreeletNode, collection);
            return nounTreeletNode;
        }
        int n = string.indexOf(c);
        String string3 = null;
        if (n == 0) {
            return null;
        }
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        Noun noun = (Noun)nounTreeletNode.getNode();
        TreeletNode treeletNode = nounTreeletNode.findNoun(string2);
        if (treeletNode == null && (object = noun.getChild(string2)) != null) {
            treeletNode = new NounTreeletNode(string2, nounTreeletNode, (Noun)object);
        }
        if (treeletNode == null) {
            if (string3 != null && string3.length() > 0) {
                return null;
            }
            treeletNode = nounTreeletNode.findMetric(string2);
            if (treeletNode != null) {
                return treeletNode;
            }
            n = string2.lastIndexOf(46);
            if (n <= 0) {
                return null;
            }
            object = noun.getSensor(string2.substring(0, n));
            if (object == null) {
                return null;
            }
            Metric metric = ((Sensor)object).getMetric(string2);
            if (metric != null) {
                this.m_metricList.add(metric);
                treeletNode = new MetricTreeletNode(string2, nounTreeletNode, metric, this);
            }
            if (collection != null && treeletNode != null) {
                collection.add(object);
            }
            return treeletNode;
        }
        if (treeletNode instanceof MetricTreeletNode) {
            return treeletNode;
        }
        if (string3 != null && string3.length() > 0) {
            return this.getDescendant((NounTreeletNode)treeletNode, string3, c, collection);
        }
        this.getDescendants((NounTreeletNode)treeletNode, collection);
        return treeletNode;
    }

    private void getDescendants(NounTreeletNode nounTreeletNode, Collection collection) {
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Noun noun = (Noun)nounTreeletNode.getNode();
        Sensor[] sensorArray = noun.getSensors();
        if (sensorArray != null && (this.m_includeDescendant == 1 || this.m_includeDescendant == 2)) {
            for (int i = sensorArray.length - 1; i >= 0; --i) {
                if (collection != null) {
                    collection.add(sensorArray[i]);
                }
                object4 = new Vector();
                sensorArray[i].getMetrics((Vector)object4);
                object3 = ((Vector)object4).elements();
                while (object3.hasMoreElements()) {
                    object2 = (Metric)object3.nextElement();
                    object = ((TreeNode)object2).getName();
                    MetricTreeletNode metricTreeletNode = nounTreeletNode.findMetric((String)object);
                    if (metricTreeletNode != null) continue;
                    this.m_metricList.add(object2);
                    new MetricTreeletNode(((TreeNode)object2).getName(), nounTreeletNode, object2, this);
                }
            }
        }
        if (this.m_includeDescendant == 1 && (vector = noun.getNouns()) != null) {
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                object3 = (Noun)object4.nextElement();
                object2 = ((TreeNode)object3).getName();
                object = nounTreeletNode.findNoun((String)object2);
                if (object == null) {
                    object = new NounTreeletNode((String)object2, nounTreeletNode, (Noun)object3);
                }
                this.getDescendants((NounTreeletNode)object, collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryMetricValues() {
        Metric[] metricArray = null;
        Object[] objectArray = this.m_metricList;
        synchronized (this.m_metricList) {
            metricArray = new Metric[this.m_metricList.size()];
            this.m_metricList.toArray(metricArray);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectArray = Metric.getValues(metricArray);
            for (int i = 0; i < metricArray.length; ++i) {
                this.m_metricValueTable.put(metricArray[i], objectArray[i]);
            }
            return;
        }
    }

    private void getTreeletNodeByTables(String[] stringArray, Collection collection, NounTreeletNode nounTreeletNode, Collection collection2) {
        if (stringArray == null || stringArray.length == 0 || nounTreeletNode == null) {
            return;
        }
        ArrayList arrayList = this.getNounsByTables(stringArray, collection);
        if (arrayList == null) {
            return;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Noun[] nounArray = (Noun[])arrayList.get(i);
            if (nounArray == null || nounArray.length == 0) continue;
            for (int j = 0; j < nounArray.length; ++j) {
                this.getTreeletNodeByNoun(nounTreeletNode, nounArray[j], collection2);
            }
        }
    }

    private ArrayList getNounsByTables(String[] stringArray, Collection collection) {
        ArrayList<Noun[]> arrayList = new ArrayList<Noun[]>();
        if (stringArray == null || stringArray.length == 0) {
            return arrayList;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            Noun[] nounArray = Noun.getNounsByType(stringArray[i]);
            if (nounArray == null || nounArray.length == 0) {
                collection.add(stringArray[i]);
                continue;
            }
            arrayList.add(nounArray);
        }
        return arrayList;
    }

    private void getTreeletNodeByNoun(NounTreeletNode nounTreeletNode, Noun noun, Collection collection) {
        Object object;
        ArrayList<Noun> arrayList = new ArrayList<Noun>();
        Noun noun2 = Noun.getRoot();
        for (object = noun; object != noun2; object = ((TreeNode)object).getParent()) {
            arrayList.add((Noun)object);
        }
        object = nounTreeletNode;
        Object object2 = nounTreeletNode;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Noun noun3 = (Noun)arrayList.get(i);
            String string = noun3.getName();
            object = ((NounTreeletNode)object2).findNoun(string);
            if (object == null) {
                object = new NounTreeletNode(string, (NounTreeletNode)object2, noun3);
            }
            object2 = object;
        }
        arrayList.clear();
        if (this.m_includeDescendant == 1 || this.m_includeDescendant == 2) {
            this.getDescendants((NounTreeletNode)object, collection);
        }
    }

    private void walk(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        Object object;
        Object object2;
        Collection collection;
        if (nounTreeletNode != this.m_root) {
            this.startPrintNounNode(nounTreeletNode, printWriter);
        }
        if ((collection = nounTreeletNode.getMetrics(this.m_isOrdered)) != null && collection.size() > 0) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (MetricTreeletNode)object2.next();
                this.printMetricNode((MetricTreeletNode)object, printWriter);
            }
            if (this.m_isOrdered) {
                collection.clear();
            }
        }
        if ((object2 = nounTreeletNode.getNouns(this.m_isOrdered)) != null && object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                NounTreeletNode nounTreeletNode2 = (NounTreeletNode)object.next();
                this.walk(nounTreeletNode2, printWriter);
            }
            if (this.m_isOrdered) {
                object2.clear();
            }
        }
        if (nounTreeletNode != this.m_root) {
            this.endPrintNounNode(nounTreeletNode, printWriter);
        }
    }
}

