/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.util.DMSNLSupport;

public class RawReporter
extends TreeletReporter {
    public RawReporter(Request request) {
        super(request);
        this.m_isOrdered = true;
    }

    void printHeading(PrintWriter printWriter) {
        printWriter.print("<DMSDUMP version='");
        printWriter.print("9.0.4");
        printWriter.print("' timestamp='");
        long l = System.currentTimeMillis();
        printWriter.print(l);
        printWriter.print(" (");
        Date date = new Date(l);
        printWriter.print(date);
        printWriter.print(")' id='");
        printWriter.print(this.m_id);
        printWriter.print("' name='");
        printWriter.print(this.m_name);
        printWriter.print("'>\n");
    }

    void printEnding(PrintWriter printWriter) {
        printWriter.print("</DMSDUMP>\n");
    }

    void startPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        this.m_indent.increIndent();
        this.m_indent.indent(printWriter);
        printWriter.print(nounTreeletNode);
        printWriter.print(" [type=");
        printWriter.print(nounTreeletNode.getTable());
        printWriter.println(']');
    }

    void printMetricNode(MetricTreeletNode metricTreeletNode, PrintWriter printWriter) {
        this.m_indent.increIndent();
        this.m_indent.indent(printWriter);
        printWriter.print(metricTreeletNode.getName());
        printWriter.print(":\t");
        Object object = metricTreeletNode.getObjValue();
        if (object instanceof ErrorObject) {
            printWriter.println(DMSNLSupport.getString("NO_VALUE"));
        } else {
            printWriter.print(object);
            printWriter.print('\t');
            printWriter.println(metricTreeletNode.getUnit());
        }
        this.m_indent.decreIndent();
    }

    void endPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        this.m_indent.decreIndent();
    }
}

