/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.RollupSensor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;

public class Rollup
implements GroupRefresh {
    Noun m_top = null;
    Noun m_noun = null;
    State m_count = null;
    String m_type = null;
    boolean m_recurse;
    boolean m_init = false;
    long m_lastRefreshTime = 0L;
    HashMap m_sensors = new HashMap();
    Collection m_ru_sensors = this.m_sensors.values();
    PhaseEvent m_phase = null;

    private Rollup() {
    }

    public Rollup(Noun noun, State state, String string, boolean bl) {
        this.m_top = noun.getParent();
        this.m_noun = noun;
        this.m_count = state;
        this.m_type = string;
        this.m_recurse = bl;
        this.m_phase = PhaseEvent.create(noun, "refresh", "update the rollup metrics");
        this.m_phase.deriveMetric(511);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        long l = 0L;
        try {
            l = this.m_phase.start();
            Noun[] nounArray = this.m_top.getDescendants(this.m_recurse, this.m_type);
            if (nounArray == null) {
                this.m_count.update(0);
                return;
            }
            this.m_count.update(nounArray.length);
            this.updateSensors(nounArray);
            this.m_lastRefreshTime = System.currentTimeMillis();
        }
        finally {
            this.m_phase.stop(l);
        }
    }

    private void updateSensors(Noun[] nounArray) {
        if (nounArray == null || nounArray.length == 0) {
            this.resetSensors();
            return;
        }
        NounDescriptor nounDescriptor = null;
        nounDescriptor = nounArray[0].getDescriptor();
        if (nounDescriptor.getLastUpdateTime() >= this.m_lastRefreshTime) {
            this.update(nounDescriptor, nounArray);
        }
        Iterator iterator = this.m_ru_sensors.iterator();
        RollupSensor rollupSensor = null;
        while (iterator.hasNext()) {
            rollupSensor = (RollupSensor)iterator.next();
            rollupSensor.update(nounArray, this.m_type);
        }
    }

    private void update(NounDescriptor nounDescriptor, Noun[] nounArray) {
        RollupSensor rollupSensor = null;
        SensorDescriptor sensorDescriptor = null;
        String[] stringArray = nounDescriptor.getSensorNames();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            sensorDescriptor = nounDescriptor.getSensorDescriptor(string);
            Sensor sensor = this.getSensor(string, nounArray);
            rollupSensor = (RollupSensor)this.m_sensors.get(string);
            if (rollupSensor == null) {
                rollupSensor = RollupSensor.create(this.m_noun, sensor);
                if (rollupSensor == null) continue;
                rollupSensor.setRefresh(this);
                this.m_sensors.put(string, rollupSensor);
                continue;
            }
            rollupSensor.updateMetrics(sensor);
        }
    }

    private Sensor getSensor(String string, Noun[] nounArray) {
        if (string == null || nounArray == null || nounArray.length == 0) {
            return null;
        }
        Sensor sensor = null;
        for (int i = 0; i < nounArray.length; ++i) {
            sensor = nounArray[i].getSensor(string);
            if (sensor == null) continue;
            return sensor;
        }
        return null;
    }

    private void resetSensors() {
        Iterator iterator = this.m_ru_sensors.iterator();
        RollupSensor rollupSensor = null;
        while (iterator.hasNext()) {
            rollupSensor = (RollupSensor)iterator.next();
            rollupSensor.reset();
        }
    }
}

