/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.dms.http.SimpleRequest;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.NounDumperThread;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.NounTypeListener;
import oracle.dms.instrument.Rollup;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTrace;
import oracle.dms.reporter.Agency;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SimpleAgency;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Spy;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Noun
extends TreeNode
implements NounIntf {
    private static final String RU_SUFFIX = "_rollup";
    private static final String RU_DESCENDENTS = "descendents";
    private static final String RU_DESCENDENTS_DESC = "which descendents are canditate nouns for rollup";
    private static final String RU_COUNT = "rolled";
    private static final String RU_UNITS = "nouns";
    private static final String RU_COUNT_DESC = "number of nouns rolled up in aggregated metrics";
    private static final Level INITIAL_LOG_LEVEL = Level.NOTIFICATION;
    private Level _enabledLogLevel = Level.OFF;
    private HashMap _logProperties = null;
    private ArrayList _logWriters = new ArrayList();
    private ArrayList _cachedRefs = null;
    private static Hashtable _nounCache = new Hashtable();
    private static Vector _nounTypeListeners = new Vector(3);
    private static Hashtable _descMap = new Hashtable();
    private NounDescriptor _descptor = null;
    private long _createTime = System.currentTimeMillis();
    private static Noun _rootNoun = new Noun();
    private static int _status = 0;
    private Vector _childNouns = new Vector();
    private Vector _sensors = new Vector();
    private NounDumperThread _dumperThread = null;
    private boolean definitelyNotTraceable = false;
    private static final String NOUN_DESC = "Noun";
    private static final String ROOT_TYPE = "DMS_ROOT";
    private static final String DRILLDOWN_TYPE_PREFIX = "xxx_";
    private static final String DRILLDOWN_INDICATOR = "CALLS_TO";
    private String _type = "n/a";
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER";
    private static final String PARAM_ERROR = "PARAM_ERROR";
    private static final String PARAM_ERROR3 = "PARAM_ERROR3";
    private static final String NOUN_ROOT = "NOUN_ROOT";
    private static final String NOUN_INIT_ERROR = "NOUN_INIT_ERROR";
    private static final String NOT_ALIVE = "NOT_ALIVE";
    private static final String ALREADY_REMOVED = "ALREADY_REMOVED";
    private static final String CANT_DELETE_ROOT = "CANT_DELETE_ROOT";

    private Noun() {
        super(null, "Process" + DMSUtil.getProcessID(), NOUN_DESC);
        this._type = ROOT_TYPE;
        _rootNoun = this;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Level", Level.DEBUG.toString());
        this._logProperties = hashMap;
        this._enabledLogLevel = INITIAL_LOG_LEVEL;
        if (_status != 2) {
            try {
                Spy.init();
                _status = 1;
            }
            catch (Exception exception) {
                System.err.println(DMSNLSupport.getMessage(NOUN_INIT_ERROR, new Object[]{exception.toString()}, "Noun Could not initialize: " + exception.toString()));
                exception.printStackTrace();
            }
        }
    }

    public Noun(Noun noun, String string, String string2) {
        super(noun, string, NOUN_DESC);
        Object object;
        Object object2;
        if (string2 != null && string2.length() > 0 && !string2.equals("n/a")) {
            this._type = DMSUtil.sanitize(string2, 511, true, true);
        }
        if (noun == null || string.length() < 1) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), noun, string, string2}, "Malformed Noun: " + noun + ":" + string + ":" + string2));
        }
        this._parent.childAdded(this);
        this._enabledLogLevel = INITIAL_LOG_LEVEL;
        if (DMSProperties.hasNounProperties() && (object2 = DMSProperties.getNounProperties(this.toString())) != null) {
            List list;
            object = (String)object2.get("loglevel");
            if (object != null) {
                this.setLogLevel(Level.getLevel((String)object), false);
            }
            if ((list = (List)object2.get("logwriter")) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = (String)list.get(i);
                    LogWriter logWriter = Log.getLogWriter(string3);
                    if (logWriter == null) continue;
                    this.addLogWriter(logWriter);
                }
            }
        }
        if ((object2 = StatisticsProducer._nounCreate) != null) {
            ((Event)object2).occurred(new Object[]{this});
        } else {
            ++StatisticsProducer._nounCreateCount;
        }
        this.rememberType();
        if (TransTrace._isEnabled() && this.isTraceable()) {
            if (this._type.equals("oc4j_servlet") && this._name.equals("jsp")) {
                this.definitelyNotTraceable = true;
            }
            if ((object = ExecutionContext.get().getTracer()) != null) {
                ((Tracer)object).append(this, 7);
            }
        }
    }

    public static Noun create(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0) {
            throw new InstrumentationException(DMSNLSupport.getMessage(PARAM_ERROR3, new Object[]{"Noun.create()", string, string2}, "Noun.create(): parameter check failed: pathname =" + string + ", type = " + string2));
        }
        Noun noun = Noun.get(string);
        if (noun != null) {
            return noun;
        }
        String string3 = DMSUtil.removeTrailingDelimFromPath(string);
        String string4 = DMSUtil.getLeafFromPath(string3);
        String string5 = DMSUtil.getParentFromPath(string3);
        Noun noun2 = string5.length() > 0 ? Noun.create(string5) : Noun.getRoot();
        return Noun.create(noun2, string4, string2);
    }

    public static Noun create(String string) {
        return Noun.create(string, "n/a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun create(Noun noun, String string, String string2) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException(DMSNLSupport.getMessage(PARAM_ERROR, new Object[]{"Noun.create()", noun, string, string2}, "Noun.create(): parameter check failed: parent= " + noun + ", name= " + string + ", type= " + string2));
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            Noun noun3 = noun.getChild(string);
            if (noun3 != null) {
                return noun3;
            }
            return new Noun(noun, string, string2);
        }
    }

    public static String getType(String string) {
        Noun noun = Noun.get(string);
        if (noun != null) {
            return noun.getType();
        }
        return null;
    }

    public String getType() {
        return this._type;
    }

    public boolean isTraceable() {
        return !this.definitelyNotTraceable && this._descptor != null && this._descptor.isTraceable();
    }

    public static void setType(String string, String string2) {
        Noun noun = Noun.get(string);
        if (noun != null) {
            noun.setType(string2);
        }
    }

    public synchronized void setType(String string) {
        if (string != null && string.length() > 0) {
            this.forgetType();
            if (!string.equals("n/a")) {
                this._type = DMSUtil.sanitize(string, 511, true, true);
            }
            this.rememberType();
        }
    }

    public NounDescriptor getDescriptor() {
        return this._descptor;
    }

    public static Noun get(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        Noun noun = (Noun)_nounCache.get(string);
        if (noun != null) {
            return noun;
        }
        String string2 = DMSUtil.sanitize(string, 511, false, false);
        if (string2.length() == 1) {
            return Noun.getRoot();
        }
        char c = string2.charAt(0);
        Noun noun2 = Noun.getRoot();
        int n2 = 1;
        boolean bl = false;
        do {
            String string3;
            if ((n = string2.indexOf(c, n2)) == n2) {
                return null;
            }
            if (n < 0) {
                string3 = string2.substring(n2);
                bl = true;
            } else {
                string3 = string2.substring(n2, n);
            }
            noun2 = noun2.getChild(string3);
            if (noun2 == null) {
                return null;
            }
            if (!bl) continue;
            noun2.addToCache(string);
            if (!string.equals(string2)) {
                noun2.addToCache(string2);
            }
            return noun2;
        } while ((n2 = n + 1) < string2.length());
        noun2.addToCache(string);
        if (!string.equals(string2)) {
            noun2.addToCache(string2);
        }
        return noun2;
    }

    private synchronized void addToCache(String string) {
        if (!this._alive) {
            return;
        }
        Noun noun = _nounCache.put(string, this);
        if (noun != null) {
            return;
        }
        if (this._cachedRefs == null) {
            this._cachedRefs = new ArrayList();
        }
        this._cachedRefs.add(string);
    }

    private synchronized void cleanupCache() {
        if (this._cachedRefs == null) {
            return;
        }
        for (int i = 0; i < this._cachedRefs.size(); ++i) {
            String string = (String)this._cachedRefs.get(i);
            _nounCache.remove(string);
        }
        this._cachedRefs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberType() {
        if (this == _rootNoun || "n/a".equals(this._type) || this._type.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return;
        }
        boolean bl = false;
        Cloneable cloneable = _descMap;
        synchronized (cloneable) {
            this._descptor = (NounDescriptor)_descMap.get(this._type);
            if (this._descptor == null) {
                this._descptor = new NounDescriptor(this._type);
                _descMap.put(this._type, this._descptor);
                bl = true;
            }
            this._descptor.addNoun(this);
        }
        this._descptor.addAncestorTypes(this._parent);
        if (bl) {
            cloneable = (Vector)_nounTypeListeners.clone();
            Enumeration enumeration = ((Vector)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                NounTypeListener nounTypeListener = (NounTypeListener)enumeration.nextElement();
                nounTypeListener.created(this._type);
            }
            ((Vector)cloneable).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetType() {
        if (this == _rootNoun || "n/a".equals(this._type) || this._type.startsWith(DRILLDOWN_TYPE_PREFIX)) {
            return;
        }
        boolean bl = false;
        Cloneable cloneable = _descMap;
        synchronized (cloneable) {
            this._descptor = (NounDescriptor)_descMap.get(this._type);
            if (this._descptor != null) {
                this._descptor.removeNoun(this);
                if (this._descptor.getNounCount() == 0) {
                    _descMap.remove(this._type);
                    bl = true;
                }
            }
        }
        if (bl) {
            cloneable = (Vector)_nounTypeListeners.clone();
            Enumeration enumeration = ((Vector)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                NounTypeListener nounTypeListener = (NounTypeListener)enumeration.nextElement();
                nounTypeListener.removed(this._type);
            }
            ((Vector)cloneable).clear();
        }
    }

    public synchronized Sensor[] getSensors() {
        if (!this._alive) {
            return new Sensor[0];
        }
        Object[] objectArray = new Sensor[this._sensors.size()];
        this._sensors.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Vector getMetrics() {
        Vector vector = new Vector();
        if (!this._alive) {
            return vector;
        }
        for (int i = this._sensors.size() - 1; i >= 0; --i) {
            Sensor sensor = (Sensor)this._sensors.elementAt(i);
            sensor.getMetrics(vector);
        }
        return vector;
    }

    public synchronized Vector getNouns() {
        if (!this._alive) {
            return new Vector(0);
        }
        return (Vector)this._childNouns.clone();
    }

    int getNumChildNouns() {
        return this._childNouns.size();
    }

    protected synchronized void childAdded(Noun noun) {
        int n;
        if (!this._alive) {
            return;
        }
        int n2 = this._childNouns.size();
        String string = noun.getName();
        for (n = 0; n < n2; ++n) {
            Noun noun2 = (Noun)this._childNouns.elementAt(n);
            if (string.compareTo(noun2._name) <= 0) break;
        }
        this._childNouns.insertElementAt(noun, n);
    }

    protected synchronized void sensorAdded(Sensor sensor) {
        Sensor sensor2;
        int n;
        if (!this._alive) {
            return;
        }
        int n2 = this._sensors.size();
        String string = sensor.getName();
        for (n = 0; n < n2 && string.compareTo((sensor2 = (Sensor)this._sensors.elementAt(n)).getName()) > 0; ++n) {
        }
        this._sensors.insertElementAt(sensor, n);
    }

    protected synchronized void childDestroyed(Noun noun) {
        if (!this._childNouns.removeElement(noun)) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ALREADY_REMOVED, new Object[]{noun.getClass().getName()}));
        }
    }

    protected synchronized void sensorDestroyed(Sensor sensor) {
        if (!this._sensors.removeElement(sensor)) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ALREADY_REMOVED, new Object[]{sensor.getClass().getName()}));
        }
    }

    public static Noun getRoot() {
        return _rootNoun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            Noun noun;
            Noun noun2 = noun = this.getParent();
            synchronized (noun2) {
                Noun noun3 = this;
                synchronized (noun3) {
                    if (!this._alive) {
                        return;
                    }
                    super.destroy();
                    this._alive = false;
                    this.cleanupCache();
                    Event event = StatisticsProducer._nounDestroy;
                    if (event != null) {
                        event.occurred(new Object[]{this});
                    }
                    this.forgetType();
                    this._parent.childDestroyed(this);
                    this.invalidateSubtree();
                }
            }
            this.disableDumping();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void invalidateSubtree() {
        Object object;
        while (this._sensors.size() > 0) {
            object = (Sensor)this._sensors.firstElement();
            ((Sensor)object).destroy();
        }
        while (this._childNouns.size() > 0) {
            object = (Noun)this._childNouns.firstElement();
            ((Noun)object).destroy();
        }
    }

    public TreeNode search(TreeNode treeNode, String string) {
        TreeNode[] treeNodeArray = this.search(string);
        return treeNodeArray == null ? null : treeNodeArray[0];
    }

    public TreeNode[] search(String string) {
        Vector vector = new Vector();
        this.doSearch(string, vector);
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new TreeNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void doSearch(String string, Vector vector) {
        TreeNode treeNode;
        int n;
        Vector vector2;
        if (this._name.indexOf(string) != -1) {
            vector.addElement(this);
        }
        if ((vector2 = this.getMetrics()) != null) {
            for (n = vector2.size() - 1; n >= 0; --n) {
                treeNode = (Metric)vector2.elementAt(n);
                String string2 = treeNode.getName();
                if (string2.indexOf(string) == -1) continue;
                vector.addElement(treeNode);
            }
        }
        if (this._childNouns != null) {
            for (n = this._childNouns.size() - 1; n >= 0; --n) {
                treeNode = (Noun)this._childNouns.elementAt(n);
                super.doSearch(string, vector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Noun[] getDescendants(boolean bl, String string) {
        if (bl) {
            return this.getDescendants(string);
        }
        int n = 0;
        int n2 = 0;
        Noun[] nounArray = null;
        Noun[] nounArray2 = this;
        synchronized (this) {
            n2 = this._childNouns.size();
            nounArray = new Noun[n2];
            Noun noun = null;
            for (int i = 0; i < n2; ++i) {
                noun = (Noun)this._childNouns.elementAt(i);
                if (!string.equals(noun.getType())) continue;
                nounArray[n++] = noun;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (n == 0) {
                return null;
            }
            n2 = n;
            nounArray2 = new Noun[n2];
            for (int i = 0; i < n2; ++i) {
                nounArray2[i] = nounArray[i];
            }
            return nounArray2;
        }
    }

    public synchronized TreeNode[] getDescendants(boolean bl) {
        Object[] objectArray;
        if (!this._alive) {
            return new TreeNode[0];
        }
        Vector<Noun> vector = new Vector<Noun>();
        if (!bl) {
            int n;
            vector.addElement(this);
            objectArray = this.getMetrics();
            for (n = objectArray.size() - 1; n >= 0; --n) {
                vector.addElement((Noun)objectArray.elementAt(n));
            }
            for (n = this._childNouns.size() - 1; n >= 0; --n) {
                vector.addElement((Noun)this._childNouns.elementAt(n));
            }
        } else {
            this.getDescendants(vector);
        }
        objectArray = new TreeNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void getDescendants(Vector vector) {
        int n;
        if (!this._alive) {
            return;
        }
        vector.addElement(this);
        Vector vector2 = this.getMetrics();
        for (n = vector2.size() - 1; n >= 0; --n) {
            vector.addElement(vector2.elementAt(n));
        }
        for (n = this._childNouns.size() - 1; n >= 0; --n) {
            Noun noun = (Noun)this._childNouns.elementAt(n);
            noun.getDescendants(vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Noun[] getNounsByType(String string) {
        if (string == null || string.length() == 0 || "n/a".equals(string)) {
            return null;
        }
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            NounDescriptor nounDescriptor = (NounDescriptor)_descMap.get(string);
            if (nounDescriptor != null) {
                return nounDescriptor.getNouns();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAllTypes() {
        String[] stringArray = null;
        Hashtable hashtable = _descMap;
        synchronized (hashtable) {
            stringArray = new String[_descMap.size()];
            _descMap.keySet().toArray(stringArray);
        }
        return stringArray;
    }

    public static int getTypeCount() {
        return _descMap.size();
    }

    public static NounDescriptor getDescriptorByType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (NounDescriptor)_descMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNounTypeListener(NounTypeListener nounTypeListener) {
        if (nounTypeListener == null) {
            return;
        }
        Cloneable cloneable = _nounTypeListeners;
        synchronized (cloneable) {
            if (_nounTypeListeners.contains(nounTypeListener)) {
                return;
            }
            _nounTypeListeners.add(nounTypeListener);
        }
        cloneable = _descMap;
        synchronized (cloneable) {
            Enumeration enumeration = _descMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                nounTypeListener.created(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNounTypeListener(NounTypeListener nounTypeListener) {
        if (nounTypeListener == null) {
            return;
        }
        Cloneable cloneable = _nounTypeListeners;
        synchronized (cloneable) {
            if (!_nounTypeListeners.contains(nounTypeListener)) {
                return;
            }
            _nounTypeListeners.remove(nounTypeListener);
        }
        cloneable = _descMap;
        synchronized (cloneable) {
            Enumeration enumeration = _descMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                nounTypeListener.removed(string);
            }
        }
    }

    public Noun[] getDescendants(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = this.getDescendantsByType(string);
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Noun[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Vector getDescendantsByType(String string) {
        Vector<Noun> vector = new Vector<Noun>();
        if (string == null || string.length() == 0 || "n/a".equals(string)) {
            return vector;
        }
        Noun[] nounArray = Noun.getNounsByType(string);
        if (nounArray == null) {
            return vector;
        }
        block0: for (int i = nounArray.length - 1; i >= 0; --i) {
            if (this == _rootNoun || nounArray[i] == this) {
                vector.addElement(nounArray[i]);
                continue;
            }
            Noun noun = nounArray[i];
            while (noun != _rootNoun) {
                if (noun == this) {
                    vector.addElement(nounArray[i]);
                    continue block0;
                }
                noun = noun._parent;
            }
        }
        return vector;
    }

    public synchronized Noun getChild(String string) {
        for (int i = 0; i < this._childNouns.size(); ++i) {
            Noun noun = (Noun)this._childNouns.elementAt(i);
            if (!noun._name.equals(string)) continue;
            return noun;
        }
        return null;
    }

    public synchronized Sensor getSensor(String string) {
        for (int i = 0; i < this._sensors.size(); ++i) {
            Sensor sensor = (Sensor)this._sensors.elementAt(i);
            if (!sensor.getName().equals(string)) continue;
            return sensor;
        }
        return null;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public static Noun create(String string, String string2, Properties properties) {
        Noun noun = Noun.create(string, string2);
        if (noun != null) {
            noun.setLoggingProperties(properties);
        }
        return noun;
    }

    public static Noun create(Noun noun, String string, String string2, Properties properties) {
        Noun noun2 = Noun.create(noun, string, string2);
        if (noun2 != null) {
            noun2.setLoggingProperties(properties);
        }
        return noun2;
    }

    public void setLogLevel(Level level, boolean bl) {
        if (!this._alive) {
            return;
        }
        if (level == null) {
            return;
        }
        this._enabledLogLevel = level;
        if (bl) {
            Object object;
            int n;
            for (n = this._childNouns.size() - 1; n >= 0; --n) {
                object = (Noun)this._childNouns.elementAt(n);
                ((Noun)object).setLogLevel(level, true);
            }
            for (n = this._sensors.size() - 1; n >= 0; --n) {
                object = (Sensor)this._sensors.elementAt(n);
                ((Sensor)object).setLogLevel(level);
            }
        } else {
            for (int i = this._sensors.size() - 1; i >= 0; --i) {
                Sensor sensor = (Sensor)this._sensors.elementAt(i);
                sensor.notifyLogLevel(this._enabledLogLevel);
            }
        }
    }

    public void setLogLevel(LogLevel logLevel, boolean bl) {
        this.setLogLevel((Level)logLevel, bl);
    }

    public Level getLogLevel() {
        return this._enabledLogLevel;
    }

    public static void setLogLevel(String string, Level level, boolean bl) {
        Noun noun = Noun.get(string);
        if (noun != null) {
            noun.setLogLevel(level, bl);
        }
    }

    public static void setLogLevel(String string, LogLevel logLevel, boolean bl) {
        Noun.setLogLevel(string, (Level)logLevel, bl);
    }

    public static Level getLogLevel(String string) {
        Noun noun = Noun.get(string);
        if (noun != null) {
            return noun.getLogLevel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogWriter(LogWriter logWriter) {
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            if (!this._logWriters.contains(logWriter)) {
                this._logWriters.add(logWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogWriter(LogWriter logWriter) {
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            this._logWriters.remove(logWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogWriter[] getLogWriters() {
        LogWriter[] logWriterArray;
        ArrayList arrayList = this._logWriters;
        synchronized (arrayList) {
            logWriterArray = this._logWriters.toArray(new LogWriter[this._logWriters.size()]);
        }
        return logWriterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(LogMessage logMessage, boolean bl) {
        for (Noun noun = this; noun != null; noun = noun.getParent()) {
            ArrayList arrayList = noun._logWriters;
            synchronized (arrayList) {
                for (int i = 0; i < noun._logWriters.size(); ++i) {
                    ((LogWriter)noun._logWriters.get(i)).write(logMessage, bl);
                    Log.logMsgEventOccurred();
                }
                continue;
            }
        }
    }

    public void setLoggingProperties(Properties properties) {
        this._logProperties = new HashMap<Object, Object>(properties);
    }

    protected String getLogProperty(String string) {
        String string2 = null;
        for (Noun noun = this; noun != null; noun = noun.getParent()) {
            HashMap hashMap = noun._logProperties;
            if (hashMap == null || (string2 = (String)hashMap.get(string)) == null) continue;
            return string2;
        }
        return string2;
    }

    public void disableDumping() {
        if (this._dumperThread != null) {
            try {
                this._dumperThread.interrupt();
                this._dumperThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void enableDumping(int n, String string, int n2, NounDumpListener nounDumpListener) {
        if (!this._alive) {
            return;
        }
        if (n <= 0 || string == null || string.equals("") || n2 <= 0) {
            return;
        }
        if (this._dumperThread != null) {
            return;
        }
        this._dumperThread = new NounDumperThread(this, n, string, n2, nounDumpListener);
        this._dumperThread.setDaemon(true);
        this._dumperThread.start();
    }

    Noun getCousin(Noun noun) {
        if (noun == null) {
            return noun;
        }
        Vector<Noun> vector = new Vector<Noun>();
        Noun noun2 = this;
        while (noun2 != _rootNoun) {
            vector.addElement(noun2);
            noun2 = noun2._parent;
        }
        noun = Noun.create(noun, DRILLDOWN_INDICATOR, "n/a");
        for (int i = vector.size() - 1; i >= 0; --i) {
            noun2 = (Noun)vector.elementAt(i);
            String string = noun2.getType();
            if (!string.equals("n/a")) {
                string = DRILLDOWN_TYPE_PREFIX + string;
            }
            noun = Noun.create(noun, noun2.getName(), string);
            Sensor[] sensorArray = noun2.getSensors();
            for (int j = 0; j < sensorArray.length; ++j) {
                Sensor sensor = sensorArray[j];
                if (!(sensor instanceof State)) continue;
                State.create(noun, sensor.getName(), "", "cousin", sensor.getValue());
            }
        }
        return noun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter printWriter, String string) {
        SimpleAgency simpleAgency = new SimpleAgency();
        SimpleRequest simpleRequest = new SimpleRequest();
        simpleRequest.setParameter("name", this.toString());
        simpleRequest.setParameter("format", string);
        simpleRequest.setParameter("operation", "get");
        simpleRequest.setParameter("units", "true");
        simpleRequest.setParameter("value", "true");
        simpleRequest.setParameter("description", "false");
        simpleRequest.setParameter("recurse", "all");
        try {
            Properties properties = new Properties();
            Reporter reporter = ((Agency)simpleAgency).getReporter(simpleRequest);
            try {
                reporter.printResponse(printWriter);
            }
            catch (Exception exception) {
            }
            finally {
                reporter.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dump(String string, String string2, boolean bl) {
        block8: {
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            PrintWriter printWriter = null;
            fileOutputStream = new FileOutputStream(string, bl);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            printWriter = new PrintWriter(bufferedWriter);
            this.dump(printWriter, string2);
            Object var10_8 = null;
            try {
                printWriter.close();
                bufferedWriter.close();
                outputStreamWriter.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (Exception exception) {
                    Object var10_9 = null;
                    try {
                        printWriter.close();
                        bufferedWriter.close();
                        outputStreamWriter.close();
                        fileOutputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    printWriter.close();
                    bufferedWriter.close();
                    outputStreamWriter.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Noun rollup(String string, byte by) throws InstrumentationException {
        boolean bl;
        String string2;
        if (string == null || string.length() <= 0 || string.equals("n/a")) {
            return null;
        }
        string = DMSUtil.sanitize(string, 511, true, true);
        String string3 = string2 = string + RU_SUFFIX;
        Noun noun = Noun.create(this, string2, string3);
        State state = State.create(noun, RU_DESCENDENTS, (byte)5, "", RU_DESCENDENTS_DESC);
        if (by == 2) {
            state.update("all");
            bl = true;
        } else {
            state.update("direct");
            bl = false;
        }
        State state2 = State.create(noun, RU_COUNT, (byte)3, RU_UNITS, RU_COUNT_DESC);
        state2.update(0);
        Rollup rollup = new Rollup(noun, state2, string, bl);
        state2.setRefresh(rollup);
        return noun;
    }

    public static synchronized void shutdown() {
        _status = 2;
        _rootNoun = new Noun();
        _nounCache.clear();
        _nounTypeListeners.clear();
        _descMap.clear();
        _status = 2;
    }
}

