/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.text.MessageFormat;
import java.util.Properties;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.LoggerIntf;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class Logger
extends Sensor
implements LoggerIntf {
    private int _count = 0;
    private int _logged = 0;

    protected Logger(Noun noun, String string, String string2, Properties properties) {
        this(true, noun, string, string2, properties);
    }

    private Logger(boolean bl, Noun noun, String string, String string2, Properties properties) {
        super(bl, noun, string, string2);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this._metrics[0] = new Metric(this._name + ".logged", this._description, "ops", this, false, 3, 0);
        this.setLoggingProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(Noun noun, String string, String string2, Properties properties) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            String string3 = DMSUtil.sanitize(string, 511, true, true);
            Logger logger = (Logger)noun.getSensor(string3);
            if (logger != null) {
                return logger;
            }
            return new Logger(false, noun, string3, string2, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(String string, String string2, Properties properties) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Logger logger = (Logger)Sensor.lookupCache(string);
        if (logger != null) {
            return logger;
        }
        Noun noun = Sensor.createParent(string);
        String string3 = DMSUtil.getLeafFromPath(string);
        Noun noun2 = noun;
        synchronized (noun2) {
            String string4 = DMSUtil.sanitize(string3, 511, true, true);
            logger = (Logger)noun.getSensor(string4);
            if (logger != null) {
                logger.addToCache(string);
                return logger;
            }
            return new Logger(false, noun, string4, string2, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(Noun noun, String string, String string2) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            String string3 = DMSUtil.sanitize(string, 511, true, true);
            Logger logger = (Logger)noun.getSensor(string3);
            if (logger != null) {
                return logger;
            }
            return new Logger(false, noun, string3, string2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger create(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new InstrumentationException("Logger.create(): bad parameters");
        }
        Logger logger = (Logger)Sensor.lookupCache(string);
        if (logger != null) {
            return logger;
        }
        Noun noun = Sensor.createParent(string);
        String string3 = DMSUtil.getLeafFromPath(string);
        Noun noun2 = noun;
        synchronized (noun2) {
            String string4 = DMSUtil.sanitize(string3, 511, true, true);
            logger = (Logger)noun.getSensor(string4);
            if (logger != null) {
                logger.addToCache(string);
                return logger;
            }
            return new Logger(false, noun, string4, string2, null);
        }
    }

    public synchronized void log() {
        ++this._count;
        if (this.isLoggable()) {
            ++this._logged;
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append(this._count);
            stringBuffer.append(" ops, ");
            stringBuffer.append(this._logged);
            stringBuffer.append(" logged");
            this.logActivation(stringBuffer.toString());
        }
    }

    public synchronized void log(Level level, String string, Throwable throwable, Properties properties) {
        ++this._count;
        if (this.isLoggable(level)) {
            ++this._logged;
            this.logActivation(level, string, throwable, properties);
        }
    }

    public synchronized void log(LogLevel logLevel, String string, Throwable throwable, Properties properties) {
        this.log((Level)logLevel, string, throwable, properties);
    }

    public void log(Level level, String string) {
        this.log(level, string, null, null);
    }

    public synchronized void log(LogLevel logLevel, String string) {
        this.log((Level)logLevel, string, null, null);
    }

    public void log(Level level, String string, Throwable throwable) {
        this.log(level, string, throwable, null);
    }

    public void log(LogLevel logLevel, String string, Throwable throwable) {
        this.log((Level)logLevel, string, throwable, null);
    }

    public void log(Level level, String string, Properties properties) {
        this.log(level, string, null, properties);
    }

    public void log(LogLevel logLevel, String string, Properties properties) {
        this.log(logLevel, string, null, properties);
    }

    public synchronized void log(String string, Throwable throwable, Properties properties) {
        String string2;
        ++this._count;
        Level level = null;
        if (properties != null && (string2 = properties.getProperty("Level")) != null) {
            level = Level.getLevel(string2);
        }
        if (this.isLoggable(level)) {
            ++this._logged;
            this.logActivation(level, string, throwable, properties);
        }
    }

    public void log(String string, Properties properties) {
        this.log(string, (Throwable)null, properties);
    }

    public void log(String string, Throwable throwable) {
        this.log(string, throwable, null);
    }

    public void log(String string) {
        this.log(string, (Throwable)null, null);
    }

    public synchronized void log(Level level, String string, Object[] objectArray) {
        String string2 = null;
        try {
            DMSUtil.cleanFormatArgs(objectArray);
            string2 = MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            string2 = string;
        }
        this.log(level, string2, (Throwable)null, null);
    }

    public void log(LogLevel logLevel, String string, Object[] objectArray) {
        this.log((Level)logLevel, string, objectArray);
    }

    public synchronized void log(String string, Object[] objectArray, Properties properties) {
        String string2 = null;
        try {
            DMSUtil.cleanFormatArgs(objectArray);
            string2 = MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            string2 = string;
        }
        this.log(string2, (Throwable)null, properties);
    }

    public static void log(String string, Level level, String string2, Throwable throwable, Properties properties) {
        ((Logger)Sensor.get(string)).log(level, string2, throwable, properties);
    }

    public static void log(String string, LogLevel logLevel, String string2, Throwable throwable, Properties properties) {
        ((Logger)Sensor.get(string)).log((Level)logLevel, string2, throwable, properties);
    }

    public synchronized Object getValue(Metric metric) {
        if (!this._alive) {
            return new ErrorObject();
        }
        if (metric == null) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to Logger " + this);
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to Logger " + this);
        }
        switch (by) {
            case 1: {
                return new Integer(this._count);
            }
            case 0: {
                return new Integer(this._logged);
            }
        }
        throw new InstrumentationException("Metric: " + metric + " does not belong to Logger " + this);
    }

    public synchronized void reset() {
        this._count = 0;
        this._logged = 0;
    }

    public void deriveMetric(int n) {
    }
}

