/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashMap;
import java.util.Map;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.ExecutionContextForJDBC;
import oracle.dms.instrument.Tracer;

public class ExecutionContext {
    public static final String ATT_ACTION = "Action";
    public static final String ATT_MODULE = "Module";
    public static final String ATT_CLIENTID = "ClientID";
    public static final String ATT_ECIDUID = "ECID_UID";
    public static final String ATT_URI = "URI";
    public static final String ATT_TCONTEXT = "Oracle-TraceContext";
    public static final String ATT_TTRIGGER = "Oracle-TraceTrigger";
    private int m_ECIDSequenceNumber = 0;
    private Tracer m_defaultTracer;
    private Tracer m_tracer;
    private Map m_attMap = new HashMap();
    private ExecutionContextForJDBC m_jdbcCtx = null;
    private static ThreadLocal tlocal = new ThreadLocal();
    private static boolean s_snoAutoIncrement = false;

    private ExecutionContext() {
    }

    public static ExecutionContext get() {
        ExecutionContext executionContext = (ExecutionContext)tlocal.get();
        if (executionContext == null) {
            executionContext = new ExecutionContext();
            tlocal.set(executionContext);
        }
        return executionContext;
    }

    public void setECID(LogMessage.InstanceId instanceId) {
        if (instanceId == null) {
            this.m_attMap.put(ATT_ECIDUID, LogManager.getLogManager().getUniqueId());
            this.m_ECIDSequenceNumber = 0;
            if (this.m_jdbcCtx != null) {
                this.m_jdbcCtx.invalidate();
            }
        } else {
            String string = instanceId.getUniqueId();
            if (string != null) {
                this.m_attMap.put(ATT_ECIDUID, string);
                this.m_ECIDSequenceNumber = instanceId.getSequenceNumber();
                if (this.m_jdbcCtx != null) {
                    this.m_jdbcCtx.invalidate();
                }
            }
        }
    }

    public void incrementECIDSequenceNumber() {
        ++this.m_ECIDSequenceNumber;
    }

    public void setECIDSequenceNumber(int n) {
        this.m_ECIDSequenceNumber = n;
    }

    public int getECIDSequenceNumber() {
        if (ExecutionContext.isSequenceNumberAutoIncrementEnabled()) {
            this.incrementECIDSequenceNumber();
        }
        return this.m_ECIDSequenceNumber;
    }

    public void reset() {
        this.m_tracer = this.m_defaultTracer;
        if (this.m_tracer != null) {
            this.m_tracer.reset();
        }
        this.getAttributeMap().clear();
        this.m_ECIDSequenceNumber = 0;
        if (this.m_jdbcCtx != null) {
            this.m_jdbcCtx.invalidate();
        }
    }

    public LogMessage.InstanceId getECID() {
        String string = (String)this.m_attMap.get(ATT_ECIDUID);
        if (string == null) {
            this.setECID(null);
            string = (String)this.m_attMap.get(ATT_ECIDUID);
        }
        return new LogMessage.InstanceId(string, this.getECIDSequenceNumber());
    }

    public Tracer getTracer() {
        if (this.m_tracer == null) {
            if (this.m_defaultTracer == null) {
                this.m_defaultTracer = new Tracer();
            }
            this.m_tracer = this.m_defaultTracer;
        }
        return this.m_tracer;
    }

    public void setTracer(Tracer tracer) {
        this.m_tracer = tracer;
    }

    public String getECIDasString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_attMap.get(ATT_ECIDUID));
        stringBuffer.append(',');
        stringBuffer.append(this.getECIDSequenceNumber());
        return stringBuffer.toString();
    }

    public Map getAttributeMap() {
        return this.m_attMap;
    }

    public void setAttributeMap(Map map) {
        if (map != null) {
            this.m_attMap = map;
        }
    }

    public void setAttribute(String string, Object object) {
        this.m_attMap.put(string, object);
        if (this.m_jdbcCtx != null) {
            this.m_jdbcCtx.invalidate();
        }
    }

    public static LogMessage.InstanceId parseECID(String string) {
        LogMessage.InstanceId instanceId = null;
        if (string != null && !string.equals("")) {
            String string2 = string;
            int n = 0;
            int n2 = string.length();
            int n3 = string.indexOf(44);
            if (n3 > 0) {
                string2 = string.substring(0, n3);
                ++n3;
                while (n3 < n2 && string.charAt(n3) == ' ') {
                    ++n3;
                }
                if (n3 < n2) {
                    try {
                        n = Integer.parseInt(string.substring(n3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            instanceId = new LogMessage.InstanceId(string2, n);
        }
        return instanceId;
    }

    public static void setSequenceNumberAutoIncrementEnabled(boolean bl) {
        s_snoAutoIncrement = bl;
    }

    private static boolean isSequenceNumberAutoIncrementEnabled() {
        return s_snoAutoIncrement;
    }

    ExecutionContextForJDBC getJdbcCtx() {
        if (this.m_jdbcCtx == null) {
            this.m_jdbcCtx = new ExecutionContextForJDBC();
        }
        return this.m_jdbcCtx;
    }

    static synchronized void shutdown() {
        tlocal = new ThreadLocal();
        s_snoAutoIncrement = false;
    }
}

