/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.util.XMLUtil;

public class ODL11Formatter
implements LogFormatter {
    public static final String MSG = "msg";
    public static final String TIMESTAMP = "time";
    public static final String TIMESTAMP_NORM = "time_norm";
    public static final String ORGANIZATION_ID = "org_id";
    public static final String INSTANCE_ID = "inst_id";
    public static final String COMPONENT_ID = "comp_id";
    public static final String MSG_ID = "msg_id";
    public static final String CLIENT_ID = "client_id";
    public static final String MSG_TYPE = "type";
    public static final String MSG_GROUP = "group";
    public static final String MSG_LEVEL = "level";
    public static final String HOST_ID = "host_id";
    public static final String HOST_ADDR = "host_addr";
    public static final String MODULE_ID = "module";
    public static final String PROCESS_ID = "pid";
    public static final String THREAD_ID = "tid";
    public static final String USER_ID = "user";
    public static final String SUPPL_ATTR = "attr";
    public static final String SUPPL_ATTR_NAME = "name";
    public static final String SUPPL_ATTR_VALUE = "value";
    public static final String UPSTREAM_COMP_ID = "upstream_comp";
    public static final String DOWNSTREAM_COMP_ID = "downstream_comp";
    public static final String ECID = "ecid";
    public static final String RID = "rid";
    public static final String ERROR_ID = "errid";
    public static final String ERROR_SEQ = "err_seq";
    public static final String MSG_TEXT = "txt";
    public static final String MSG_ARG = "arg";
    public static final String MSG_ARG_NAME = "name";
    public static final String MSG_ARG_VALUE = "value";
    public static final String DETAIL_PATH = "detail_path";
    public static final String SUPPL_DETAIL = "suppl_detail";
    public static final String PROBLEM_KEY = "prob_key";
    private DateFormat m_dateFmt = new DateFormat();
    private Date m_date = new Date(0L);
    private static final String LSEP = System.getProperty("line.separator");
    private boolean m_escapeChars = true;
    private boolean m_useHeadAndTail = false;

    public ODL11Formatter(boolean bl) {
        String string = System.getProperty("oracle.core.ojdl.ODL11Formatter.escapeChars");
        if (string == null) {
            string = LogManager.getLogManager().getProperty("ODL11Formatter.escapeChars", "true");
        }
        this.m_escapeChars = string.equalsIgnoreCase("true");
        this.m_useHeadAndTail = bl;
    }

    public ODL11Formatter() {
        this(false);
    }

    public String format(LogMessage logMessage) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<");
        stringBuffer.append(MSG);
        this.attr(stringBuffer, TIMESTAMP, logMessage.getTimestamp());
        if (logMessage.getNormalizedTimestamp() > 0L) {
            this.attr(stringBuffer, TIMESTAMP_NORM, logMessage.getNormalizedTimestamp());
        }
        if (logMessage.getOrganizationId() != null) {
            this.attr(stringBuffer, ORGANIZATION_ID, logMessage.getOrganizationId());
        }
        if (logMessage.getComponentId() != null) {
            this.attr(stringBuffer, COMPONENT_ID, logMessage.getComponentId());
        }
        if (logMessage.getInstanceId() != null) {
            this.attr(stringBuffer, INSTANCE_ID, logMessage.getInstanceId());
        }
        if (logMessage.getMessageId() != null) {
            this.attr(stringBuffer, MSG_ID, logMessage.getMessageId());
        }
        if (logMessage.getHostingClientId() != null) {
            this.attr(stringBuffer, CLIENT_ID, logMessage.getHostingClientId());
        }
        if (logMessage.getMessageType() != null) {
            this.attr(stringBuffer, MSG_TYPE, logMessage.getMessageType().toString());
        } else {
            this.attr(stringBuffer, MSG_TYPE, MessageType.UNKNOWN.toString());
        }
        this.attr(stringBuffer, MSG_LEVEL, logMessage.getMessageLevel());
        if (logMessage.getMessageGroup() != null) {
            this.attr(stringBuffer, MSG_GROUP, logMessage.getMessageGroup());
        }
        if (logMessage.getHostId() != null) {
            this.attr(stringBuffer, HOST_ID, logMessage.getHostId());
        }
        if (logMessage.getHostNwAddr() != null) {
            this.attr(stringBuffer, HOST_ADDR, logMessage.getHostNwAddr());
        }
        if (logMessage.getModuleId() != null) {
            this.attr(stringBuffer, MODULE_ID, logMessage.getModuleId());
        }
        if (logMessage.getProcessId() != null) {
            this.attr(stringBuffer, PROCESS_ID, logMessage.getProcessId());
        }
        if (logMessage.getThreadId() != null) {
            this.attr(stringBuffer, THREAD_ID, logMessage.getThreadId());
        }
        if (logMessage.getUserId() != null) {
            this.attr(stringBuffer, USER_ID, logMessage.getUserId());
        }
        if (logMessage.getUpstreamCompId() != null) {
            this.attr(stringBuffer, UPSTREAM_COMP_ID, logMessage.getUpstreamCompId());
        }
        if (logMessage.getDownstreamCompId() != null) {
            this.attr(stringBuffer, DOWNSTREAM_COMP_ID, logMessage.getDownstreamCompId());
        }
        if (logMessage.getExecContextId() != null) {
            this.attr(stringBuffer, ECID, logMessage.getExecContextId().getUniqueId());
            this.attr(stringBuffer, RID, logMessage.getExecContextId().getSequenceNumber());
        }
        if (logMessage.getErrorInstanceId() != null) {
            this.attr(stringBuffer, ERROR_ID, logMessage.getErrorInstanceId().getUniqueId());
            this.attr(stringBuffer, ERROR_SEQ, logMessage.getErrorInstanceId().getSequenceNumber());
        }
        if (logMessage.getDetailLocation() != null) {
            this.attr(stringBuffer, DETAIL_PATH, logMessage.getDetailLocation());
        }
        if (logMessage.getProblemKey() != null) {
            this.attr(stringBuffer, PROBLEM_KEY, logMessage.getProblemKey());
        }
        stringBuffer.append(">" + LSEP);
        Map map = logMessage.getSupplAttrs();
        if (map != null && !map.isEmpty()) {
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (LogMessage.MessageArgument[])object2.next();
                Object v = map.get(object);
                if (v == null) continue;
                stringBuffer.append(" <");
                stringBuffer.append(SUPPL_ATTR);
                this.attr(stringBuffer, "name", (String)object);
                this.attr(stringBuffer, "value", v.toString());
                stringBuffer.append("/>" + LSEP);
            }
        }
        object2 = logMessage.getMessageText();
        stringBuffer.append(" <txt>");
        if (this.m_escapeChars) {
            XMLUtil.escapeXMLchars((String)object2, stringBuffer);
        } else {
            stringBuffer.append((String)object2);
        }
        stringBuffer.append("</txt>" + LSEP);
        if (logMessage.getMessageArgs() != null) {
            object = logMessage.getMessageArgs();
            for (int i = 0; i < ((LogMessage.MessageArgument[])object).length; ++i) {
                stringBuffer.append(" <arg");
                if (((LogMessage.MessageArgument)object[i]).getName() != null) {
                    this.attr(stringBuffer, "name", ((LogMessage.MessageArgument)object[i]).getName());
                }
                this.attr(stringBuffer, "value", ((LogMessage.MessageArgument)object[i]).getValue());
                stringBuffer.append("/>" + LSEP);
            }
        }
        if ((object = logMessage.getSupplDetail()) != null) {
            stringBuffer.append(" <suppl_detail>");
            if (!this.m_escapeChars || ((String)object).indexOf("]]>") < 0) {
                stringBuffer.append("<![CDATA[");
                stringBuffer.append((String)object);
                stringBuffer.append("]]>");
            } else {
                XMLUtil.escapeXMLchars((String)object, stringBuffer);
            }
            stringBuffer.append("</suppl_detail>" + LSEP);
        }
        stringBuffer.append("</msg>" + LSEP);
        return stringBuffer.toString();
    }

    public String header() {
        if (this.m_useHeadAndTail) {
            return "<?xml version='1.0'?>" + LSEP + "<LOG>" + LSEP;
        }
        return "";
    }

    public String tail() {
        if (this.m_useHeadAndTail) {
            return "</LOG>" + LSEP;
        }
        return "";
    }

    private final void attr(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("='");
        stringBuffer.append(string2);
        stringBuffer.append("'");
    }

    private final void attr(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("='");
        stringBuffer.append(n);
        stringBuffer.append("'");
    }

    private final void attr(StringBuffer stringBuffer, String string, long l) {
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append("='");
        this.m_date.setTime(l);
        this.m_dateFmt.format(this.m_date, stringBuffer);
        stringBuffer.append("'");
    }
}

