/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.text.ParsePosition;
import java.util.Locale;
import oracle.core.ojdl.util.CLFTimestampFormat;
import oracle.core.ojdl.util.ISO8601TimestampFormat;
import oracle.core.ojdl.util.SimpleTimestampFormat;

public abstract class TimestampFormat {
    public static final long ERROR = Long.MIN_VALUE;
    public static final String ISO8601 = "ISO8601";
    public static final String CLF = "CLF";
    public static final String CLF_WITH_BRACKETS = "CLF_WITH_BRACKETS";

    public static TimestampFormat getInstance() {
        return new SimpleTimestampFormat();
    }

    public static TimestampFormat getInstance(String string) {
        return TimestampFormat.getInstance(string, Locale.getDefault());
    }

    public static TimestampFormat getInstance(String string, Locale locale) {
        if (string.equals(ISO8601)) {
            return new ISO8601TimestampFormat();
        }
        if (string.equals(CLF)) {
            return new CLFTimestampFormat(false, locale);
        }
        if (string.equals(CLF_WITH_BRACKETS)) {
            return new CLFTimestampFormat(true, locale);
        }
        return new SimpleTimestampFormat(string, locale);
    }

    public static TimestampFormat getInstance(String string, String string2) {
        return TimestampFormat.getInstance(string, TimestampFormat.toLocale(string2));
    }

    public abstract long parse(String var1, ParsePosition var2);

    public long parse(String string) {
        return this.parse(string, new ParsePosition(0));
    }

    public long parse(char[] cArray, ParsePosition parsePosition) {
        return this.parse(new String(cArray), parsePosition);
    }

    public static Locale toLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        String[] stringArray = new String[]{"", "", ""};
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = string.indexOf(95, n);
            if (n2 < 0) {
                stringArray[i] = string.substring(n);
                break;
            }
            stringArray[i] = string.substring(n, n2);
            n = n2 + 1;
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }
}

