/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.logging.ODLFormatter;

public class SimpleFormatter
extends ODLFormatter {
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LSEP = System.getProperty("line.separator");

    public SimpleFormatter() {
        super((LogFormatter)null);
    }

    public String format(LogRecord logRecord) {
        LogMessage logMessage = this.toLogMessage(logRecord);
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(this.m_dateFormat.format(new Date(logMessage.getTimestamp())));
        stringBuffer.append(" ");
        MessageType messageType = logMessage.getMessageType();
        stringBuffer.append(messageType.toString());
        if (logMessage.getMessageLevel() > 1 && messageType != MessageType.UNKNOWN) {
            stringBuffer.append(":");
            stringBuffer.append(logMessage.getMessageLevel());
        }
        stringBuffer.append(" ");
        String string = logMessage.getMessageId();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        stringBuffer.append(logMessage.getMessageText());
        stringBuffer.append(LSEP);
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        return "";
    }

    public String getTail(Handler handler) {
        return "";
    }
}

