/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.TransactionStateEvent;
import oracle.jbo.TransactionStateListener;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.TypeMarshaller;
import oracle.jbo.domain.BFileDomain;
import oracle.jbo.domain.BlobDomain;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.MarshalledDomain;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainReaderFactory;
import oracle.jbo.domain.XMLDomainWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.MutableStruct;
import oracle.ord.im.ExpectedSQLException;
import oracle.ord.im.MethodNotImplementedException;
import oracle.ord.im.NotConnectedException;
import oracle.ord.im.OrdByteArraySource;
import oracle.ord.im.OrdContentSource;
import oracle.ord.im.OrdDomainIOInterface;
import oracle.ord.im.OrdDomainState;
import oracle.ord.im.OrdDomainSupportInterface;
import oracle.ord.im.OrdDomainUtil;
import oracle.ord.im.OrdFileSource;
import oracle.ord.im.OrdHttpUploadFile;
import oracle.ord.im.OrdHttpUploadFileSource;
import oracle.ord.im.OrdImage;
import oracle.ord.im.OrdImageBase;
import oracle.ord.im.OrdSource;
import oracle.ord.im.WrongTierException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.svcmsg.ResponseValues;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OrdImageDomain
extends OrdImage
implements MarshalledDomain,
TransactionStateListener,
Serializable,
XMLDomainWriter,
XMLDomainReaderFactory,
DomainOwnerInterface,
LobInterface,
AttributeList,
OrdDomainSupportInterface,
OrdDomainState,
OrdDomainIOInterface {
    private int m_tier;
    private boolean m_connected;
    private BlobDomain m_blobDomain;
    private BFileDomain m_bfileDomain;
    private DomainOwnerInterface m_owner;
    private int m_ownerAttrIndex;
    private String m_indexString;
    private boolean m_ownerNotModified;
    private Transaction m_transaction;
    private Object m_lastPostListener;
    private OrdContentSource m_contentSource;
    private boolean m_reuseLobs;
    private String m_ctTempFilePath;
    private boolean m_isAddedToTransaction;
    private boolean m_doneRollback;
    private Exception m_exception;
    private int m_objId;
    private static int m_objIdCounter = 0;
    private static final OrdImageDomain s_ordImageDomainFactory = new OrdImageDomain();
    private static final long serialVersionUID = 7411240566246889784L;
    private boolean m_forClientPostNewDomain;

    private /* synthetic */ void $init$() {
        this.m_tier = 0;
        this.m_connected = false;
        this.m_blobDomain = null;
        this.m_bfileDomain = null;
        this.m_owner = null;
        this.m_ownerAttrIndex = -1;
        this.m_indexString = null;
        this.m_ownerNotModified = true;
        this.m_lastPostListener = null;
        this.m_contentSource = null;
        this.m_reuseLobs = false;
        this.m_ctTempFilePath = null;
        this.m_isAddedToTransaction = false;
        this.m_doneRollback = false;
        this.m_exception = null;
        this.m_objId = -1;
        this.m_forClientPostNewDomain = false;
    }

    public OrdImageDomain() {
        this.$init$();
        this.initConstructor();
    }

    public OrdImageDomain(byte[] byArray) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdByteArraySource(byArray));
    }

    public OrdImageDomain(String string) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdFileSource(string));
    }

    public OrdImageDomain(OrdContentSource ordContentSource) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(ordContentSource);
    }

    public OrdImageDomain(OrdHttpUploadFile ordHttpUploadFile) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdHttpUploadFileSource(ordHttpUploadFile));
    }

    private void initConstructor() {
        try {
            this.setSourceObject(new OrdSource());
            this.setContent(BLOB.empty_lob());
            this.m_blobDomain = new BlobDomain();
            this.m_bfileDomain = new BFileDomain();
            this.m_objId = m_objIdCounter++;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public int getObjectId() {
        return this.m_objId;
    }

    public static CustomDatumFactory getFactory() {
        return s_ordImageDomainFactory;
    }

    public static CustomDatumFactory getCustomDatumFactory() {
        return s_ordImageDomainFactory;
    }

    public String toString() {
        String string = null;
        int n = 0;
        try {
            string = this.getMimeType();
            n = this.getContentLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "OrdImageDomain:" + string + ":" + n;
    }

    public int hashCode() {
        try {
            Timestamp timestamp = this.getUpdateTime();
            int n = timestamp.hashCode() + this.getContentLength();
            return n;
        }
        catch (SQLException sQLException) {
            int n = super.hashCode();
            return n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OrdImageDomain) {
            if (this.m_doneRollback) {
                return this == object;
            }
            try {
                Timestamp timestamp = this.getUpdateTime();
                Timestamp timestamp2 = ((OrdImageDomain)object).getUpdateTime();
                int n = this.getContentLength();
                int n2 = ((OrdImageDomain)object).getContentLength();
                if (timestamp == null && timestamp2 == null && n == n2) {
                    boolean bl = true;
                    return bl;
                }
                if (timestamp.equals(timestamp2) && n == n2) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public BLOB getContent() throws SQLException {
        return super.getContent();
    }

    public BFILE getBFILE() throws SQLException {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdImageDomain.getBFILE()", "Client Tier");
        }
        return super.getBFILE();
    }

    public boolean isLocal() throws SQLException {
        return super.isLocal();
    }

    public void clearLocal() throws SQLException {
        this.domainToBeModified();
        super.clearLocal();
        this.setAttribute();
    }

    public void setLocal() throws SQLException {
        this.domainToBeModified();
        super.setLocal();
        this.setAttribute();
    }

    public void deleteContent() throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("deleteConent()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "deleteContent", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.deleteContent();
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void importData(byte[][] byArray) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("importData()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "importData", new String[]{byArray.getClass().getName()}, new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.importData(byArray);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void importFrom(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("importFrom()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "importFrom", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{byArray, string, string2, string3});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.importFrom(byArray, string, string2, string3);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public boolean loadDataFromFile(String string) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromFile()", "OrdImageDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            FileInputStream fileInputStream = new FileInputStream(string);
            OrdDomainUtil.fromInputToOutput(fileInputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromFile(string);
        }
        this.setAttribute();
        return true;
    }

    public boolean loadDataFromInputStream(InputStream inputStream) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromInputStream()", "OrdImageDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            OrdDomainUtil.fromInputToOutput(inputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromInputStream(inputStream);
        }
        this.setAttribute();
        return true;
    }

    public boolean loadDataFromByteArray(byte[] byArray) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromByteArray()", "OrdImageDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            OrdDomainUtil.fromInputToOutput(byteArrayInputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromByteArray(byArray);
        }
        this.setAttribute();
        return true;
    }

    public void process(String string) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("process()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "process", new String[]{"java.lang.String"}, new Object[]{string});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.process(string);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void setCompressionFormat(String string) throws SQLException {
        this.domainToBeModified();
        super.setCompressionFormat(string);
        this.setAttribute();
    }

    public String getCompressionFormat() throws SQLException {
        return super.getCompressionFormat();
    }

    public void setContentFormat(String string) throws SQLException {
        this.domainToBeModified();
        super.setContentFormat(string);
        this.setAttribute();
    }

    public String getContentFormat() throws SQLException {
        return super.getContentFormat();
    }

    public void setContentLength(int n) throws SQLException {
        this.domainToBeModified();
        super.setContentLength(n);
        this.setAttribute();
    }

    public int getContentLength() throws SQLException {
        return super.getContentLength();
    }

    public String getFormat() throws SQLException {
        return super.getFormat();
    }

    public void setFormat(String string) throws SQLException {
        this.domainToBeModified();
        super.setFormat(string);
        this.setAttribute();
    }

    public void setMimeType(String string) throws SQLException {
        this.domainToBeModified();
        super.setMimeType(string);
        this.setAttribute();
    }

    public String getMimeType() throws SQLException {
        if (this.m_contentSource != null) {
            return this.m_contentSource.getMimeType();
        }
        return super.getMimeType();
    }

    public void setSource(String string, String string2, String string3) throws SQLException {
        this.domainToBeModified();
        super.setSource(string, string2, string3);
        this.setAttribute();
    }

    public String getSourceType() throws SQLException {
        return super.getSourceType();
    }

    public String getSourceLocation() throws SQLException {
        return super.getSourceLocation();
    }

    public String getSourceName() throws SQLException {
        return super.getSourceName();
    }

    public String getSource() throws SQLException {
        String string = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getSource()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                string = (String)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "getSource", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            string = super.getSource();
        }
        return string;
    }

    public boolean checkProperties() throws SQLException {
        boolean bl = false;
        if (!this.m_connected) {
            throw new NotConnectedException("checkProperties()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Boolean bl2 = (Boolean)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "checkProperties", new String[0], new Object[0]);
                bl = bl2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            bl = super.checkProperties();
        }
        return bl;
    }

    public void setProperties() throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("setProperties()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            this.m_exception = null;
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setProperties", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (this.m_exception != null) {
                if (this.m_exception instanceof SQLException) {
                    throw (SQLException)this.m_exception;
                }
                throw new JboException((Throwable)this.m_exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            try {
                this.m_exception = null;
                super.setProperties();
            }
            catch (SQLException sQLException) {
                this.m_exception = sQLException;
                Diagnostic.println((String)("MT setproperties exception:" + sQLException.getMessage()));
            }
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
            if (this.m_exception != null) {
                throw new ExpectedSQLException((SQLException)this.m_exception);
            }
        }
    }

    public void setProperties(String string) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("setProperties()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setProperties", new String[]{"java.lang.String"}, new Object[]{string});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.setProperties(string);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void setUpdateTime(Timestamp timestamp) throws SQLException {
        if (!this.m_connected) {
            this.set_Source(this.get_Source());
            OrdSource ordSource = this.get_Source();
            if (timestamp == null) {
                timestamp = new Timestamp(System.currentTimeMillis());
            }
            ordSource.setUpdatetime(timestamp);
            return;
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setUpdateTime", new String[]{"java.sql.Timestamp"}, new Object[]{timestamp});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.setUpdateTime(timestamp);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public Timestamp getUpdateTime() throws SQLException {
        return super.getUpdateTime();
    }

    public int getWidth() throws SQLException {
        return super.getWidth();
    }

    public void setWidth(int n) throws SQLException {
        this.domainToBeModified();
        super.setWidth(n);
        this.setAttribute();
    }

    public int getHeight() throws SQLException {
        return super.getHeight();
    }

    public void setHeight(int n) throws SQLException {
        this.domainToBeModified();
        super.setHeight(n);
        this.setAttribute();
    }

    public void export(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("export()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "export", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{byArray, string, string2, string3});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.export(byArray, string, string2, string3);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void copy(OrdImage ordImage) throws SQLException {
        OrdImageDomain ordImageDomain = (OrdImageDomain)ordImage;
        if (!this.m_connected) {
            throw new NotConnectedException("copy()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "copy", new String[]{"oracle.ord.im.OrdImage"}, new Object[]{ordImageDomain});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            ordImageDomain.domainToBeModified();
            super.copy((OrdImage)ordImageDomain);
            ordImageDomain.adjustLobDomainsAfterInvoker();
            ordImageDomain.setAttribute();
        }
    }

    public void processCopy(String string, OrdImage ordImage) throws SQLException {
        OrdImageDomain ordImageDomain = (OrdImageDomain)ordImage;
        if (!this.m_connected) {
            throw new NotConnectedException("processCopy()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "processCopy", new String[]{"java.lang.String", "oracle.ord.im.OrdImage"}, new Object[]{string, ordImageDomain});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            ordImageDomain.domainToBeModified();
            super.processCopy(string, (OrdImage)ordImageDomain);
            ordImageDomain.adjustLobDomainsAfterInvoker();
            ordImageDomain.setAttribute();
        }
    }

    public boolean getDataInFile(String string) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInFile()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            OrdDomainUtil.getDataInFile(string, this.getContentAsBlobDomain());
        } else if (this.m_tier == 2) {
            return super.getDataInFile(string);
        }
        return true;
    }

    public InputStream getDataInStream() throws SQLException {
        InputStream inputStream = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInStream()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            inputStream = this.getContentAsBlobDomain().getInputStream();
        } else if (this.m_tier == 2) {
            inputStream = super.getDataInStream();
        }
        return inputStream;
    }

    public byte[] getDataInByteArray() throws SQLException, IOException, OutOfMemoryError {
        byte[] byArray = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInByteArray()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            byArray = this.getContentAsBlobDomain().toByteArray();
        } else if (this.m_tier == 2) {
            byArray = super.getDataInByteArray();
        }
        return byArray;
    }

    public BlobDomain getContentAsBlobDomain() throws SQLException {
        this.initBlobDomain();
        return this.m_blobDomain;
    }

    public BFileDomain getBFileDomain() throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("getBFileDomain()", "OrdImageDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "getBFileDomain", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.m_bfileDomain = new BFileDomain(this.getBFILE());
            this.adjustLobDomainsAfterInvoker();
        }
        return this.m_bfileDomain;
    }

    public void setContentSource(OrdContentSource ordContentSource) {
        this.domainToBeModified();
        if (this.m_contentSource != null) {
            this.m_contentSource.release();
        }
        this.m_contentSource = ordContentSource;
        if (ordContentSource != null) {
            this.addPostListener();
        } else {
            if (this.m_tier == 1 && this.m_lastPostListener != null) {
                OrdDomainUtil.removeOrdPostListener(this.m_transaction, this.m_lastPostListener);
            }
            this.m_lastPostListener = null;
        }
        if (this.m_tier == 1) {
            this.generateTempFilePath();
        }
        this.setAttribute();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    public OrdContentSource getContentSource() {
        return this.m_contentSource;
    }

    private void addPostListener() {
        if (this.m_tier == 1 && this.m_lastPostListener == null) {
            Object object;
            this.m_lastPostListener = object = OrdDomainUtil.getOrdPostListener(this.m_transaction, this);
            OrdDomainUtil.addOrdPostListener(this.m_transaction, object);
        }
    }

    public CustomDatum create(Datum datum, int n) throws SQLException {
        if (datum == null) {
            return null;
        }
        OrdImageDomain ordImageDomain = new OrdImageDomain();
        ordImageDomain._struct = new MutableStruct((STRUCT)datum, OrdImageBase._sqlType, OrdImageBase._factory);
        ordImageDomain._ctx = new OrdImageBase._Ctx(((STRUCT)datum).getJavaSqlConnection());
        ordImageDomain.conn = (OracleConnection)ordImageDomain._ctx.getConnection();
        ordImageDomain.initBlobDomain();
        ordImageDomain.initBFileDomain();
        ordImageDomain.m_tier = 2;
        if (ordImageDomain.conn != null) {
            ordImageDomain.m_connected = true;
        }
        return ordImageDomain;
    }

    public static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return OrdDomainUtil.getXMLDomainFactory(clazz);
    }

    public Node getXMLContentNode(Document document) {
        return OrdDomainUtil.getXMLContentNode(document, this, this.getXMLElementTag());
    }

    public Object createDomainFromSerializedXML(Element element) {
        OrdImageDomain ordImageDomain = new OrdImageDomain();
        return OrdDomainUtil.createDomainFromXMLElement(element, ordImageDomain);
    }

    public Node getSerializedDomainXML(Document document) {
        return OrdDomainUtil.getXMLContentNode(document, this, this.getXMLElementTag());
    }

    protected String getXMLElementTag() {
        return "OrdImageDomain";
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        String string = this.getXMLElementTag();
        return OrdDomainUtil.printXMLDefinition(hashtable, printWriter, bl, string);
    }

    public void domainToBeModified(DomainInterface domainInterface) {
        this.domainToBeModified();
    }

    public Object getAttribute(int n) {
        switch (n) {
            case 0: {
                return this.m_blobDomain;
            }
            case 1: {
                return this.m_bfileDomain;
            }
        }
        return null;
    }

    public Object getAttribute(String string) {
        throw new MethodNotImplementedException("getAttribute(String)", "OrdImageDomain");
    }

    public void setAttribute(int n, Object object) {
        throw new MethodNotImplementedException("setAttribute(int, Object)", "OrdImageDomain");
    }

    public void setAttribute(String string, Object object) {
        throw new MethodNotImplementedException("setAttribute(String, Object)", "OrdImageDomain");
    }

    public int getAttributeCount() {
        throw new MethodNotImplementedException("getAttributeCount()", "OrdImageDomain");
    }

    public int getAttributeIndexOf(String string) {
        throw new MethodNotImplementedException("getAttributeIndexOf(String)", "OrdImageDomain");
    }

    public String[] getAttributeNames() {
        throw new MethodNotImplementedException("getAttributeNames()", "OrdImageDomain");
    }

    public Object[] getAttributeValues() {
        throw new MethodNotImplementedException("getAttributeValues()", "OrdImageDomain");
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            try {
                if (this.m_transaction != null) {
                    OrdImageDomain ordImageDomain = (OrdImageDomain)lobInterface;
                    this.copyObject(ordImageDomain);
                    this.m_connected = true;
                    this.m_blobDomain.syncServerLob((LobInterface)ordImageDomain.m_blobDomain);
                    this.m_ownerNotModified = true;
                    this.m_bfileDomain = new BFileDomain();
                    return;
                }
                OrdImageDomain ordImageDomain = (OrdImageDomain)lobInterface;
                if (this.m_connected && (this.m_reuseLobs || !this.m_reuseLobs && this.m_blobDomain.isCacheDataModified())) {
                    this.setContent(ordImageDomain.getContent());
                    this.m_blobDomain.syncServerLob((LobInterface)ordImageDomain.m_blobDomain);
                    this.m_bfileDomain.syncServerLob((LobInterface)ordImageDomain.m_bfileDomain);
                }
                this.m_owner = ordImageDomain.m_owner;
                this.conn = ordImageDomain.conn;
                this._ctx = ordImageDomain._ctx;
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public void syncClientLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            OrdImageDomain ordImageDomain = (OrdImageDomain)lobInterface;
            try {
                this.syncWithArrivingOne(ordImageDomain);
                if (ordImageDomain.m_blobDomain != null) {
                    this.initBlobDomain();
                    this.m_blobDomain.syncClientLob((LobInterface)ordImageDomain.m_blobDomain);
                } else {
                    this.m_blobDomain = null;
                }
                if (ordImageDomain.m_bfileDomain == null) {
                    this.m_bfileDomain = null;
                }
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public long getSize() {
        int n = 0;
        if (this.m_contentSource != null) {
            try {
                n = this.m_contentSource.getContentLength();
            }
            catch (IOException iOException) {
                throw new JboException((Throwable)iOException);
            }
            return n;
        }
        try {
            this.initBlobDomain();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
        return this.m_blobDomain.getSize();
    }

    public String getRemoteIdString() {
        if (this.m_indexString == null) {
            this.m_indexString = OrdDomainUtil.getRemoteIdString(this);
        }
        return this.m_indexString;
    }

    public void saveToDatabase(Transaction transaction) throws SQLException {
    }

    public void saveToDatabase(Transaction transaction, Object object) throws SQLException, IOException {
        byte[] byArray;
        if (this.m_blobDomain.isCacheDataModified() && (byArray = this.m_blobDomain.toByteArray()).length > 0) {
            this.setContentSource(new OrdByteArraySource(byArray));
        }
        if (this.m_contentSource != null) {
            OrdImageDomain ordImageDomain = (OrdImageDomain)object;
            this.copyObject(ordImageDomain);
            this.m_owner = ordImageDomain.m_owner;
            this.m_ownerAttrIndex = ordImageDomain.m_ownerAttrIndex;
            this.m_connected = true;
            this.m_tier = 2;
            this.initBlobDomain();
            OrdDomainUtil.loadAndSetProperties(this);
            ((AttributeList)this.m_owner).setAttribute(this.m_ownerAttrIndex, (Object)this);
            this.m_ownerNotModified = true;
            OrdDomainUtil.updateRow(this.m_owner);
        }
    }

    public void prepareForDML(Object object) {
        if (this.m_contentSource != null || this.isBlobNull()) {
            try {
                BLOB bLOB = BlobDomain.createEmptyBLOB((Object)object);
                this.setContent(bLOB);
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public void loadFromDatabase(Transaction transaction) throws Exception {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdImageDomain.loadFromDatabase()", "Client Tier");
        }
    }

    public DomainOwnerInterface getOwner() {
        return this.m_owner;
    }

    public int getOwnerAttributeIndex() {
        return this.m_ownerAttrIndex;
    }

    public Object getData() {
        return this;
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        this.m_owner = domainOwnerInterface;
        HashMap hashMap = (HashMap)object;
        Integer n = (Integer)hashMap.get((Object)"0");
        this.m_ownerAttrIndex = n != null ? n : this.m_ownerAttrIndex;
        this.m_tier = 2;
        if (hashMap.get((Object)"3") != null) {
            this.m_tier = 1;
        }
        if (transaction instanceof ApplicationModule) {
            this.m_tier = 1;
        }
        this.m_transaction = transaction;
        HashMap hashMap2 = (HashMap)((HashMap)object).clone();
        hashMap2.put((Object)"0", (Object)new Integer(0));
        this.m_blobDomain.setContext((DomainOwnerInterface)this, transaction, (Object)hashMap2);
        hashMap2.put((Object)"0", (Object)new Integer(1));
        this.m_bfileDomain.setContext((DomainOwnerInterface)this, transaction, (Object)hashMap2);
        this.processCTActivation();
        this.adjustDeferredLoadingSource();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    private void processCTActivation() {
        if (this.m_tier == 1 && this.m_ctTempFilePath != null && this.m_contentSource == null) {
            OrdFileSource ordFileSource = new OrdFileSource(this.m_ctTempFilePath);
            ordFileSource.deleteFileInRelease();
            this.m_contentSource = ordFileSource;
            this.m_ctTempFilePath = null;
            try {
                if (this.getMimeType() != null) {
                    ordFileSource.setMimeType(this.getMimeType());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void adjustDeferredLoadingSource() {
        if (this.m_tier == 1 && this.m_owner != null && this.m_lastPostListener == null && this.getContentSource() != null && !this.m_forClientPostNewDomain) {
            this.addPostListener();
            this.generateTempFilePath();
        }
    }

    public ResponseValues marshal() {
        return TypeMarshaller.serializeObject((Serializable)this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeInt(this.m_ownerAttrIndex);
            objectOutputStream.writeBoolean(this.m_ownerNotModified);
            objectOutputStream.writeBoolean(this.m_connected);
            objectOutputStream.writeObject(this.m_bfileDomain);
            if (this.m_tier == 2) {
                this.m_reuseLobs = true;
            }
            objectOutputStream.writeBoolean(this.m_reuseLobs);
            objectOutputStream.writeObject(this.m_blobDomain);
            objectOutputStream.writeObject(this.get_Height());
            objectOutputStream.writeObject(this.get_Width());
            objectOutputStream.writeObject(this.get_ContentLength());
            objectOutputStream.writeObject(this.getFormat());
            objectOutputStream.writeObject(this.getContentFormat());
            objectOutputStream.writeObject(this.getCompressionFormat());
            objectOutputStream.writeObject(this.getMimeType());
            objectOutputStream.writeObject(this.getSourceType());
            objectOutputStream.writeObject(this.getSourceLocation());
            objectOutputStream.writeObject(this.getSourceName());
            objectOutputStream.writeObject(this.getUpdateTime());
            if (this.isLocal()) {
                objectOutputStream.writeBoolean(true);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            if (this.m_exception != null) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.m_exception);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            objectOutputStream.writeObject(this.m_ctTempFilePath);
            objectOutputStream.writeInt(this.m_objId);
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.setSourceObject(new OrdSource());
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
        try {
            this.m_ownerAttrIndex = objectInputStream.readInt();
            this.m_ownerNotModified = objectInputStream.readBoolean();
            this.m_connected = objectInputStream.readBoolean();
            this.m_bfileDomain = (BFileDomain)objectInputStream.readObject();
            this.m_reuseLobs = objectInputStream.readBoolean();
            this.m_blobDomain = (BlobDomain)objectInputStream.readObject();
            super.set_Height((Integer)objectInputStream.readObject());
            super.set_Width((Integer)objectInputStream.readObject());
            super.set_ContentLength((Integer)objectInputStream.readObject());
            super.setFormat((String)objectInputStream.readObject());
            super.setContentFormat((String)objectInputStream.readObject());
            super.setCompressionFormat((String)objectInputStream.readObject());
            super.setMimeType((String)objectInputStream.readObject());
            String string = (String)objectInputStream.readObject();
            String string2 = (String)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            super.setSource(string, string2, string3);
            Timestamp timestamp = (Timestamp)objectInputStream.readObject();
            this.setLocalUpdateTime(timestamp);
            if (objectInputStream.readBoolean()) {
                super.setLocal();
            } else {
                super.clearLocal();
            }
            boolean bl = objectInputStream.readBoolean();
            if (bl) {
                this.m_exception = (Exception)objectInputStream.readObject();
            }
            this.m_ctTempFilePath = (String)objectInputStream.readObject();
            this.m_objId = objectInputStream.readInt();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    private void domainToBeModified() {
        if (this.m_owner != null && this.m_ownerNotModified) {
            this.m_owner.domainToBeModified((DomainInterface)this);
            this.m_ownerNotModified = false;
        }
    }

    private void setAttribute() {
        if (this.m_owner != null) {
            ((AttributeList)this.m_owner).setAttribute(this.m_ownerAttrIndex, (Object)this);
        }
    }

    private void adjustLobDomainsAfterInvoker() throws SQLException {
        this.initBlobDomain();
    }

    private DomainOwnerInterface getOwnerRow() {
        return OrdDomainUtil.getOwnerRow(this);
    }

    private void initBlobDomain() throws SQLException {
        BLOB bLOB;
        if (this.m_blobDomain == null) {
            this.m_blobDomain = new BlobDomain();
        }
        if ((bLOB = this.getContent()) != null && !bLOB.isEmptyLob()) {
            this.m_blobDomain.useBLOB(bLOB);
        }
    }

    private void initBFileDomain() throws SQLException {
        if (this.m_bfileDomain == null) {
            this.m_bfileDomain = new BFileDomain();
        }
    }

    private boolean isBlobNull() {
        boolean bl = false;
        try {
            bl = this.getContentReadOnly() == null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private void setLocalUpdateTime(Timestamp timestamp) throws SQLException {
        this.set_Source(this.get_Source());
        OrdSource ordSource = this.get_Source();
        ordSource.setUpdatetime(timestamp);
    }

    private void syncWithArrivingOne(OrdImageDomain ordImageDomain) throws SQLException {
        this.m_ownerNotModified = ordImageDomain.m_ownerNotModified;
        this.m_connected = ordImageDomain.m_connected;
        this.m_reuseLobs = ordImageDomain.m_reuseLobs;
        this.m_exception = ordImageDomain.m_exception;
        BLOB bLOB = this.getContentReadOnly();
        this.copyObject(ordImageDomain);
        super.setContent(bLOB);
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public int getTierInfo() {
        return this.m_tier;
    }

    public void setConnected(boolean bl) {
        this.m_connected = bl;
    }

    public void removeListenerFromTransaction() {
        if (this.m_transaction != null) {
            this.m_transaction.removeTransactionStateListener((TransactionStateListener)this);
            this.setAddToTransactionState(false);
        }
    }

    public boolean isAddedToTransaction() {
        return this.m_isAddedToTransaction;
    }

    public void setAddToTransactionState(boolean bl) {
        this.m_isAddedToTransaction = bl;
    }

    public void doneCommit(TransactionStateEvent transactionStateEvent) {
        OrdDomainUtil.releaseContentSourceResource(this);
        this.removeListenerFromTransaction();
    }

    public void doneRollback(TransactionStateEvent transactionStateEvent) {
        this.m_doneRollback = true;
        this.removeListenerFromTransaction();
        if (this.m_tier == 1 && this.m_lastPostListener != null) {
            OrdDomainUtil.removeOrdPostListener(this.m_transaction, this.m_lastPostListener);
        }
        this.m_lastPostListener = null;
        this.m_doneRollback = false;
    }

    public void setContentSourceOnly(OrdContentSource ordContentSource) {
        this.domainToBeModified();
        this.m_contentSource = ordContentSource;
        this.m_forClientPostNewDomain = true;
        this.setAttribute();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    public void setCTPassivationHandle(Object object) {
        this.m_ctTempFilePath = (String)object;
    }

    public Object getCTPassivationHandle() {
        return this.m_ctTempFilePath;
    }

    public void generateTempFilePath() {
        this.m_contentSource = OrdDomainUtil.prepareTempFile(this);
        this.m_ctTempFilePath = ((OrdFileSource)this.m_contentSource).getFileName();
    }

    public void clearContentSource() {
        this.m_contentSource = null;
    }
}

