/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleStatement;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.sql.OracleXMLSQLNoRowsException;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLQueryHandler
extends XSQLActionHandlerImpl {
    private static final String STYLE_PI = "xml-stylesheet";
    private static final String DATE_FORMAT = "date-format";
    private static final String MAX_ROWS = "max-rows";
    private static final String SKIP_ROWS = "skip-rows";
    private static final String ROWSET_ELT = "rowset-element";
    private static final String DOC_ELT = "doc-element";
    private static final String ROW_ELT = "row-element";
    private static final String ID_ATTR = "id-attribute";
    private static final String ID_ATTR_COL = "id-attribute-column";
    private static final String FETCH_SIZE = "fetch-size";
    private static final String NULL_IND = "null-indicator";
    private static final String TAG_CASE = "tag-case";
    private static final String SCHEMA = "include-schema";
    private static final String NO_ROWS_QRY = "no-rows-query";
    private static final String EMPTY = "";
    private static final String YES = "yes";
    private static final String Y = "y";
    private static final String NO = "no";
    private static final String N = "n";
    private static final String UPPER = "upper";
    private static final String LOWER = "lower";

    public void handleAction(Node node) {
        Object object;
        Object object2;
        String string = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        Element element = null;
        Object var8_8 = null;
        Element element2 = this.getActionElement();
        String string2 = this.getAttributeAllowingParam(DATE_FORMAT, element2);
        String string3 = this.getAttributeAllowingParam(MAX_ROWS, element2);
        String string4 = this.getAttributeAllowingParam(SKIP_ROWS, element2);
        String string5 = this.getAttributeAllowingParam(ROWSET_ELT, element2);
        if (string5 == null) {
            string5 = this.getAttributeAllowingParam(DOC_ELT, element2);
        }
        String string6 = this.getAttributeAllowingParam(ROW_ELT, element2);
        String string7 = this.getAttributeAllowingParam(ID_ATTR, element2);
        String string8 = this.getAttributeAllowingParam(ID_ATTR_COL, element2);
        String string9 = this.getAttributeAllowingParam(FETCH_SIZE, element2);
        String string10 = this.getAttributeAllowingParam(NULL_IND, element2);
        String string11 = this.getAttributeAllowingParam(TAG_CASE, element2);
        String string12 = this.getAttributeAllowingParam(SCHEMA, element2);
        OracleXMLQuery oracleXMLQuery = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        Connection connection = this.getPageRequest().getJDBCConnection();
        string = this.getActionElementContent();
        if (string == null || string.equals(EMPTY)) {
            this.reportError(node, Res.getString(25116));
            return;
        }
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n2 = -1;
            }
        }
        if (string4 != null) {
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n3 = 0;
            }
        }
        bl = string12 != null && (string12.equalsIgnoreCase(YES) || string12.equalsIgnoreCase(Y));
        try {
            preparedStatement = connection.prepareStatement(string);
            if (this.getPageRequest().isOracleDriver()) {
                if (string9 != null) {
                    try {
                        n = Integer.parseInt(string9);
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                }
                if (n == -1) {
                    n = this.getDefaultFetchSize();
                }
                if (n2 >= 1 && n3 >= 0 && n > n2 + n3) {
                    n = n2 + n3;
                }
                if (n > 1) {
                    object2 = (OracleStatement)preparedStatement;
                    object2.setRowPrefetch(n);
                }
            }
            this.handleBindVariables(preparedStatement);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            this.reportErrorIncludingStatement(node, string, sQLException.getErrorCode(), sQLException.getMessage());
            this.closeThings(resultSet, preparedStatement);
            return;
        }
        oracleXMLQuery = new OracleXMLQuery(connection, resultSet);
        if (n2 >= 0) {
            oracleXMLQuery.setMaxRows(n2);
        }
        if (n3 > 0) {
            oracleXMLQuery.setSkipRows(n3);
        }
        if (string5 != null) {
            oracleXMLQuery.setRowsetTag(string5);
        }
        if (string6 != null) {
            oracleXMLQuery.setRowTag(string6);
        }
        if (string2 != null && !string2.equals(EMPTY)) {
            oracleXMLQuery.setDateFormat(string2);
        }
        if (string10 != null && !string10.equals(EMPTY)) {
            if (string10.equalsIgnoreCase(Y) || string10.equalsIgnoreCase(YES)) {
                oracleXMLQuery.useNullAttributeIndicator(true);
            } else if (string10.equalsIgnoreCase(N) || string10.equalsIgnoreCase(NO)) {
                oracleXMLQuery.useNullAttributeIndicator(false);
            }
        }
        if (string11 != null && !string11.equals(EMPTY)) {
            if (string11.equalsIgnoreCase(UPPER)) {
                oracleXMLQuery.useUpperCaseTagNames();
            } else if (string11.equalsIgnoreCase(LOWER)) {
                oracleXMLQuery.useLowerCaseTagNames();
            }
        }
        if (string8 != null) {
            oracleXMLQuery.setRowIdColumn(string8);
        }
        if (string7 != null) {
            oracleXMLQuery.setRowIdAttrName(string7);
        }
        if ((object2 = this.getActionElement().getChildNodes()) != null) {
            int n4 = object2.getLength();
            for (int i = 0; i < n4; ++i) {
                object = object2.item(i);
                if (object.getNodeType() != 1 || !((XMLElement)object).getLocalName().equals(NO_ROWS_QRY)) continue;
                oracleXMLQuery.setRaiseNoRowsException(true);
                element = (Element)object;
                break;
            }
        }
        if (element == null) {
            if (bl) {
                Document document = oracleXMLQuery.getXMLDOM(node, 2);
            } else {
                Document document = oracleXMLQuery.getXMLDOM(node);
            }
            oracleXMLQuery.close();
            this.closeThings(resultSet, preparedStatement);
            return;
        }
        try {
            if (bl) {
                Document document = oracleXMLQuery.getXMLDOM(node, 2);
            } else {
                Document document = oracleXMLQuery.getXMLDOM(node);
            }
            oracleXMLQuery.close();
            this.closeThings(resultSet, preparedStatement);
            return;
        }
        catch (OracleXMLSQLNoRowsException oracleXMLSQLNoRowsException) {
            oracleXMLQuery.close();
            this.closeThings(resultSet, preparedStatement);
            XSQLQueryHandler xSQLQueryHandler = new XSQLQueryHandler();
            xSQLQueryHandler.init(this.getPageRequest(), element);
            object = node.getChildNodes();
            if (object != null) {
                int n5 = object.getLength();
                for (int i = 0; i < n5; ++i) {
                    node.removeChild(object.item(0));
                }
            }
            xSQLQueryHandler.handleAction(node);
            return;
        }
    }

    private void closeThings(ResultSet resultSet, Statement statement) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

