/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.transx.DataTypes;
import oracle.xml.transx.TxuErrMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class DLFWriter {
    String tablename;
    boolean fClosed;
    boolean fComplete;
    XMLDocument doc = new XMLDocument();
    Vector keys;
    Properties columns;
    XMLElement table;
    XMLElement dataset;
    XMLElement row;
    ByteArrayOutputStream buf;
    String sbuf;
    char[] cbuf;

    DLFWriter(String string) {
        Element element = this.doc.createElement("table");
        Node node = this.doc.appendChild((Node)element);
        this.table = (XMLElement)node;
        this.table.setAttribute("name", string);
    }

    Document getDocument() {
        return this.doc;
    }

    void writeLookupKeys(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        Element element = this.doc.createElement("lookup-key");
        Node node = this.table.appendChild((Node)element);
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = this.doc.createElement("column");
            Node node2 = node.appendChild(element2);
            String string = (String)vector.elementAt(i);
            ((XMLElement)node2).setAttribute("name", string);
        }
        this.keys = vector;
    }

    void writeColumnList(Properties properties) {
        if (this.keys == null) {
            this.writeLookupKeys(null);
        }
        Node node = this.doc.getFirstChild();
        Element element = this.doc.createElement("columns");
        Node node2 = node.appendChild(element);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Element element2 = this.doc.createElement("column");
            Node node3 = node2.appendChild(element2);
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            String string3 = DataTypes.toDLFType(string2);
            ((XMLElement)node3).setAttribute("name", string);
            ((XMLElement)node3).setAttribute("type", string3);
        }
        this.columns = properties;
    }

    void startDataset() {
        Element element = this.doc.createElement("dataset");
        Node node = this.table.appendChild((Node)element);
        this.dataset = (XMLElement)node;
    }

    void endDataset() {
        this.dataset = null;
        this.fComplete = true;
    }

    void startRow() {
        Element element = this.doc.createElement("row");
        Node node = this.dataset.appendChild((Node)element);
        this.row = (XMLElement)node;
    }

    void endRow() {
        this.row = null;
    }

    void column(String string, String string2) {
        Element element = this.doc.createElement("col");
        Node node = this.row.appendChild((Node)element);
        ((XMLElement)node).setAttribute("name", string);
        Text text = this.doc.createTextNode(string2);
        node.appendChild(text);
    }

    public String toString() {
        String string;
        if (!this.fComplete) {
            String string2 = TxuErrMsg.getMessage(403, "RENDERING_INCOMPLETE");
            throw new RuntimeException(string2);
        }
        try {
            if (this.buf == null) {
                this.buf = new ByteArrayOutputStream();
            }
            this.doc.print((OutputStream)this.buf, "UTF8");
            string = this.buf.toString("UTF8");
            int n = string.indexOf("<table");
            if (n == -1) {
                String string3 = TxuErrMsg.getMessage(403, "ROOT_ELEMENT_NOT_FOUND");
                throw new RuntimeException(string3);
            }
            string = string.substring(n);
        }
        catch (IOException iOException) {
            String string4 = TxuErrMsg.getMessage(404, iOException.getMessage());
            throw new RuntimeException(string4);
        }
        return string;
    }

    private char[] toCharArray() {
        if (this.sbuf == null) {
            this.sbuf = this.toString();
        }
        this.cbuf = this.sbuf.toCharArray();
        return this.cbuf;
    }

    Reader getReader() {
        this.cbuf = this.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(this.cbuf);
        return charArrayReader;
    }

    void writeTo(Writer writer) {
        this.cbuf = this.toCharArray();
        try {
            writer.write(this.cbuf, 0, this.cbuf.length);
        }
        catch (IOException iOException) {
            String string = TxuErrMsg.getMessage(404, iOException.getMessage());
            throw new RuntimeException(string);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fClosed) {
            String string = TxuErrMsg.getMessage(403, "");
            throw new IOException(string);
        }
    }

    public void flush() throws IOException {
        if (this.fClosed) {
            String string = TxuErrMsg.getMessage(403, "");
            throw new IOException(string);
        }
    }

    public void close() {
        this.fClosed = true;
    }
}

