/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.xml.jaxb.JaxbBindingSchema;
import oracle.xml.jaxb.JaxbConstants;
import oracle.xml.jaxb.JaxbListImpl;
import oracle.xml.jaxb.JaxbNode;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.v2.XMLNode;

public class JaxbUtil
implements JaxbConstants {
    private static String allHexDigits = "0123456789abcdefABCDEF";
    private static final String lsep = System.getProperty("line.separator");
    private static boolean asWordSeparator = true;
    static Hashtable builtInTypes = new Hashtable();
    static String dataTypeConverter;
    static HashMap parseMap;
    static HashMap printMap;
    static final long JaxbExternalizableVersion = 1L;

    public static String convertUnprintableChar(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] < '\u007f') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(JaxbUtil.escapeUnicode(stringBuffer2, cArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String className(String string) {
        return JaxbUtil.className(string, true);
    }

    protected static String className(String string, boolean bl) {
        String[] stringArray = JaxbUtil.getWordList(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringArray.length == 0) {
            return stringBuffer.toString();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            char[] cArray = stringArray[i].toCharArray();
            if (Character.isLowerCase(cArray[0])) {
                cArray[0] = Character.toUpperCase(cArray[0]);
            }
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] >= ' ' && cArray[j] < '\u007f') {
                    if (cArray[j] == '_' && asWordSeparator) continue;
                    stringBuffer.append(cArray[j]);
                    continue;
                }
                if (bl) {
                    stringBuffer.append(JaxbUtil.escapeUnicode(stringBuffer2, cArray[j]));
                    continue;
                }
                stringBuffer.append(cArray[j]);
            }
        }
        return stringBuffer.toString();
    }

    public static String methodName(String string) {
        return JaxbUtil.methodName(string, true);
    }

    public static String methodName(String string, boolean bl) {
        return JaxbUtil.className(string, bl);
    }

    public static String setMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("set").append(JaxbUtil.methodName(string));
        return stringBuffer.toString();
    }

    public static String getMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("get").append(JaxbUtil.methodName(string));
        return stringBuffer.toString();
    }

    public static String getMethodName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.equals("boolean")) {
            stringBuffer.append("is").append(JaxbUtil.methodName(string));
        } else {
            stringBuffer.append("get").append(JaxbUtil.methodName(string));
        }
        return stringBuffer.toString();
    }

    public static String constantName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = JaxbUtil.getWordList(string);
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0].toUpperCase());
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append('_');
                stringBuffer.append(stringArray[i].toUpperCase());
            }
        }
        return stringBuffer.toString();
    }

    static String paramName(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        if (n < n2) {
            return "value";
        }
        return null;
    }

    static String quoteStringForXml(String string) {
        return new String("\"" + string + "\"");
    }

    static String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        if (string == null) {
            return "\"null\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] < '\u0080') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(JaxbUtil.escape(cArray[i]));
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String escape(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(Integer.toHexString(c & 0xF).toUpperCase());
            c = (char)(c >>> 4);
        }
        stringBuffer.append("u\\");
        return stringBuffer.reverse().toString();
    }

    private static String initCaps(String string) {
        char c = string.charAt(0);
        c = Character.toUpperCase(c);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, c);
        return stringBuffer.toString();
    }

    static void setUnderscoreBinding(String string) {
        if (string.equals("asCharInWord")) {
            asWordSeparator = false;
        }
    }

    private static String javaName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = JaxbUtil.getWordList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean isPunct(char c) {
        if (c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de') {
            return true;
        }
        return c == '_' && asWordSeparator;
    }

    private static String escapeUnicode(StringBuffer stringBuffer, char c) {
        String string = Integer.toString(c, 16);
        int n = string.length();
        stringBuffer.setLength(6);
        stringBuffer.setCharAt(0, '\\');
        stringBuffer.setCharAt(1, 'u');
        int n2 = 2;
        int n3 = n;
        while (n3 < 4) {
            stringBuffer.setCharAt(n2, '0');
            ++n3;
            ++n2;
        }
        stringBuffer.replace(n2, 6, string);
        return stringBuffer.toString();
    }

    private static boolean isUncased(char c) {
        return Character.isLetter(c) && !Character.isUpperCase(c) && !Character.isLowerCase(c);
    }

    private static int nextBreak(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == '_' && !asWordSeparator || i >= n2 - 1 || (c = string.charAt(i + 1)) == '_' && !asWordSeparator) continue;
            if (JaxbUtil.isPunct(c)) {
                return i + 1;
            }
            if (Character.isDigit(c2) && !Character.isDigit(c)) {
                return i + 1;
            }
            if (!Character.isDigit(c2) && Character.isDigit(c)) {
                return i + 1;
            }
            if (Character.isLowerCase(c2) && !Character.isLowerCase(c)) {
                return i + 1;
            }
            if (i < n2 - 2) {
                char c3 = string.charAt(i + 2);
                if (c3 == '_' && !asWordSeparator) continue;
                if (Character.isUpperCase(c2) && Character.isUpperCase(c) && Character.isLowerCase(c3)) {
                    return i + 1;
                }
            }
            if (Character.isLetter(c2) && !Character.isLetter(c)) {
                return i + 1;
            }
            if (!Character.isLetter(c2) && Character.isLetter(c)) {
                return i + 1;
            }
            if (JaxbUtil.isUncased(c2) && !JaxbUtil.isUncased(c)) {
                return i + 1;
            }
            if (JaxbUtil.isUncased(c2) || !JaxbUtil.isUncased(c)) continue;
            return i + 1;
        }
        return -1;
    }

    private static String[] getWordList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            while (n2 < n && JaxbUtil.isPunct(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n) break;
            int n3 = JaxbUtil.nextBreak(string, n2);
            String string2 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
            arrayList.add(JaxbUtil.escape(string2));
            if (n3 == -1) break;
            n2 = n3;
        }
        return arrayList.toArray(new String[0]);
    }

    private static String escape(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            JaxbUtil.escape(stringBuffer, string, i);
            return stringBuffer.toString();
        }
        return string;
    }

    private static void escape(StringBuffer stringBuffer, String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("_");
            if (c <= '\u000f') {
                stringBuffer.append("000");
            } else if (c <= '\u00ff') {
                stringBuffer.append("00");
            } else if (c <= '\u0fff') {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(c, 16));
        }
    }

    private static String decodeUriEscapeSequence(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (i + 2 < string.length() && allHexDigits.indexOf(string.charAt(i + 1)) >= 0 && allHexDigits.indexOf(string.charAt(i + 2)) >= 0) {
                    String string2 = string.substring(i + 1, i + 3);
                    stringBuffer.append((char)Integer.parseInt(string2, 16));
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getDefaultPackageName(String string) {
        int n;
        String string2;
        int n2;
        Object object;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals("")) {
            return "generated";
        }
        if (string.length() > 4) {
            String string3 = string.substring(0, 4);
            if (string3.equalsIgnoreCase("urn:")) {
                string = string.substring(4);
            } else {
                string3 = string.substring(0, 5);
                if (string3.equalsIgnoreCase("http:")) {
                    string = string.substring(5);
                }
            }
        }
        if ((n3 = string.lastIndexOf(46)) != -1 && (((String)(object = string.substring(n3))).length() == 3 || ((String)object).length() == 4 || ((String)object).equalsIgnoreCase(".html"))) {
            string = string.substring(0, n3);
        }
        if ((n2 = ((StringTokenizer)(object = new StringTokenizer(string, "/:"))).countTokens()) == 0) {
            return "generated";
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            arrayList.add(JaxbUtil.decodeUriEscapeSequence(string2));
        }
        string2 = (String)arrayList.remove(0);
        string2 = string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("www")) continue;
            arrayList.add(0, string2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = (String)arrayList.get(n);
            arrayList.set(n, string2.toLowerCase());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = (String)arrayList.get(n);
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isJavaIdentifierPart(string2.charAt(i))) {
                    stringBuffer2.append(string2.charAt(i));
                    continue;
                }
                stringBuffer2.append('_');
            }
            if (!Character.isJavaIdentifierStart(stringBuffer2.charAt(0))) {
                stringBuffer2.insert(0, '_');
            }
            if (n != 0) {
                stringBuffer2.insert(0, '.');
            }
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    static String getBuiltInType(String string) {
        String string2 = (String)builtInTypes.get(string);
        if (string2 != null) {
            return string2;
        }
        return JaxbUtil.className(string);
    }

    static boolean isSchemaDataType(String string) {
        return builtInTypes.get(string) != null;
    }

    static boolean isJaxbDataType(String string) {
        if (builtInTypes.contains(string)) {
            return true;
        }
        if (JaxbUtil.isJavaWrapperClass(string)) {
            return true;
        }
        return string.equals("string") || string.equals("integer");
    }

    static boolean isJavaPrimitiveType(String string) {
        return string.equals("java.lang.String") || string.equals("String") || string.equals("byte[]") || string.equals("int") || string.equals("short") || string.equals("byte") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("boolean");
    }

    static String getJavaWrapperClass(String string) {
        if (string.equals("int")) {
            return "java.lang.Integer";
        }
        if (string.equals("short")) {
            return "java.lang.Short";
        }
        if (string.equals("byte")) {
            return "java.lang.Byte";
        }
        if (string.equals("long")) {
            return "java.lang.Long";
        }
        if (string.equals("float")) {
            return "java.lang.Float";
        }
        if (string.equals("double")) {
            return "java.lang.Double";
        }
        if (string.equals("boolean")) {
            return "java.lang.Boolean";
        }
        return string;
    }

    static boolean isJavaWrapperClass(String string) {
        return string.equals("java.lang.Integer") || string.equals("java.lang.Short") || string.equals("java.lang.Byte") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.lang.Boolean");
    }

    static String getJavaPrimitiveType(String string) {
        Object var1_1 = null;
        if (string.equals("java.lang.Integer")) {
            return "intValue()";
        }
        if (string.equals("java.lang.Short")) {
            return "shortValue()";
        }
        if (string.equals("java.lang.Byte")) {
            return "byteValue()";
        }
        if (string.equals("java.lang.Long")) {
            return "longValue()";
        }
        if (string.equals("java.lang.Float")) {
            return "floatValue()";
        }
        if (string.equals("java.lang.Double")) {
            return "doubleValue()";
        }
        if (string.equals("java.lang.Boolean")) {
            return "booleanValue()";
        }
        return string;
    }

    public static String getPrefaceString() {
        Date date = new Date();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/* DO NOT EDIT THIS FILE - This file was generated by     */").append(lsep).append("/* Oracle JAXB Class Generator Implementation.").append("            */").append(lsep).append("/* Any Modification to this file will be lost upon").append("        */").append(lsep).append("/* recompilation of source schema                         */ ").append(lsep).append(lsep);
        return stringBuffer.toString();
    }

    static String propertiesPrefaceString() {
        Date date = new Date();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Generated by Oracle JAXB Class Generator on ").append(date.toString()).append(lsep);
        return stringBuffer.toString();
    }

    static String nameUsedInCallingSuper(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            string2 = string;
        }
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2.equals("byte[]")) {
            string2 = "ByteArray";
        }
        return JaxbUtil.initCaps(string2);
    }

    static String getParseMethod(String string) {
        return (String)parseMap.get(string);
    }

    static String getPrintMethod(String string) {
        return (String)printMap.get(string);
    }

    static void updateBuiltInTypes(String string, String string2) {
        builtInTypes.put(string, string2);
    }

    static String getActualExtendsNodeImpl(Hashtable hashtable, JaxbBindingSchema jaxbBindingSchema, String string) {
        JaxbBindingSchema jaxbBindingSchema2 = jaxbBindingSchema.getExtendsBindingSchema();
        if (jaxbBindingSchema2 != null) {
            if (jaxbBindingSchema2.isGlobal()) {
                return jaxbBindingSchema2.getPackageName() + "." + jaxbBindingSchema2.getClassName() + "Impl";
            }
            return jaxbBindingSchema2.getBaseClassNameImpl() + "." + jaxbBindingSchema2.getClassName() + "Impl";
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            jaxbBindingSchema2 = (JaxbBindingSchema)enumeration.nextElement();
            if (jaxbBindingSchema2.getType() == 3) continue;
            String string3 = JaxbUtil.className(jaxbBindingSchema2.getNodeName());
            if (jaxbBindingSchema2.isAnonymousType() || !string.equals(string2 = jaxbBindingSchema2.isGlobal() ? jaxbBindingSchema2.getPackageName() + "." + string3 : jaxbBindingSchema2.getBaseClassName() + "." + string3)) continue;
            if (jaxbBindingSchema2.isGlobal()) {
                return jaxbBindingSchema2.getPackageName() + "." + jaxbBindingSchema2.getClassName() + "Impl";
            }
            return jaxbBindingSchema2.getBaseClassNameImpl() + "." + jaxbBindingSchema2.getClassName() + "Impl";
        }
        return "";
    }

    static String getActualExtendsNode(Hashtable hashtable, JaxbBindingSchema jaxbBindingSchema, String string) {
        JaxbBindingSchema jaxbBindingSchema2 = jaxbBindingSchema.getExtendsBindingSchema();
        if (jaxbBindingSchema2 != null) {
            if (jaxbBindingSchema2.isGlobal()) {
                return jaxbBindingSchema2.getPackageName() + "." + jaxbBindingSchema2.getClassName();
            }
            return jaxbBindingSchema2.getBaseClassName() + "." + jaxbBindingSchema2.getClassName();
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            jaxbBindingSchema2 = (JaxbBindingSchema)enumeration.nextElement();
            if (jaxbBindingSchema2.getType() == 3) continue;
            String string3 = JaxbUtil.className(jaxbBindingSchema2.getNodeName());
            if (jaxbBindingSchema2.isAnonymousType() || !string.equals(string2 = jaxbBindingSchema2.isGlobal() ? jaxbBindingSchema2.getPackageName() + "." + string3 : jaxbBindingSchema2.getBaseClassName() + "." + string3)) continue;
            if (jaxbBindingSchema2.isGlobal()) {
                return jaxbBindingSchema2.getPackageName() + "." + jaxbBindingSchema2.getClassName();
            }
            return jaxbBindingSchema2.getBaseClassName() + "." + jaxbBindingSchema2.getClassName();
        }
        return "";
    }

    static JaxbBindingSchema getBindingSchema(Hashtable hashtable, JaxbBindingSchema jaxbBindingSchema, String string, int n) {
        JaxbBindingSchema jaxbBindingSchema2 = jaxbBindingSchema.getExtendsBindingSchema();
        if (jaxbBindingSchema2 != null) {
            return jaxbBindingSchema2;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            jaxbBindingSchema2 = (JaxbBindingSchema)enumeration.nextElement();
            String string3 = JaxbUtil.className(jaxbBindingSchema2.getNodeName());
            if (jaxbBindingSchema2.isAnonymousType() || !string.equals(string2 = jaxbBindingSchema2.isGlobal() ? jaxbBindingSchema2.getPackageName() + "." + string3 : jaxbBindingSchema2.getBaseClassName() + "." + string3) || jaxbBindingSchema2.getType() != n) continue;
            return jaxbBindingSchema2;
        }
        return null;
    }

    static boolean isCollisionInGetMethodName(String string) {
        return string.equals("Class");
    }

    static void writeExternal(ObjectOutput objectOutput, Object object, int n) throws IOException {
        if (object instanceof JaxbNode) {
            objectOutput.write(1);
            objectOutput.writeUTF(object.getClass().getName());
            ((JaxbNode)object).writeExternal(objectOutput, n);
        } else if (object instanceof JaxbListImpl) {
            objectOutput.write(2);
            ((JaxbListImpl)object).writeExternal(objectOutput, false);
        } else if (object instanceof XMLNode) {
            objectOutput.write(3);
            objectOutput.writeInt(n);
        } else if (object instanceof String) {
            objectOutput.write(4);
            objectOutput.writeUTF((String)object);
        } else {
            throw new IOException("Error: Unexpected type encountered in writeExternal");
        }
    }

    static {
        builtInTypes.put(XSDTypeConstants.ANY_SIMPLE, "java.lang.String");
        builtInTypes.put("string", "java.lang.String");
        builtInTypes.put("boolean", "boolean");
        builtInTypes.put("float", "float");
        builtInTypes.put("double", "double");
        builtInTypes.put("decimal", "java.math.BigDecimal");
        builtInTypes.put("duration", "java.lang.String");
        builtInTypes.put("dateTime", "java.util.Calendar");
        builtInTypes.put("time", "java.util.Calendar");
        builtInTypes.put("date", "java.util.Calendar");
        builtInTypes.put("gYearMonth", "java.lang.String");
        builtInTypes.put("gYear", "java.lang.String");
        builtInTypes.put("gMonth", "java.lang.String");
        builtInTypes.put("gMonthDay", "java.lang.String");
        builtInTypes.put("gDay", "java.lang.String");
        builtInTypes.put("hexBinary", "byte[]");
        builtInTypes.put("base64Binary", "byte[]");
        builtInTypes.put("anyURI", "java.lang.String");
        builtInTypes.put("QName", "javax.xml.namespace.QName");
        builtInTypes.put("NOTATION", "NOT_SUPPORTED");
        builtInTypes.put("normalizedString", "java.lang.String");
        builtInTypes.put("token", "java.lang.String");
        builtInTypes.put("language", "java.lang.String");
        builtInTypes.put("ID", "java.lang.String");
        builtInTypes.put("IDREF", "java.lang.Object");
        builtInTypes.put("NMTOKEN", "java.lang.String");
        builtInTypes.put("NMTOKENS", "java.lang.String");
        builtInTypes.put("ENTITY", "NOT_SUPPORTED");
        builtInTypes.put("Name", "java.lang.String");
        builtInTypes.put("NCName", "java.lang.String");
        builtInTypes.put("integer", "java.math.BigInteger");
        builtInTypes.put("nonPositiveInteger", "java.math.BigInteger");
        builtInTypes.put("long", "long");
        builtInTypes.put("nonNegativeInteger", "java.math.BigInteger");
        builtInTypes.put("negativeInteger", "java.math.BigInteger");
        builtInTypes.put("int", "int");
        builtInTypes.put("short", "short");
        builtInTypes.put("byte", "byte");
        builtInTypes.put("unsignedLong", "java.math.BigInteger");
        builtInTypes.put("positiveInteger", "java.math.BigInteger");
        builtInTypes.put("unsignedInt", "long");
        builtInTypes.put("unsignedShort", "int");
        builtInTypes.put("unsignedByte", "short");
        dataTypeConverter = "oracle.xml.jaxb.JaxbDatatypeConverter.";
        parseMap = new HashMap();
        parseMap.put(XSDTypeConstants.ANY_SIMPLE, dataTypeConverter + "parseAnySimpleType");
        parseMap.put("string", dataTypeConverter + "parseString");
        parseMap.put("boolean", dataTypeConverter + "parseBoolean");
        parseMap.put("float", dataTypeConverter + "parseFloat");
        parseMap.put("double", dataTypeConverter + "parseDouble");
        parseMap.put("decimal", dataTypeConverter + "parseDecimal");
        parseMap.put("duration", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("dateTime", dataTypeConverter + "parseDateTime");
        parseMap.put("time", dataTypeConverter + "parseTime");
        parseMap.put("date", dataTypeConverter + "parseDate");
        parseMap.put("gYearMonth", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("gYear", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("gMonth", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("gMonthDay", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("gDay", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("hexBinary", dataTypeConverter + "parseHexBinary");
        parseMap.put("base64Binary", dataTypeConverter + "parseBase64Binary");
        parseMap.put("anyURI", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("QName", dataTypeConverter + "parseQName");
        parseMap.put("NOTATION", "NOT_SUPPORTED");
        parseMap.put("normalizedString", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("token", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("language", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("ID", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("IDREF", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("NMTOKEN", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("NMTOKENS", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("ENTITY", "NOT_SUPPORTED");
        parseMap.put("Name", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("NCName", dataTypeConverter + "parseAnySimpleType");
        parseMap.put("integer", dataTypeConverter + "parseInteger");
        parseMap.put("nonPositiveInteger", dataTypeConverter + "parseInteger");
        parseMap.put("long", dataTypeConverter + "parseLong");
        parseMap.put("nonNegativeInteger", dataTypeConverter + "parseInteger");
        parseMap.put("negativeInteger", dataTypeConverter + "parseInteger");
        parseMap.put("int", dataTypeConverter + "parseInt");
        parseMap.put("short", dataTypeConverter + "parseShort");
        parseMap.put("byte", dataTypeConverter + "parseByte");
        parseMap.put("unsignedLong", dataTypeConverter + "parseInteger");
        parseMap.put("positiveInteger", dataTypeConverter + "parseInteger");
        parseMap.put("unsignedInt", dataTypeConverter + "parseLong");
        parseMap.put("unsignedShort", dataTypeConverter + "parseInt");
        parseMap.put("unsignedByte", dataTypeConverter + "parseShort");
        parseMap.put("list", dataTypeConverter + "parseList");
        printMap = new HashMap();
        printMap.put(XSDTypeConstants.ANY_SIMPLE, dataTypeConverter + "printAnySimpleType");
        printMap.put("string", dataTypeConverter + "printString");
        printMap.put("boolean", dataTypeConverter + "printBoolean");
        printMap.put("float", dataTypeConverter + "printFloat");
        printMap.put("double", dataTypeConverter + "printDouble");
        printMap.put("decimal", dataTypeConverter + "printDecimal");
        printMap.put("duration", dataTypeConverter + "printAnySimpleType");
        printMap.put("dateTime", dataTypeConverter + "printDateTime");
        printMap.put("time", dataTypeConverter + "printTime");
        printMap.put("date", dataTypeConverter + "printDate");
        printMap.put("gYearMonth", dataTypeConverter + "printAnySimpleType");
        printMap.put("gYear", dataTypeConverter + "printAnySimpleType");
        printMap.put("gMonth", dataTypeConverter + "printAnySimpleType");
        printMap.put("gMonthDay", dataTypeConverter + "printAnySimpleType");
        printMap.put("gDay", dataTypeConverter + "printAnySimpleType");
        printMap.put("hexBinary", dataTypeConverter + "printHexBinary");
        printMap.put("base64Binary", dataTypeConverter + "printBase64Binary");
        printMap.put("anyURI", dataTypeConverter + "printAnySimpleType");
        printMap.put("QName", dataTypeConverter + "printQName");
        printMap.put("NOTATION", "NOT_SUPPORTED");
        printMap.put("normalizedString", dataTypeConverter + "printAnySimpleType");
        printMap.put("token", dataTypeConverter + "printAnySimpleType");
        printMap.put("language", dataTypeConverter + "printAnySimpleType");
        printMap.put("ID", dataTypeConverter + "printAnySimpleType");
        printMap.put("IDREF", dataTypeConverter + "printAnySimpleTypeObject");
        printMap.put("NMTOKEN", dataTypeConverter + "printAnySimpleType");
        printMap.put("NMTOKENS", dataTypeConverter + "printAnySimpleType");
        printMap.put("ENTITY", "NOT_SUPPORTED");
        printMap.put("Name", dataTypeConverter + "printAnySimpleType");
        printMap.put("NCName", dataTypeConverter + "printAnySimpleType");
        printMap.put("integer", dataTypeConverter + "printInteger");
        printMap.put("nonPositiveInteger", dataTypeConverter + "printInteger");
        printMap.put("long", dataTypeConverter + "printLong");
        printMap.put("nonNegativeInteger", dataTypeConverter + "printInteger");
        printMap.put("negativeInteger", dataTypeConverter + "printInteger");
        printMap.put("int", dataTypeConverter + "printInt");
        printMap.put("short", dataTypeConverter + "printShort");
        printMap.put("byte", dataTypeConverter + "printByte");
        printMap.put("unsignedLong", dataTypeConverter + "printInteger");
        printMap.put("positiveInteger", dataTypeConverter + "printInteger");
        printMap.put("unsignedInt", dataTypeConverter + "printLong");
        printMap.put("unsignedShort", dataTypeConverter + "printInt");
        printMap.put("unsignedByte", dataTypeConverter + "printShort");
        parseMap.put("list", dataTypeConverter + "printList");
    }
}

