/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public class XMLClassDescriptorAdapter
extends XMLClassDescriptorImpl {
    public XMLClassDescriptorAdapter() {
    }

    public XMLClassDescriptorAdapter(ClassDescriptor classDesc, String xmlName) throws MappingException {
        this(classDesc, xmlName, null);
    }

    public XMLClassDescriptorAdapter(ClassDescriptor classDesc, String xmlName, NodeType primitiveNodeType) throws MappingException {
        if (classDesc == null) {
            String err = "The ClassDescriptor argument to XMLClassDescriptorAdapter must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (primitiveNodeType == null) {
            primitiveNodeType = LocalConfiguration.getInstance().getPrimitiveNodeType();
        }
        if (primitiveNodeType == null) {
            primitiveNodeType = NodeType.Attribute;
        }
        this.process(classDesc, primitiveNodeType);
        this.setJavaClass(classDesc.getJavaClass());
        if (xmlName == null) {
            if (classDesc instanceof XMLClassDescriptor) {
                xmlName = ((XMLClassDescriptor)classDesc).getXMLName();
            } else {
                XMLNaming naming = XMLNaming.getInstance();
                String name = classDesc.getJavaClass().getName();
                int idx = name.lastIndexOf(46);
                if (idx >= 0) {
                    name = name.substring(idx + 1);
                }
                xmlName = naming.toXMLName(name);
            }
        }
        this.setXMLName(xmlName);
    }

    private void process(ClassDescriptor classDesc, NodeType primitiveNodeType) throws MappingException {
        ClassDescriptorImpl cdImpl;
        FieldDescriptor[] identities;
        if (classDesc instanceof XMLClassDescriptor) {
            this.process((XMLClassDescriptor)classDesc);
            return;
        }
        XMLClassDescriptor xmlClassDesc = null;
        ClassDescriptor extendsDesc = classDesc.getExtends();
        if (extendsDesc != null) {
            xmlClassDesc = extendsDesc instanceof XMLClassDescriptor ? (XMLClassDescriptor)extendsDesc : new XMLClassDescriptorAdapter(extendsDesc, null, primitiveNodeType);
        }
        this.setExtends(xmlClassDesc);
        FieldDescriptor identity = classDesc.getIdentity();
        FieldDescriptor[] fields = classDesc.getFields();
        if (classDesc instanceof ClassDescriptorImpl && (identities = (cdImpl = (ClassDescriptorImpl)classDesc).getIdentities()) != null && identities.length > 1) {
            int size = fields.length + identities.length;
            FieldDescriptor[] newFields = new FieldDescriptor[size];
            System.arraycopy(fields, 0, newFields, 0, fields.length);
            System.arraycopy(identities, 0, newFields, fields.length, identities.length);
            fields = newFields;
        }
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fieldDesc = fields[i];
            if (fieldDesc == null) continue;
            if (fieldDesc instanceof XMLFieldDescriptorImpl) {
                if (identity == fieldDesc) {
                    this.setIdentity((XMLFieldDescriptorImpl)fieldDesc);
                    identity = null;
                    continue;
                }
                this.addFieldDescriptor((XMLFieldDescriptorImpl)fieldDesc);
                continue;
            }
            String name = fieldDesc.getFieldName();
            XMLNaming naming = XMLNaming.getInstance();
            String xmlFieldName = naming.toXMLName(name);
            if (identity == fieldDesc) {
                this.setIdentity(new XMLFieldDescriptorImpl(fieldDesc, xmlFieldName, NodeType.Attribute, primitiveNodeType));
                identity = null;
                continue;
            }
            NodeType nodeType = NodeType.Element;
            if (XMLClassDescriptorAdapter.isPrimitive(fieldDesc.getFieldType())) {
                nodeType = primitiveNodeType;
            }
            this.addFieldDescriptor(new XMLFieldDescriptorImpl(fieldDesc, xmlFieldName, nodeType, primitiveNodeType));
        }
        if (identity != null) {
            if (identity instanceof XMLFieldDescriptor) {
                this.setIdentity((XMLFieldDescriptor)identity);
            } else {
                XMLNaming naming = XMLNaming.getInstance();
                String xmlFieldName = naming.toXMLName(identity.getFieldName());
                this.setIdentity(new XMLFieldDescriptorImpl(identity, xmlFieldName, NodeType.Attribute, primitiveNodeType));
            }
        }
    }

    private void process(XMLClassDescriptor classDesc) {
        FieldDescriptor identity = classDesc.getIdentity();
        FieldDescriptor[] fields = classDesc.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (identity == fields[i]) {
                this.setIdentity((XMLFieldDescriptor)fields[i]);
                identity = null;
                continue;
            }
            this.addFieldDescriptor((XMLFieldDescriptor)fields[i]);
        }
        if (identity != null) {
            this.setIdentity((XMLFieldDescriptor)identity);
        }
        this.setXMLName(classDesc.getXMLName());
        this.setExtendsWithoutFlatten((XMLClassDescriptor)classDesc.getExtends());
    }
}

