/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.ord.im.OrdAudio;
import oracle.ord.im.OrdDoc;
import oracle.ord.im.OrdHttpMessage;
import oracle.ord.im.OrdHttpUploadException;
import oracle.ord.im.OrdImage;
import oracle.ord.im.OrdVectoredByteArray;
import oracle.ord.im.OrdVideo;
import oracle.sql.BLOB;

public class OrdHttpUploadFile {
    private String originalFileName;
    private String simpleFileName;
    private String contentType;
    private int contentLength;
    private InputStream contentsInputStream;
    private OrdVectoredByteArray contentsInMem;
    private File contentsTempFile;
    private Vector fileInputStreams;
    private static final int FILE_BUF_SIZE = 65536;
    private static final int LOB_BUF_SIZE = 32000;
    private static final char[] SEPARATORS = new char[]{'\\', '/', ':', ']'};

    OrdHttpUploadFile(String string, String string2, InputStream inputStream) {
        this.originalFileName = string;
        this.contentType = string2;
        this.contentLength = 0;
        this.simpleFileName = string;
        int n = 0;
        while (n < SEPARATORS.length) {
            int n2 = this.simpleFileName.lastIndexOf(SEPARATORS[n]);
            if (n2 >= 0) {
                this.simpleFileName = this.simpleFileName.substring(n2 + 1);
            }
            ++n;
        }
        this.contentsInputStream = inputStream;
        this.contentsInMem = null;
        this.contentsTempFile = null;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() throws IOException {
        if (this.contentsInMem != null) {
            return this.contentsInMem.getInputStream();
        }
        if (this.contentsTempFile != null) {
            FileInputStream fileInputStream = new FileInputStream(this.contentsTempFile);
            if (this.fileInputStreams == null) {
                this.fileInputStreams = new Vector(4);
            }
            this.fileInputStreams.addElement(fileInputStream);
            return fileInputStream;
        }
        if (this.contentsInputStream != null) {
            return this.contentsInputStream;
        }
        throw new IllegalStateException(OrdHttpMessage.getMessage(3));
    }

    public String getMimeType() {
        return this.contentType;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getSimpleFileName() {
        return this.simpleFileName;
    }

    public File getTempFile() {
        return this.contentsTempFile;
    }

    public void loadAudio(OrdAudio ordAudio) throws SQLException, IOException {
        this.loadAudio(ordAudio, new byte[1][64], false);
    }

    public void loadAudio(OrdAudio ordAudio, byte[][] byArray, boolean bl) throws SQLException, IOException {
        if (ordAudio == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordAudio.conn == null) {
            throw new OrdHttpUploadException(10);
        }
        InputStream inputStream = this.getInputStream();
        try {
            ordAudio.loadDataFromInputStream(inputStream);
            try {
                ordAudio.setProperties(byArray, bl);
            }
            catch (SQLException sQLException) {
                ordAudio.setMimeType(this.getMimeType());
                ordAudio.setUpdateTime(null);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void loadBlob(BLOB bLOB) throws SQLException, IOException {
        if (bLOB == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(11));
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.getInputStream();
            outputStream = bLOB.getBinaryOutputStream();
            int n = this.getContentLength();
            int n2 = 32000;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n > 0) {
                if (n2 > n) {
                    n2 = n;
                }
                n3 = inputStream.read(byArray, 0, n2);
                outputStream.write(byArray, 0, n3);
                n -= n3;
            }
        }
        finally {
            Object var5_8 = null;
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void loadDoc(OrdDoc ordDoc) throws SQLException, IOException {
        this.loadDoc(ordDoc, new byte[1][64], false);
    }

    public void loadDoc(OrdDoc ordDoc, byte[][] byArray, boolean bl) throws SQLException, IOException {
        if (ordDoc == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordDoc.conn == null) {
            throw new OrdHttpUploadException(10);
        }
        InputStream inputStream = this.getInputStream();
        try {
            ordDoc.loadDataFromInputStream(inputStream);
            try {
                ordDoc.setProperties(byArray, bl);
            }
            catch (SQLException sQLException) {
                ordDoc.setMimeType(this.getMimeType());
                ordDoc.setContentLength(this.getContentLength());
                ordDoc.setUpdateTime(null);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void loadImage(OrdImage ordImage) throws SQLException, IOException {
        if (ordImage == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordImage.conn == null) {
            throw new OrdHttpUploadException(10);
        }
        InputStream inputStream = this.getInputStream();
        try {
            ordImage.loadDataFromInputStream(inputStream);
            try {
                ordImage.setProperties();
            }
            catch (SQLException sQLException) {
                ordImage.setMimeType(this.getMimeType());
                ordImage.setContentLength(this.getContentLength());
                ordImage.setUpdateTime(null);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void loadImage(OrdImage ordImage, String string) throws SQLException, IOException {
        if (ordImage == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordImage.conn == null) {
            throw new OrdHttpUploadException(10);
        }
        InputStream inputStream = this.getInputStream();
        try {
            ordImage.loadDataFromInputStream(inputStream);
            ordImage.setProperties(string);
        }
        finally {
            Object var5_4 = null;
            inputStream.close();
        }
    }

    public void loadVideo(OrdVideo ordVideo) throws SQLException, IOException {
        this.loadVideo(ordVideo, new byte[1][64], false);
    }

    public void loadVideo(OrdVideo ordVideo, byte[][] byArray, boolean bl) throws SQLException, IOException {
        if (ordVideo == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordVideo.conn == null) {
            throw new OrdHttpUploadException(10);
        }
        InputStream inputStream = this.getInputStream();
        try {
            ordVideo.loadDataFromInputStream(inputStream);
            try {
                ordVideo.setProperties(byArray, bl);
            }
            catch (SQLException sQLException) {
                ordVideo.setMimeType(this.getMimeType());
                ordVideo.setUpdateTime(null);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    int readFromPostData(int n, int n2, String string) throws IOException {
        int n3;
        block4: {
            n3 = 0;
            try {
                if (n2 == 0) {
                    this.saveAsTempFile(string);
                    break block4;
                }
                this.contentsInMem = new OrdVectoredByteArray();
                if (this.contentsInMem.readFromInputStream(this.contentsInputStream, n, n2)) {
                    n3 = this.contentLength = this.contentsInMem.getLength();
                    break block4;
                }
                this.saveAsTempFile(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.contentsInputStream = null;
                throw throwable;
            }
        }
        Object var6_5 = null;
        this.contentsInputStream = null;
        return n3;
    }

    public void release() {
        if (this.contentsInMem != null) {
            this.contentsInMem.release();
            this.contentsInMem = null;
        }
        if (this.contentsTempFile != null) {
            if (this.fileInputStreams != null) {
                int n = 0;
                while (n < this.fileInputStreams.size()) {
                    FileInputStream fileInputStream = (FileInputStream)this.fileInputStreams.elementAt(n);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    ++n;
                }
                this.fileInputStreams.removeAllElements();
                this.fileInputStreams = null;
            }
            this.contentsTempFile.delete();
            this.contentsTempFile = null;
        }
    }

    private void saveAsTempFile(String string) throws IOException {
        Object object;
        long l = System.currentTimeMillis() & 0xFFFFL;
        String string2 = Long.toHexString(l);
        int n = 0;
        while (n < 26) {
            object = "ora" + string2 + (char)(97 + n) + ".tmp";
            this.contentsTempFile = new File(string, (String)object);
            if (!this.contentsTempFile.exists()) break;
            this.contentsTempFile = null;
            ++n;
        }
        if (this.contentsTempFile == null) {
            throw new OrdHttpUploadException(111);
        }
        object = null;
        boolean bl = false;
        try {
            int n2;
            object = new FileOutputStream(this.contentsTempFile);
            if (this.contentsInMem != null) {
                this.contentLength = this.contentsInMem.getLength();
                this.contentsInMem.writeToOutputStream((OutputStream)object);
                this.contentsInMem.release();
                this.contentsInMem = null;
            }
            byte[] byArray = new byte[65536];
            while ((n2 = this.contentsInputStream.read(byArray, 0, 65536)) > 0) {
                ((FileOutputStream)object).write(byArray, 0, n2);
                this.contentLength += n2;
            }
            bl = true;
        }
        finally {
            Object var9_9 = null;
            if (object != null) {
                ((FileOutputStream)object).close();
            }
            if (!bl) {
                this.contentsTempFile.delete();
                this.contentsTempFile = null;
            }
        }
    }
}

