/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingException;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.Anonymizer;
import oracle.dss.util.persistence.GUIDConverter;
import oracle.dss.util.persistence.IDResolver;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.XMLContext;

public class PersistableUtilities
extends Utility {
    public static void makeAnonymousObject(Persistable persistable) {
        if (persistable == null) {
            return;
        }
        String string = persistable.getPersistableAttributes(null).getObjectType();
        if (persistable instanceof Anonymizer) {
            ((Anonymizer)((Object)persistable)).makeAnonymous();
            return;
        }
        if ("Calculation".equals(string) || "DimensionCalc".equals(string) || "Selection".equals(string)) {
            return;
        }
        persistable.setPersistableAttributes(null);
        AggregateInfo[] aggregateInfoArray = persistable.getPersistableComponents();
        if (aggregateInfoArray == null) {
            return;
        }
        int n = 0;
        while (n < aggregateInfoArray.length) {
            Persistable persistable2 = aggregateInfoArray[n].getPersistable();
            PersistableUtilities.makeAnonymousObject(persistable2);
            ++n;
        }
    }

    public static void setDependentID(XMLContext xMLContext, Vector vector, boolean bl, String string) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        IDResolver iDResolver = null;
        String string2 = PersistableUtilities.getMeasureDimName(xMLContext);
        if (bl && string != null && !string.equals(string2)) {
            return;
        }
        iDResolver = PersistableUtilities.getIDResolver(xMLContext);
        if (iDResolver == null) {
            return;
        }
        String string3 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (string3 == null) continue;
            iDResolver.setDependentID(string3);
        }
    }

    public static Vector getDependentID(XMLContext xMLContext, Vector vector, boolean bl, String string) {
        IDResolver iDResolver = null;
        String string2 = PersistableUtilities.getMeasureDimName(xMLContext);
        if (bl && string != null && !string.equals(string2)) {
            return vector;
        }
        iDResolver = PersistableUtilities.getIDResolver(xMLContext);
        if (vector == null) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        String string3 = null;
        GUIDConverter gUIDConverter = null;
        if (PersistableUtilities.getMigrationFlag(xMLContext) != null) {
            gUIDConverter = PersistableUtilities.getGUIDConverter(xMLContext);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (string3 != null) {
                String string4 = string3;
                if (gUIDConverter != null) {
                    try {
                        String string5 = string4;
                        string3 = gUIDConverter.getGUIDForPath(string5, true, "PSR");
                    }
                    catch (NamingException namingException) {
                        string3 = null;
                    }
                } else if (iDResolver != null) {
                    string3 = iDResolver.getDependentID(string4);
                }
                if (string3 == null || string3.equals("invalid id")) {
                    vector2.addElement(string4);
                    continue;
                }
                vector2.addElement(string3);
                continue;
            }
            vector2.addElement(string3);
        }
        return vector2;
    }

    public static Object getMigrationFlag(XMLContext xMLContext) {
        ObjectScope objectScope;
        if (xMLContext != null && (objectScope = xMLContext.getScope()) != null) {
            return objectScope.getObject("migration");
        }
        return null;
    }

    public static GUIDConverter getGUIDConverter(XMLContext xMLContext) {
        ObjectScope objectScope;
        if (xMLContext != null && (objectScope = xMLContext.getScope()) != null) {
            return (GUIDConverter)objectScope.getObject("full_path_to_guid_converter");
        }
        return null;
    }

    public static String getMeasureDimName(XMLContext xMLContext) {
        ObjectScope objectScope;
        if (xMLContext != null && (objectScope = xMLContext.getScope()) != null) {
            return (String)objectScope.getObject("MeasDimName");
        }
        return null;
    }

    public static IDResolver getIDResolver(XMLContext xMLContext) {
        ObjectScope objectScope;
        if (xMLContext != null && (objectScope = xMLContext.getScope()) != null) {
            return (IDResolver)objectScope.getObject("PersistableIDResolver");
        }
        return null;
    }
}

