/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.SeparatorBorderPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.PagingControlAttributes;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutSpreadTable;

public class TableLayout
extends Layout {
    public static final String HIDE_DUPLICATE_ROWS = "HideDuplicateRows";
    protected static final String m_method_updateLDisplay = "updateLayerDisplay";
    protected static final Border BORDER_SINGLE_LINE = new BorderAdapter((BorderPainter)new SeparatorBorderPainter(1, true, 0));
    private JCheckBox m_duplicateRowsChkBox;
    private LayoutSpreadTable m_table;
    private JScrollPane m_scrollPane;
    private TablePropertyChangeListener m_listener = new TablePropertyChangeListener();
    private PagingControlAttributes m_pca;
    private boolean m_bDuplicateRowsControlVisible;

    public TableLayout() {
        Layout.LayoutPivotListener layoutPivotListener = new Layout.LayoutPivotListener();
        this.m_duplicateRowsChkBox = new JCheckBox();
        this.m_duplicateRowsChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                TableLayout.this.firePropertyChange(TableLayout.HIDE_DUPLICATE_ROWS, !bl, bl);
            }
        });
        this.m_table = new LayoutSpreadTable();
        this.m_table.setLayoutPanel(this);
        this.m_table.setEdge(0);
        this.m_table.addPivotListener(layoutPivotListener);
        this.m_table.addPropertyChangeListener(this.m_listener);
        this.m_scrollPane = new JScrollPane((Component)((Object)this.m_table));
        this.m_scrollPane.setVerticalScrollBarPolicy(21);
        this.m_scrollPane.setBorder(BORDER_SINGLE_LINE);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_scrollPane, "Center");
        jPanel.setBorder(UIBorderFactory.getLoweredBevelBorder());
        this.add(jPanel);
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_popupManager.setColumnLayoutComponent(this.m_table);
        this.m_table.setPopupManager(this.m_popupManager);
        this.m_popupManager.setPivotListener(layoutPivotListener);
        this.updateTextUsingCorrectLocale();
        this.m_componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TableLayout.this.resizeDescriptionLabel();
            }
        };
        this.addComponentListener(this.m_componentListener);
    }

    public void setPagingControlAttributes(PagingControlAttributes pagingControlAttributes) {
        this.m_pca = pagingControlAttributes;
        if (this.m_pca != null) {
            this.m_showPageItemsChkBox.setSelected(this.m_pca.isPagingControlVisible());
        }
    }

    public boolean apply() {
        if (this.m_pca != null) {
            this.m_pca.setPagingControlVisible(this.m_bPagingControlVisible);
        }
        return super.apply();
    }

    public String getDescriptionText() {
        if (this.m_description != null && this.m_description.length() > 0) {
            return this.m_description;
        }
        return this.m_rBundle.getString("crosstabLayoutDesc");
    }

    public void setDuplicateRowsControlVisible(boolean bl) {
        if (this.m_bDuplicateRowsControlVisible != bl) {
            this.m_bDuplicateRowsControlVisible = bl;
            this.m_chkBoxHolderPanel.removeAll();
            if (bl) {
                this.m_chkBoxHolderPanel.add(this.m_showPageItemsChkBox);
                this.m_chkBoxHolderPanel.add(Box.createHorizontalStrut(100));
                this.m_chkBoxHolderPanel.add(this.m_duplicateRowsChkBox);
            }
            this.m_chkBoxHolderPanel.revalidate();
        }
    }

    public boolean isDuplicateRowsControlVisible() {
        return this.m_bDuplicateRowsControlVisible;
    }

    public void setLayoutAccess(LayoutAccess layoutAccess) {
        this.m_layoutAccess = layoutAccess;
        this.m_layoutAccess.setCursorEvaluation(true);
        if (this.m_layoutAccess.getDataSource() != null) {
            this.m_dataDirector = this.m_layoutAccess.getDataSource().createRelationalDataDirector();
            if (this.m_dataDirector != null) {
                this.m_dataDirector.addDataDirectorListener(this);
            }
        }
        this.updateLayerDisplay();
    }

    public void setLayoutContext(LayoutContext layoutContext) {
        this.m_layoutContext = layoutContext;
        this.setLayoutAccess(this.m_layoutContext.createRelationalLayoutAccess());
    }

    public Component getInitialFocus() {
        if (this.m_showPageItemsChkBox.isEnabled()) {
            return this.m_showPageItemsChkBox;
        }
        if (this.isDuplicateRowsControlVisible()) {
            return this.m_duplicateRowsChkBox;
        }
        return this.m_table;
    }

    public void cleanup(boolean bl) {
        if (bl) {
            this.removeComponentListener(this.m_componentListener);
            this.m_table.removePropertyChangeListener(this.m_listener);
            this.m_table.setItems(null);
            this.m_table.cleanup();
            this.removeAll();
            this.m_duplicateRowsChkBox = null;
            this.m_scrollPane = null;
            this.m_table = null;
            this.m_listener = null;
        }
    }

    public String getHelpContextID() {
        if (this.m_bPagingControlVisible) {
            if (this.m_bDuplicateRowsControlVisible) {
                return String.valueOf(this.getClass().getName()) + "_PageCtrl_DupCtrl";
            }
            return String.valueOf(this.getClass().getName()) + "_PageCtrl_NoDupCtrl";
        }
        if (this.m_bDuplicateRowsControlVisible) {
            return String.valueOf(this.getClass().getName()) + "_NoPageCtrl_DupCtrl";
        }
        return String.valueOf(this.getClass().getName()) + "_NoPageCtrl_NoDupCtrl";
    }

    protected void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        this.m_popupManager.setColumnName(this.m_rBundle.getString("Column"));
        this.m_duplicateRowsChkBox.setText(StringUtils.stripMnemonic((String)this.m_rBundle.getString("Hide Duplicate Rows")));
        this.m_duplicateRowsChkBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_rBundle.getString("Hide Duplicate Rows")));
    }

    protected void updateLayerDisplay() {
        String[] stringArray;
        block5: {
            super.updateLayerDisplay();
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, true);
            stringArray = null;
            if (this.m_dataAccess != null) {
                try {
                    int n = this.m_dataAccess.getEdgeExtent(0);
                    stringArray = new String[n];
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = this.m_dataAccess.getMemberMetadata(0, n2, n2, this.getMemberMetadataLabelType());
                        if (object != null) {
                            stringArray[n2] = object.toString();
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    if (this.m_eh == null) break block5;
                    this.m_eh.error(exception, this.getClass().getName(), m_method_updateLDisplay);
                }
            }
        }
        this.m_table.setItems(stringArray);
        this.revalidate();
        this.repaint();
    }

    void deselectAll() {
        this.m_table.clearSelection();
        this.m_pageEdgeLayers.setSelectedItem(null);
    }

    void tableSelectionChanged() {
        this.m_pageEdgeLayers.setSelectedItem(null);
    }

    private class TablePropertyChangeListener
    implements PropertyChangeListener {
        TablePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selection".equals(propertyChangeEvent.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(propertyChangeEvent.getNewValue())) {
                TableLayout.this.tableSelectionChanged();
            }
        }
    }
}

