/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.dss.util.gui.layout.AbstractCrosstabHeader;
import oracle.dss.util.gui.layout.Crosstab;

public class RowHeader
extends AbstractCrosstabHeader {
    public RowHeader(Crosstab crosstab, int n) {
        super(crosstab, 1, n);
        this.setDefaultColumnWidth(30);
        this.getColumnHeader().setCanResizeItems(false);
        this.setColumnHeaderHeight(10);
        this.setOutline(true);
    }

    public void setItems(String[] stringArray) {
        super.setItems(stringArray);
        this._setSizes();
    }

    public int getSelectedIndex() {
        TwoDSelection twoDSelection = this.getGrid().getSelection();
        OneDSelection oneDSelection = twoDSelection.getColumnSelection();
        int n = -1;
        if (!oneDSelection.isEmpty()) {
            n = oneDSelection.getSingleItem();
        } else {
            Cell cell = twoDSelection.getSingleCell();
            if (cell != null) {
                n = cell.row;
            }
        }
        return n;
    }

    protected AbstractCrosstabHeader.CrosstabModel createModel() {
        return new RowModel();
    }

    protected void selectionChanged() {
        this.getCrosstab().rowSelectionChanged();
    }

    protected TwoDSelection getNewFocusSelection() {
        return new TwoDSelection(0, 0);
    }

    protected void focusLost() {
        try {
            this.getColumnHeader().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void paintDropFeedback(Graphics graphics, int n, boolean bl) {
        if (bl) {
            super.paintDropFeedback(graphics, n, bl);
        } else {
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            int n2 = this.getGrid().getRowCount();
            int n3 = n != n2 ? this.getGrid().getRowPosition(n) : (n2 == 0 ? 0 : this.getRowGeometryManager().getTotalSize());
            graphics.fillRect(0, n3, this.getWidth(), 4);
            if (color != null) {
                graphics.setColor(color);
            }
        }
    }

    protected int getDropIndex(Point point, boolean bl, boolean bl2) {
        if (bl) {
            return super.getDropIndex(point, bl, bl2);
        }
        point = this.getGrid().convertOuterToCanvas(point.x, point.y);
        int n = this.getGrid().getRowAt(point.y);
        if (n == -1) {
            if (point.y > this.getRowGeometryManager().getTotalSize()) {
                n = this.getGrid().getRowCount();
            }
        } else {
            int n2;
            int n3 = this.getGrid().getRowPosition(n);
            if (point.y > n3 + (n2 = this.getGrid().getRowHeight(n)) / 2) {
                ++n;
            }
        }
        return n;
    }

    private void _setSizes() {
        int n = this.getModel().getColumnCount();
        if (n == 0) {
            return;
        }
        int n2 = n - 1;
        int n3 = this._getColumnSize(n2);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = (n2 - n4) * this.getDefaultColumnWidth();
            int n6 = this._getColumnSize(n4) - n5;
            if (n6 > n3) {
                n3 = n6;
            }
            ++n4;
        }
        this.setColumnWidth(n2, n3 + 1);
        this.invalidate();
    }

    private int _getColumnSize(int n) {
        return this.getElementWidth(this.getItem(n));
    }

    private class RowModel
    extends AbstractCrosstabHeader.CrosstabModel {
        RowModel() {
        }

        public int getColumnCount() {
            return this.getRowCount();
        }

        protected AbstractPivotHeaderCell createCell(int n, int n2) {
            AbstractCrosstabHeader.ExtendedCell extendedCell = null.new AbstractCrosstabHeader.ExtendedCell(0, n2, n, 1, this.getElement(n));
            extendedCell.setIndent(n);
            return extendedCell;
        }

        protected void fireEvents(int n, int n2) {
            int n3 = n2 - n;
            if (n3 > 0) {
                this.fireModelEvent(2001, 0, n3);
                this.fireModelEvent(2004, 0, n3);
            } else if (n3 < 0) {
                this.fireModelEvent(2002, 0, -n3);
                this.fireModelEvent(2005, 0, -n3);
            }
        }
    }
}

