/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutComponent;

public class DataPointGrid
extends Grid
implements LayoutComponent {
    private static final int _DEFAULT_WIDTH = 20;
    private static final int _DEFAULT_HEIGHT = 20;
    private static final int _DROP_FEEDBACK_SIZE = 4;
    private int _edge;
    private int _dragIndex = -1;
    private int _dropIndex = -1;
    private Crosstab _crosstab;
    private GridDS _model;
    private GridListener _listener;
    private GridDragDropAdapter _dragDrop;
    private Layout.PopupManager _popupManager;

    public DataPointGrid(Crosstab crosstab, int n) {
        this._crosstab = crosstab;
        this._edge = n;
        this._model = new GridDS();
        this.setModel((TwoDModel)this._model);
        this.setDefaultInputHandler(new GridInputHandler());
        this._listener = new GridListener();
        this.addPropertyChangeListener(this._listener);
        this.enableEvents(4L);
        this._dragDrop = null.new GridDragDropAdapter(this);
    }

    public void setItems(String[] stringArray) {
        this._model.setItems(stringArray);
        this._setSizes();
    }

    public String getItem(int n) {
        return this._model.getElement(n);
    }

    public String[] getItems() {
        int n = this.getOrientation() == 0 ? this._model.getColumnCount() : this._model.getRowCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public int getEdge() {
        return this._edge;
    }

    public void setEdge(int n) {
        this._edge = n;
    }

    public int getSelectedIndex() {
        return this._getSelectedIndex();
    }

    public void clearSelection() {
        try {
            this.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getOrientation() {
        return this._model.getOrientation();
    }

    public void setOrientation(int n) {
        this._model.setOrientation(n);
        if (n == 1 && this.getColumnCount() != 0) {
            this.setColumnWidth(0, -1);
        }
        if (n == 1) {
            this.setPreferredColumnsOnScreen(0);
            this.setPreferredRowsOnScreen(3);
        } else {
            this.setPreferredColumnsOnScreen(3);
            this.setPreferredRowsOnScreen(0);
        }
        this._setSizes();
    }

    public void setColumnWidth(int n) {
        if (this.getOrientation() == 1) {
            this.setDefaultColumnWidth(n - 4);
        }
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public boolean isFocusTraversable() {
        return this.getColumnCount() != 0;
    }

    public Insets getAutoscrollInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paintCanvasInterior(Graphics graphics) {
        super.paintCanvasInterior(graphics);
        if (this._dragIndex != -1 && this._dropIndex != -1) {
            this._paintDropFeedback(graphics);
        }
    }

    public void cleanup() {
        this.setModel(null);
        this.setDefaultInputHandler(null);
        this.removePropertyChangeListener(this._listener);
        if (this._dragDrop != null) {
            this._dragDrop.cleanup();
        }
        this._crosstab = null;
        this._model = null;
    }

    void firePivotEvent(Object object, int n, Object object2, int n2) {
        if (object == object2 && n == n2) {
            return;
        }
        this._crosstab.firePivotEvent(object, n, object2, n2);
    }

    private int _getSelectedIndex() {
        int n = -1;
        Cell cell = this.getSelection().getSingleCell();
        if (cell != null) {
            n = this.getOrientation() == 0 ? cell.column : cell.row;
        }
        return n;
    }

    private void _paintDropFeedback(Graphics graphics) {
        if (this._dropIndex == this._dragIndex) {
            return;
        }
        Rectangle rectangle = this.getInnerBounds();
        Dimension dimension = this.getCanvasSize();
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        if (this.getOrientation() == 0) {
            int n;
            int n2 = this.getColumnCount();
            int n3 = this._dropIndex < n2 ? this.getColumnPosition(this._dropIndex) : (this._dropIndex == n2 && n2 != 0 ? this.getColumnPosition(this._dropIndex - 1) + this.getColumnWidth(this._dropIndex - 1) : 0);
            int n4 = n3 - 2;
            if (n4 < rectangle.x + (n = -this.getCanvasOriginX())) {
                n4 = rectangle.x + n;
            }
            if (n4 + 4 > rectangle.width + n) {
                n4 = rectangle.width + n - 4;
            }
            graphics.fillRect(n4, 0, 4, rectangle.height);
        } else {
            int n;
            int n5 = this.getRowCount();
            int n6 = this._dropIndex < n5 ? this.getRowPosition(this._dropIndex) : (this._dropIndex == n5 && n5 != 0 ? this.getRowPosition(this._dropIndex - 1) + this.getRowHeight(this._dropIndex - 1) : 0);
            int n7 = n6 - 2;
            if (n7 < rectangle.y + (n = -this.getCanvasOriginY())) {
                n7 = rectangle.y + n;
            }
            if (n7 + 4 > rectangle.height + n) {
                n7 = rectangle.height + n - 4;
            }
            graphics.fillRect(0, n7, rectangle.width, 4);
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    private void _setSizes() {
        Painter painter = this.getDefaultPainter();
        PaintContext paintContext = this.getPaintContext();
        SingleAppearanceManager singleAppearanceManager = (SingleAppearanceManager)this.getAppearanceManager();
        ImmInsets immInsets = singleAppearanceManager.getAppearance().getInsets();
        int n = immInsets.left + immInsets.right + 4;
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.getRowCount()) {
                paintContext = this.getCellPaintContext(n2, n4);
                int n5 = painter.getPreferredSize((PaintContext)paintContext).width;
                if (n5 > n3) {
                    n3 = n5;
                }
                ++n4;
            }
            if (this.getOrientation() == 0) {
                this.setColumnWidth(n2, n3 + n);
            } else {
                this.setDefaultColumnWidth(n3 + n);
            }
            ++n2;
        }
        this.invalidate();
    }

    void setDragItem(int n) {
        this._dragIndex = n;
    }

    void setDropLocation(int n) {
        if (this._dropIndex != n) {
            this._dropIndex = n;
            this.paintImmediateInterior();
        }
    }

    private class GridDragDropAdapter
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private DataPointGrid _grid;
        private DropTarget _gridTarget;
        private DragGestureRecognizer _recognizer;

        public GridDragDropAdapter(DataPointGrid dataPointGrid2) {
            this._grid = dataPointGrid2;
            this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)dataPointGrid2), 2, (DragGestureListener)this);
            this._gridTarget = new DropTarget((Component)((Object)dataPointGrid2), (DropTargetListener)this);
        }

        public void cleanup() {
            this._gridTarget.setActive(false);
            this._gridTarget.setComponent(null);
            this._recognizer.removeDragGestureListener((DragGestureListener)this);
            this._recognizer = null;
            this._gridTarget = null;
            this._grid = null;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this._acceptDrag(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            int n = this._getIndex(dropTargetDragEvent.getLocation());
            this._setDropLocation(n);
        }

        public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._setDropLocation(-1);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n;
            dropTargetDropEvent.acceptDrop(1);
            this._setDropLocation(-1);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = null;
            try {
                object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object = null;
            }
            catch (IOException iOException) {
                object = null;
            }
            if (object != null && object instanceof PivotTransfer && (n = this._getIndex(dropTargetDropEvent.getLocation())) != -1) {
                PivotTransfer pivotTransfer = (PivotTransfer)object;
                Object object2 = pivotTransfer.getSource();
                int n2 = pivotTransfer.getIndex();
                DataPointGrid dataPointGrid = this._grid;
                int n3 = n;
                if (object2 == dataPointGrid && n3 > n2) {
                    --n3;
                }
                this._grid.firePivotEvent(object2, n2, dataPointGrid, n3);
            }
            dropTargetDropEvent.dropComplete(object != null);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this._grid.getColumnCount() == 0) {
                return;
            }
            Point point = dragGestureEvent.getDragOrigin();
            point = this._grid.convertOuterToCanvas(point.x, point.y);
            int n = this._grid.getColumnAt(point.x);
            int n2 = this._grid.getRowAt(point.y);
            if (n == -1 || n2 == -1) {
                return;
            }
            int n3 = this._grid.getOrientation() == 0 ? n : n2;
            Image image = null;
            this._grid.setDragItem(n3);
            dragGestureEvent.startDrag(null, image, point, PivotTransfer.createTransferable((Object)this._grid, (int)n3), (DragSourceListener)this);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this._grid.setDragItem(-1);
        }

        private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            if (dataFlavorArray == null) {
                return false;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        void _setDropLocation(int n) {
            this._grid.setDropLocation(n);
        }

        private int _getIndex(Point point) {
            int n = -1;
            point = this._grid.convertOuterToCanvas(point.x, point.y);
            if (this._grid.getOrientation() == 0) {
                int n2 = this._grid.getColumnCount();
                if (n2 == 0) {
                    n = 0;
                } else {
                    int n3;
                    int n4;
                    n = this._grid.getColumnAt(point.x);
                    if (n == -1) {
                        n = n2 - 1;
                    }
                    if (point.x > (n4 = this._grid.getColumnPosition(n)) + (n3 = this._grid.getColumnWidth(n)) / 2) {
                        ++n;
                    }
                }
            } else {
                int n5 = this._grid.getRowCount();
                if (n5 == 0) {
                    n = 0;
                } else {
                    int n6;
                    int n7;
                    n = this._grid.getRowAt(point.y);
                    if (n == -1) {
                        n = n5 - 1;
                    }
                    if (point.y > (n7 = this._grid.getRowPosition(n)) + (n6 = this._grid.getRowHeight(n)) / 2) {
                        ++n;
                    }
                }
            }
            return n;
        }
    }

    private class GridInputHandler
    extends CellInputHandler {
        GridInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            if (bl && mouseEvent.getClickCount() == 2) {
                int n3 = DataPointGrid.this.getOrientation() == 0 ? n : n2;
                DataPointGrid.this._crosstab.dataPointToAxisItem(n3);
                mouseEvent.consume();
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                mouseEvent.consume();
                String string = (String)DataPointGrid.this.getModel().getData(n, n2);
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n) {
                    n4 += DataPointGrid.this.getColumnWidth(n6);
                    ++n6;
                }
                n6 = 0;
                while (n6 < n2) {
                    n5 += DataPointGrid.this.getRowHeight(n6);
                    ++n6;
                }
                Point point = new Point(n4 + mouseEvent.getX(), n5 + mouseEvent.getY());
                if (DataPointGrid.this._popupManager != null) {
                    DataPointGrid.this._popupManager.createPopup(DataPointGrid.this, string, (JComponent)((Object)DataPointGrid.this), point);
                }
                DataPointGrid.this.requestFocus(n, n2, null);
                try {
                    TwoDSelection twoDSelection = new TwoDSelection(n, n2);
                    DataPointGrid.this.setSelection(twoDSelection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            super.mousePressed(mouseEvent, grid, n, n2);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                keyEvent.consume();
                Point point = new Point();
                point.x = DataPointGrid.this.getColumnWidth(0) * n;
                point.y = DataPointGrid.this.getRowHeight(0) * (n2 + 1);
                String string = (String)DataPointGrid.this.getModel().getData(n, n2);
                DataPointGrid.this._popupManager.createPopup(DataPointGrid.this, string, (JComponent)((Object)DataPointGrid.this), point);
            }
            super.keyPressed(keyEvent, grid, n, n2);
        }
    }

    private class GridListener
    implements PropertyChangeListener {
        GridListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selection".equals(propertyChangeEvent.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(propertyChangeEvent.getNewValue())) {
                DataPointGrid.this._crosstab.gridSelectionChanged();
            }
        }
    }

    private class GridDS
    extends AbstractTwoDModel {
        private int _orientation = 1;
        private int _otherAxisCount;
        private ArrayOneDModel _itemStore = new ArrayOneDModel(0);

        public void setOrientation(int n) {
            if (this._orientation != n) {
                int n2;
                int n3 = this.getColumnCount();
                int n4 = this.getRowCount();
                this._orientation = n;
                int n5 = this.getColumnCount();
                int n6 = this.getRowCount();
                int n7 = n5 - n3;
                if (n7 > 0) {
                    n2 = 2001;
                    this.fireModelEvent(n2, 0, n7);
                } else if (n7 < 0) {
                    n2 = 2002;
                    this.fireModelEvent(n2, 0, -n7);
                }
                n7 = n6 - n4;
                if (n7 > 0) {
                    n2 = 2004;
                    this.fireModelEvent(n2, 0, n7);
                } else if (n7 < 0) {
                    n2 = 2005;
                    this.fireModelEvent(n2, 0, -n7);
                }
            }
        }

        public int getOrientation() {
            return this._orientation;
        }

        public String getElement(int n) {
            return (String)this._itemStore.getData(n);
        }

        public void setItems(Object[] objectArray) {
            int n;
            int n2 = this._itemStore.getItemCount();
            this._itemStore.removeItems(0, n2);
            int n3 = n = objectArray == null ? 0 : objectArray.length;
            if (n != 0) {
                this._itemStore.addItems(0, objectArray);
            }
            this._fireEvents(n2, n);
        }

        public int getColumnCount() {
            if (this._orientation == 0) {
                return this._itemStore.getItemCount();
            }
            return this._otherAxisCount;
        }

        public int getRowCount() {
            if (this._orientation == 1) {
                return this._itemStore.getItemCount();
            }
            return this._otherAxisCount;
        }

        public Object getData(int n, int n2) {
            int n3 = this._orientation == 0 ? n : n2;
            return this.getElement(n3);
        }

        public void setData(int n, int n2, Object object) {
        }

        private void _fireEvents(int n, int n2) {
            int n3;
            int n4 = n2 - n;
            if (n4 > 0) {
                n3 = this._orientation == 0 ? 2001 : 2004;
                this.fireModelEvent(n3, 0, n4);
            } else if (n4 < 0) {
                int n5 = n3 = this._orientation == 0 ? 2002 : 2005;
                if (n3 == 2002 && DataPointGrid.this.getFirstColumnOnScreen() >= n2) {
                    DataPointGrid.this.setFirstColumnOnScreen(n2 - 1);
                }
                if (n3 == 2005 && DataPointGrid.this.getFirstRowOnScreen() >= n2) {
                    DataPointGrid.this.setFirstRowOnScreen(n2 - 1);
                }
                this.fireModelEvent(n3, 0, -n4);
            }
            if (n2 != 0 && this._otherAxisCount == 0) {
                n3 = this._orientation == 0 ? 2004 : 2001;
                this._otherAxisCount = 1;
                this.fireModelEvent(n3, 0, 1);
            } else if (n2 == 0 && this._otherAxisCount != 0) {
                n3 = this._orientation == 0 ? 2005 : 2002;
                this._otherAxisCount = 0;
                this.fireModelEvent(n3, 0, 1);
            }
        }
    }
}

