/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedTextDocument
extends PlainDocument {
    private int maxCharLimit = 1024;
    private String[] tokenList;

    public LimitedTextDocument() {
        this(0, null);
    }

    public LimitedTextDocument(int n) {
        this(n, null);
    }

    public void setSize(int n) {
        this.maxCharLimit = n;
    }

    public int getSize() {
        return this.maxCharLimit;
    }

    public LimitedTextDocument(int n, String[] stringArray) {
        if (n > 0) {
            this.maxCharLimit = n;
        }
        this.tokenList = stringArray;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.equals("")) {
            return;
        }
        int n2 = this.getLength() + string.length();
        if (n2 <= this.maxCharLimit) {
            super.insertString(n, string, attributeSet);
        } else {
            int n3 = 0;
            if (this.getLength() == 0) {
                String string2 = string.substring(0, this.maxCharLimit);
                if (this.tokenList != null) {
                    int n4 = -1;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < this.tokenList.length) {
                        String string3 = this.tokenList[n6];
                        n3 = string2.lastIndexOf(string3);
                        if (n3 > n4) {
                            n4 = n3;
                            n5 = string3.length();
                        }
                        ++n6;
                    }
                    if (n4 == -1) {
                        if (string.charAt(this.maxCharLimit) != ' ' && (n3 = string2.lastIndexOf(32)) != -1) {
                            string2 = string2.substring(0, n3);
                        }
                    } else if (string.charAt(this.maxCharLimit) != ' ') {
                        n3 = string2.lastIndexOf(32);
                        string2 = n3 != -1 ? (n3 > n4 ? string2.substring(0, n3) : string2.substring(0, n4 + n5)) : string2.substring(0, n4 + n5);
                    }
                } else if (string.charAt(this.maxCharLimit) != ' ' && (n3 = string2.lastIndexOf(32)) != -1) {
                    string2 = string2.substring(0, n3);
                }
                super.insertString(n, string2, attributeSet);
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

