/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;

public class LazyScrollPane
extends JScrollPane {
    private static final int HORIZONTAL_GAP = 10;
    private static final int DEFAULT_THRESHOLD = 1000;
    private MouseDelayListener m_mouseDelayListener = new MouseDelayListener();
    private JComponent m_component;
    private JList m_list;
    private JScrollBar m_verticalScrollBar;
    private int m_intThreshold = 1000;
    private int m_intRowHeight = -1;
    private MouseEvent m_mouseEvent;
    private ResourceBundle m_bundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    private JWindow m_window;
    private JPanel m_panel;
    private boolean m_blnShowTooltip = true;
    private Point m_location;
    private JToolTip m_toolTip;

    public LazyScrollPane(JComponent jComponent, int n) {
        super(jComponent);
        this.m_intThreshold = n;
        this.m_component = jComponent;
        if (jComponent instanceof JList) {
            this.m_list = (JList)jComponent;
        }
        this.setLazyModel();
    }

    public LazyScrollPane(JComponent jComponent) {
        this(jComponent, 1000);
    }

    public boolean isShowTooltip() {
        return this.m_blnShowTooltip;
    }

    public void setShowTooltip(boolean bl) {
        this.m_blnShowTooltip = bl;
    }

    private void setLazyModel() {
        LazyModel lazyModel = new LazyModel();
        this.getVerticalScrollBar().addMouseListener(this.m_mouseDelayListener);
        this.getVerticalScrollBar().setModel(lazyModel);
        this.updateUI();
        this.m_verticalScrollBar = this.getVerticalScrollBar();
    }

    private JWindow getWindow() {
        if (this.m_window == null) {
            this.m_window = new JWindow();
            this.m_window.getContentPane().add(this.getPanel());
        }
        return this.m_window;
    }

    private JPanel getPanel() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel(new BorderLayout());
        }
        return this.m_panel;
    }

    private int getX(JScrollBar jScrollBar, JComponent jComponent) {
        if (jScrollBar != null) {
            if (jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum()) {
                return this.getY(jScrollBar, jComponent);
            }
            return jScrollBar.getValue() / (this.getRowHeight(jComponent) - 1) + 1;
        }
        return -1;
    }

    private int getY(JScrollBar jScrollBar, JComponent jComponent) {
        if (jScrollBar != null) {
            return jScrollBar.getMaximum() / (this.getRowHeight(jComponent) - 1);
        }
        return -1;
    }

    private int getRowHeight(JComponent jComponent) {
        Rectangle rectangle;
        if (this.m_intRowHeight == -1 && jComponent != null && jComponent instanceof JList && (rectangle = ((JList)jComponent).getCellBounds(0, 0)) != null) {
            this.m_intRowHeight = rectangle.height + 1;
        }
        return this.m_intRowHeight;
    }

    private String getXofY(JScrollBar jScrollBar) {
        if (jScrollBar != null && this.m_list != null) {
            Object[] objectArray = new String[]{Integer.toString(this.getX(jScrollBar, this.m_component)), Integer.toString(this.getY(jScrollBar, this.m_component))};
            return MessageFormat.format(this.m_bundle.getString("XofY"), objectArray);
        }
        return null;
    }

    private Point getInitialTooltipLocation(JWindow jWindow, JScrollBar jScrollBar, MouseEvent mouseEvent) {
        if (jWindow != null && jScrollBar != null && jScrollBar.isShowing() && mouseEvent != null) {
            int n = jScrollBar.getLocationOnScreen().x - jWindow.getWidth();
            int n2 = this.getLocationOnScreen().y + mouseEvent.getY() - this.getRowHeight(this.m_component) / 2;
            return new Point(n - 10, n2);
        }
        return null;
    }

    private Point getTooltipLocation(JWindow jWindow, JScrollBar jScrollBar) {
        if (jWindow != null && jScrollBar != null && jScrollBar.isShowing() && this.m_location != null) {
            int n = jScrollBar.getLocationOnScreen().x - jWindow.getWidth();
            int n2 = this.m_location.y;
            return new Point(n - 10, n2);
        }
        return null;
    }

    private void updateXofY() {
        this.m_toolTip = new JToolTip();
        this.m_toolTip.setTipText(this.getXofY(this.m_verticalScrollBar));
        this.getPanel().removeAll();
        this.getPanel().add((Component)this.m_toolTip, "Center");
        this.getWindow().pack();
        this.m_location = this.getTooltipLocation(this.getWindow(), this.m_verticalScrollBar);
        if (this.m_location != null) {
            this.getWindow().setLocation(this.m_location);
        }
    }

    class LazyModel
    extends DefaultBoundedRangeModel {
        public LazyModel() {
            super(0, 10, 0, 100);
        }

        protected void fireStateChanged() {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.updateXofY();
            }
            if (!this.getValueIsAdjusting() || LazyScrollPane.this.getY(LazyScrollPane.this.m_verticalScrollBar, LazyScrollPane.this.m_component) <= LazyScrollPane.this.m_intThreshold) {
                super.fireStateChanged();
            }
        }
    }

    class MouseDelayListener
    extends MouseAdapter {
        MouseDelayListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.m_location = LazyScrollPane.this.getInitialTooltipLocation(LazyScrollPane.this.m_window, LazyScrollPane.this.m_verticalScrollBar, mouseEvent);
                if (LazyScrollPane.this.m_location != null) {
                    LazyScrollPane.this.getWindow().setLocation(LazyScrollPane.this.m_location);
                }
                LazyScrollPane.this.getWindow().setVisible(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (LazyScrollPane.this.isShowTooltip() && LazyScrollPane.this.m_list != null) {
                LazyScrollPane.this.getWindow().setVisible(false);
            }
        }
    }
}

