/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.dss.util.FocusUtility;

public class DragList
extends JList {
    private static final int HEIGHT = 1;
    private boolean m_blnMetaKeyDown;
    private Rectangle m_rectangle;
    private boolean m_blnDragging;
    private boolean m_blnInSelection;
    private boolean m_blnManualSortGuiEnabled = true;
    private boolean m_blnFromMouseEvent;

    public DragList() {
    }

    public DragList(ListModel listModel) {
        super(listModel);
    }

    public DragList(Object[] objectArray) {
        super(objectArray);
    }

    public DragList(Vector vector) {
        super(vector);
    }

    public boolean isManualSortGuiEnabled() {
        return this.m_blnManualSortGuiEnabled;
    }

    public void setManualSortGuiEnabled(boolean bl) {
        this.m_blnManualSortGuiEnabled = bl;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && !this.m_blnFromMouseEvent) {
            FocusUtility.setFocusToFirstSelectedRow(this, focusEvent);
            this.ensureIndexIsVisible(this.getLeadSelectionIndex());
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.m_blnFromMouseEvent = true;
        if (this.isManualSortingGuiEnabled() && this.isEnabled() && !this.m_blnMetaKeyDown) {
            if (mouseEvent.getID() == 501) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.m_blnDragging = true;
                if (this.inSelection(mouseEvent)) {
                    this.m_blnInSelection = true;
                    this.m_blnFromMouseEvent = false;
                    return;
                }
            }
            if (mouseEvent.getID() == 502) {
                this.setCursor(Cursor.getDefaultCursor());
                this.m_blnDragging = false;
                this.m_rectangle = null;
                if (this.m_blnInSelection) {
                    this.m_blnInSelection = false;
                    this.clearSelection();
                } else {
                    this.repaint();
                }
            }
        }
        super.processMouseEvent(mouseEvent);
        this.m_blnFromMouseEvent = false;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isManualSortingGuiEnabled() && this.isEnabled()) {
            if (this.m_blnDragging && !this.inSelection(mouseEvent)) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n == -1 && mouseEvent.getY() > 0 && (double)mouseEvent.getY() < this.getSize().getHeight()) {
                    this.m_rectangle = this.getCellBounds(this.getModel().getSize() - 1, this.getModel().getSize() - 1);
                    this.m_rectangle.setLocation(this.m_rectangle.x, this.m_rectangle.y + this.m_rectangle.height);
                } else {
                    this.m_rectangle = this.getCellBounds(n, n);
                    if (this.m_rectangle != null) {
                        boolean bl;
                        boolean bl2 = bl = mouseEvent.getY() % this.m_rectangle.height > this.m_rectangle.height / 2;
                        if (bl && n == this.getMinSelectionIndex() - 1 || !bl && n == this.getMaxSelectionIndex() + 1) {
                            this.m_rectangle = null;
                        } else if (bl) {
                            this.m_rectangle.setLocation(this.m_rectangle.x, this.m_rectangle.y + this.m_rectangle.height);
                        }
                    }
                }
            } else {
                this.m_rectangle = null;
            }
            this.repaint();
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.isManualSortingGuiEnabled() && (keyEvent.getID() == 401 || keyEvent.getID() == 402)) {
            this.m_blnMetaKeyDown = keyEvent.isShiftDown() || keyEvent.isControlDown();
        }
    }

    protected boolean isManualSortingGuiEnabled() {
        return this.isManualSortGuiEnabled() && this.getModel().getSize() > 1;
    }

    protected boolean inSelection(MouseEvent mouseEvent) {
        int n = this.locationToIndex(mouseEvent.getPoint());
        return n >= this.getMinSelectionIndex() && n <= this.getMaxSelectionIndex();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_rectangle != null) {
            graphics.fillRect(this.m_rectangle.x, this.m_rectangle.y, this.m_rectangle.width, 1);
        }
    }
}

