/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import oracle.dss.util.dimensionList.DefaultListDataModel;
import oracle.dss.util.dimensionList.DimComboCellRenderer;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionComboEvent;
import oracle.dss.util.dimensionList.DimensionComboListener;

public class DimensionCombo
extends JComboBox
implements Serializable {
    public static final int BELOW_PARENT = 0;
    public static final int ABOVE_PARENT = 1;
    private DefDimComboCellRenderer m_cellRenderer;
    private DefaultListDataModel m_dataModel;
    private transient boolean m_added;
    private transient Vector m_listeners;
    protected int m_debugLevel;

    public DimensionCombo() {
        this.init();
    }

    public synchronized void addDimensionComboListener(DimensionComboListener dimensionComboListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(dimensionComboListener)) {
            this.m_listeners.addElement(dimensionComboListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_added = true;
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public int getCount() {
        DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
        if (dimListDataModel != null) {
            return dimListDataModel.size();
        }
        return 0;
    }

    public synchronized void removeDimensionComboListener(DimensionComboListener dimensionComboListener) {
        if (this.m_listeners != null && !this.m_listeners.contains(dimensionComboListener)) {
            this.m_listeners.removeElement(dimensionComboListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setModel(DimListDataModel dimListDataModel) {
        super.setModel(dimListDataModel);
        if (dimListDataModel == null) {
            this.init();
        } else if (dimListDataModel.getSize() > 0) {
            super.setSelectedIndex(0);
        }
    }

    public void setSelectedIndex(int n) {
        int n2 = super.getSelectedIndex();
        if (n2 != n) {
            DimensionComboEvent dimensionComboEvent = new DimensionComboEvent(this, 9, n);
            this.notifyDimensionComboListener(dimensionComboEvent);
            if (!dimensionComboEvent.isConsumed()) {
                super.setSelectedIndex(n);
                dimensionComboEvent = new DimensionComboEvent(this, 10, n);
                this.notifyDimensionComboListener(dimensionComboEvent);
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.init();
        if (this.m_cellRenderer != null) {
            this.m_cellRenderer.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        System.out.println(String.valueOf(String.valueOf("DimensionCombo: valueChanged: ")) + listSelectionEvent);
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.notifyDimensionComboListener(new DimensionComboEvent(this, 10, listSelectionEvent.getFirstIndex()));
        } else {
            this.notifyDimensionComboListener(new DimensionComboEvent(this, 9, listSelectionEvent.getLastIndex()));
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = this.isPopupVisible();
        super.processKeyEvent(keyEvent);
        if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && keyEvent.getID() == 402) {
            boolean bl2 = this.isPopupVisible();
            if (bl && bl2) {
                this.setPopupVisible(false);
            }
            if (!bl && !bl2) {
                this.setPopupVisible(true);
            }
        }
        if (!this.isPopupVisible() && keyEvent.getID() == 402 && keyEvent.getKeyCode() == 40) {
            this.setPopupVisible(true);
        }
    }

    protected void init() {
        if (this.m_cellRenderer == null) {
            this.m_cellRenderer = null.new DefDimComboCellRenderer();
        }
        this.setRenderer(this.m_cellRenderer);
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
    }

    protected void notifyDimensionComboListener(DimensionComboEvent dimensionComboEvent) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector vector;
            DimensionCombo dimensionCombo = this;
            synchronized (dimensionCombo) {
                try {
                    vector = (Vector)this.m_listeners.clone();
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            DimListDataModel dimListDataModel = (DimListDataModel)this.getModel();
            if (dimensionComboEvent.getDataModel() == null) {
                dimensionComboEvent.setDataModel(dimListDataModel);
            }
            switch (dimensionComboEvent.getID()) {
                case 0: {
                    int n2 = 0;
                    while (n2 < n && !dimensionComboEvent.isConsumed()) {
                        DimensionComboListener dimensionComboListener = (DimensionComboListener)vector.elementAt(n2);
                        dimensionComboListener.dimensionChanged(dimensionComboEvent);
                        ++n2;
                    }
                    break;
                }
                case 9: {
                    int n3 = 0;
                    while (n3 < n && !dimensionComboEvent.isConsumed()) {
                        DimensionComboListener dimensionComboListener = (DimensionComboListener)vector.elementAt(n3);
                        dimensionComboListener.dimensionSelecting(dimensionComboEvent);
                        ++n3;
                    }
                    break;
                }
                case 10: {
                    int n4 = 0;
                    while (n4 < n && !dimensionComboEvent.isConsumed()) {
                        DimensionComboListener dimensionComboListener = (DimensionComboListener)vector.elementAt(n4);
                        dimensionComboListener.dimensionSelected(dimensionComboEvent);
                        ++n4;
                    }
                    break;
                }
            }
        }
    }

    class DefDimComboCellRenderer
    extends JLabel
    implements DimComboCellRenderer,
    Serializable {
        private transient int m_index;
        private transient int m_level = -1;
        private transient int m_state;
        private transient String m_meta = "";
        private transient boolean m_selected;
        private transient Color m_forenorm = Color.black;
        private transient Color m_backnorm = Color.white;
        private transient Color m_foresel = Color.white;
        private transient Color m_backsel = Color.blue;
        private transient Color m_lineColor = Color.lightGray;
        private int m_ascent;
        private int m_indentUnit = 12;
        private transient Color m_listforenorm = Color.black;
        private transient Color m_listbacknorm = Color.white;
        private transient Color m_listforesel = Color.white;
        private transient Color m_listbacksel = new Color(0, 0, 128);

        public DefDimComboCellRenderer() {
            this.init();
        }

        public void updateUI() {
            super.updateUI();
            this.init();
        }

        public void setIndentUnit(int n) {
            if (n > -1) {
                this.m_indentUnit = n;
                this.repaint();
            }
        }

        public int getIndentUnit() {
            return this.m_indentUnit;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = -1;
            int n3 = 0;
            String string = "";
            String string2 = "";
            if (object instanceof String) {
                string = (String)object;
                n2 = -1;
                n3 = 0;
            } else {
                DimListDataItem dimListDataItem = (DimListDataItem)object;
                if (dimListDataItem != null) {
                    string = dimListDataItem.getText();
                    n2 = dimListDataItem.getLevel();
                    n3 = dimListDataItem.getDrillState();
                    string2 = dimListDataItem.getMetaInfo();
                }
            }
            this.setText(string);
            this.m_level = n2;
            this.m_state = n3;
            this.m_index = n;
            this.m_meta = string2;
            if (n > -1) {
                this.setBackground(bl || bl2 ? this.m_backsel : this.m_listbacknorm);
                this.setForeground(bl || bl2 ? this.m_listforesel : this.m_listforenorm);
            } else {
                this.setBackground(bl || bl2 ? this.m_backsel : this.m_backnorm);
                this.setForeground(bl || bl2 ? this.m_foresel : this.m_forenorm);
            }
            return this;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.clear(graphics, dimension.width, dimension.height);
            if (this.m_index > -1) {
                this.paintTreeLines(graphics);
            } else {
                this.drawText(graphics, this.getText(), 0, dimension.width, dimension.height, this.m_ascent);
            }
        }

        private void init() {
            FontMetrics fontMetrics;
            Font font = this.getFont();
            if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                this.setIndentUnit(fontMetrics.stringWidth("W"));
                this.m_ascent = fontMetrics.getAscent();
            }
            this.m_forenorm = UIManager.getColor("ComboBox.foreground");
            this.m_backnorm = UIManager.getColor("ComboBox.background");
            this.m_foresel = UIManager.getColor("ComboBox.selectionForeground");
            this.m_backsel = UIManager.getColor("ComboBox.selectionBackground");
            this.m_listforenorm = UIManager.getColor("ComboBox.listForeground");
            this.m_listbacknorm = UIManager.getColor("ComboBox.listBackground");
            this.m_listforesel = UIManager.getColor("List.selectionForeground");
            this.m_listbacksel = UIManager.getColor("List.selectionBackground");
            this.m_lineColor = Color.lightGray;
        }

        private void clear(Graphics graphics, int n, int n2) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }

        private void paintTreeLines(Graphics graphics) {
            int n = 2;
            int n2 = 0;
            int n3 = this.m_indentUnit;
            int n4 = this.m_meta.length();
            Dimension dimension = this.getSize();
            if (n4 > 0) {
                int n5 = dimension.height / 2;
                int n6 = n + n4 * n3 - n3 / 2;
                graphics.setColor(this.m_lineColor);
                int n7 = 0;
                while (n7 < n4) {
                    char c = this.m_meta.charAt(n7);
                    if (n7 == 0) {
                        if (c == '0') {
                            graphics.drawLine(n6, 0, n6, dimension.height);
                            graphics.drawLine(n6, n5, n6 + n3 / 2, n5);
                        } else {
                            graphics.drawLine(n6, 0, n6, n5);
                            graphics.drawLine(n6, n5, n6 + n3 / 2, n5);
                        }
                    } else if (c == '0') {
                        graphics.drawLine(n6, 0, n6, dimension.height);
                    }
                    n6 -= n3;
                    ++n7;
                }
            }
            this.drawText(graphics, this.getText(), n + this.m_level * n3 + n2, dimension.width, dimension.height, this.m_ascent);
        }

        private void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n, n4);
        }
    }
}

