/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.dimensionList.DimFindEditor;
import oracle.dss.util.dimensionList.DimFindEvent;
import oracle.dss.util.dimensionList.DimFindEventListener;
import oracle.dss.util.dimensionList.DimFindHistory;
import oracle.dss.util.help.HelpContext;

public class DimFindTool
extends JPanel
implements ActionListener,
HelpContext,
Serializable {
    private JLabel m_findLabelMembersThat;
    private JLabel m_findLabel;
    private JLabel m_statusText;
    private JComboBox m_findCombo;
    private JComboBox m_findCombo1;
    private DimFindEditor m_findEditor;
    private DimFindEditor m_findEditor1;
    private JCheckBox m_caseCheck;
    private String m_closeText;
    private String m_findNextText;
    private String m_findHelpText;
    private JButton m_findNextButton;
    private JButton m_closeButton;
    private JButton m_findHelpButton;
    private boolean m_isListDisplayed;
    private Vector m_listeners;
    private Vector m_history = new Vector();
    private int m_position;
    private static String[] m_strLabelTypes;
    private static ResourceBundle m_localStrings;

    public DimFindTool() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel2.setLayout(gridBagLayout2);
        jPanel3.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.m_findLabelMembersThat = new JLabel();
        this.m_findCombo = new JComboBox();
        this.m_findLabelMembersThat.setLabelFor(this.m_findCombo);
        this.m_findEditor = new DimFindEditor();
        this.m_findEditor.addActionListener(this);
        jPanel.add(this.m_findLabelMembersThat);
        jPanel.add(this.m_findCombo);
        gridBagLayout.setConstraints(this.m_findLabelMembersThat, gridBagConstraints);
        gridBagLayout.setConstraints(this.m_findCombo, gridBagConstraints2);
        this.m_findLabel = new JLabel();
        this.m_findCombo1 = new JComboBox();
        this.m_findCombo1.setMaximumRowCount(3);
        this.m_findEditor1 = new DimFindEditor();
        this.m_findEditor1.addActionListener(this);
        this.m_findCombo1.setEditor(this.m_findEditor1);
        this.m_findCombo1.setEditable(true);
        this.m_findLabel.setLabelFor(this.m_findEditor1.getEditorComponent());
        JLabel jLabel = new JLabel();
        this.m_caseCheck = new JCheckBox();
        jPanel2.add(this.m_findLabel);
        jPanel2.add(this.m_findCombo1);
        jPanel2.add(jLabel);
        jPanel2.add(this.m_caseCheck);
        gridBagLayout2.setConstraints(this.m_findLabel, gridBagConstraints);
        gridBagLayout2.setConstraints(this.m_findCombo1, gridBagConstraints2);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
        gridBagLayout2.setConstraints(this.m_caseCheck, gridBagConstraints2);
        this.m_statusText = new JLabel();
        this.m_statusText.setText("  ");
        JLabel jLabel2 = new JLabel();
        jPanel3.add(this.m_statusText);
        jPanel3.add(jLabel2);
        gridBagLayout3.setConstraints(this.m_statusText, gridBagConstraints);
        gridBagLayout3.setConstraints(jLabel2, gridBagConstraints2);
        this.add(jPanel);
        this.add(Box.createVerticalStrut(15));
        this.add(jPanel2);
        this.add(Box.createVerticalStrut(5));
        this.add(jPanel3);
    }

    public synchronized void setPosition(int n) {
        this.m_position = n;
    }

    public int getPosition() {
        return this.m_position;
    }

    public synchronized void setStatusText(String string) {
        this.m_statusText.setText(string != null ? string : "");
    }

    public String getStatusText() {
        return this.m_statusText.getText();
    }

    public synchronized void setHistory(DimFindHistory dimFindHistory) {
        this.m_history.removeAllElements();
        if (dimFindHistory != null) {
            int n = 0;
            while (n < dimFindHistory.size()) {
                this.m_history.addElement(dimFindHistory.elementAt(n));
                ++n;
            }
        }
    }

    public DimFindHistory getHistory() {
        DimFindHistory dimFindHistory = new DimFindHistory();
        if (dimFindHistory != null) {
            Vector vector;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                try {
                    vector = (Vector)this.m_history.clone();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                dimFindHistory.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
        return dimFindHistory;
    }

    public synchronized void addDimFindEventListener(Object object) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(object)) {
            this.m_listeners.addElement(object);
        }
    }

    public synchronized void removeDimFindEventListener(Object object) {
        if (this.m_listeners != null && !this.m_listeners.contains(object)) {
            this.m_listeners.removeElement(object);
        }
    }

    public void processFindNextButton() {
        String string = null;
        boolean bl = false;
        JTextField jTextField = (JTextField)this.m_findEditor1.getEditorComponent();
        string = jTextField.getText();
        boolean bl2 = this.m_caseCheck.isSelected();
        int n = this.m_findCombo.getSelectedIndex();
        if (string.length() > 0) {
            this.updateHistory(string);
            DimFindEvent dimFindEvent = new DimFindEvent(this, 2, string, this.m_position, bl2, bl, n);
            this.notifyFindListeners(dimFindEvent);
        }
    }

    public void processCloseButton() {
        String string = null;
        boolean bl = false;
        JTextField jTextField = (JTextField)this.m_findEditor1.getEditorComponent();
        string = jTextField.getText();
        boolean bl2 = this.m_caseCheck.isSelected();
        int n = this.m_findCombo.getSelectedIndex();
        DimFindEvent dimFindEvent = new DimFindEvent(this, 1, "", this.m_position, bl2, bl, n);
        this.notifyFindListeners(dimFindEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        JTextField jTextField = (JTextField)this.m_findEditor1.getEditorComponent();
        string = jTextField.getText();
        boolean bl = this.m_caseCheck.isSelected();
        int n = this.m_findCombo.getSelectedIndex();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
    }

    public void setLocale(Locale locale) {
        m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle", locale == null ? Locale.getDefault() : locale);
    }

    public void addNotify() {
        super.addNotify();
        this.updateResources();
    }

    private void updateResources() {
        String string;
        if (this.m_findLabelMembersThat != null) {
            string = DimFindTool.getIntlString("lblFindMembersThat");
            this.m_findLabelMembersThat.setText(StringUtils.stripMnemonic((String)string));
            this.m_findLabelMembersThat.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this.m_findLabel != null) {
            string = DimFindTool.getIntlString("lblFind");
            this.m_findLabel.setText(StringUtils.stripMnemonic((String)string));
            this.m_findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this.m_caseCheck != null) {
            string = DimFindTool.getIntlString("txtMatchCase");
            this.m_caseCheck.setText(StringUtils.stripMnemonic((String)string));
            this.m_caseCheck.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this.m_findCombo != null) {
            string = new String(DimFindTool.getIntlString("findmemContain"));
            String string2 = new String(DimFindTool.getIntlString("findmemExactlyMatch"));
            String string3 = new String(DimFindTool.getIntlString("findmemStartWith"));
            String string4 = new String(DimFindTool.getIntlString("findmemEndWith"));
            m_strLabelTypes = new String[]{string, string2, string3, string4};
            this.m_findCombo.setModel(new DefaultComboBoxModel<String>(m_strLabelTypes));
        }
    }

    protected void notifyFindListeners(DimFindEvent dimFindEvent) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector vector;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                try {
                    vector = (Vector)this.m_listeners.clone();
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                DimFindEventListener dimFindEventListener = (DimFindEventListener)vector.elementAt(n2);
                dimFindEventListener.processDimFindEvent(dimFindEvent);
                ++n2;
            }
        }
    }

    private synchronized void updateHistory(String string) {
        if (string != null && string.length() > 0) {
            boolean bl = this.m_history.contains(string);
            if (bl) {
                this.m_findCombo1.removeItem(string);
                this.m_history.removeElement(string);
            }
            this.m_findCombo1.insertItemAt(string, 0);
            this.m_findCombo1.setSelectedIndex(0);
            this.m_history.insertElementAt(string, 0);
        }
    }

    private static String getIntlString(String string) {
        String string2;
        if (m_localStrings == null) {
            return string;
        }
        try {
            string2 = m_localStrings.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(String.valueOf(String.valueOf("Missing resource: ")) + string);
            missingResourceException.printStackTrace();
            String string3 = string;
            return string3;
        }
        return string2;
    }
}

