/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.dss.util.Collection;
import oracle.dss.util.UpdatableBag;

public class UpdatableBagImpl
implements UpdatableBag {
    protected Vector m_objects;
    protected int m_initialCapacity;
    protected int m_capacityIncrement;

    public UpdatableBagImpl() {
        this.m_initialCapacity = -1;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector();
    }

    public UpdatableBagImpl(int n) {
        this.m_initialCapacity = n;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector(this.m_initialCapacity);
    }

    public UpdatableBagImpl(int n, int n2) {
        this.m_initialCapacity = n;
        this.m_capacityIncrement = n2;
        this.m_objects = new Vector(this.m_initialCapacity, this.m_capacityIncrement);
    }

    public Collection duplicate() {
        Collection collection = null;
        try {
            collection = (Collection)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return collection;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        ((UpdatableBagImpl)object).m_objects = (Vector)this.m_objects.clone();
        return object;
    }

    public int size() {
        return this.m_objects.size();
    }

    public boolean isEmpty() {
        return this.m_objects.isEmpty();
    }

    public boolean includes(Object object) {
        return this.m_objects.contains(object);
    }

    public Enumeration elements() {
        return this.m_objects.elements();
    }

    public void clear() {
        this.m_objects.removeAllElements();
    }

    public void add(Object object) {
        this.m_objects.addElement(object);
    }

    public void addIfAbsent(Object object) {
        if (this.m_objects.contains(object)) {
            this.m_objects.addElement(object);
        }
    }

    public void removeOneOf(Object object) {
        this.m_objects.removeElement(object);
    }

    public void exclude(Object object) {
        while (this.m_objects.contains(object)) {
            this.m_objects.removeElement(object);
        }
    }

    public Object take() throws NoSuchElementException {
        Object e = this.m_objects.firstElement();
        this.m_objects.removeElementAt(0);
        return e;
    }

    public void addElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    public void removeElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeOneOf(enumeration.nextElement());
        }
    }

    public static void main(String[] stringArray) {
        UpdatableBagImpl updatableBagImpl = new UpdatableBagImpl();
        updatableBagImpl.add(new Object());
        updatableBagImpl.add(new Object());
        System.out.println(updatableBagImpl.size());
        Enumeration enumeration = updatableBagImpl.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

