/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class SeriesComponentInfo
extends ComponentInfo {
    private int _series;
    private int m_edge;

    public SeriesComponentInfo(int n) {
        this._series = n;
        this.m_edge = 1;
    }

    public SeriesComponentInfo(int n, int n2) {
        this._series = n;
        this.m_edge = n2;
    }

    public Object clone() {
        return new SeriesComponentInfo(this._series, this.m_edge);
    }

    public int getSeries() {
        return this._series;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SeriesComponentInfo)) {
            return false;
        }
        return this.getSeries() == ((SeriesComponentInfo)object).getSeries() && this.getEdge() == ((SeriesComponentInfo)object).getEdge();
    }

    public QDR getQDR(DataAccess dataAccess, int n) {
        try {
            QDR qDR = dataAccess.getSliceQDR(this.m_edge, this.getSeries(), n);
            return qDR;
        }
        catch (Exception exception) {
            QDR qDR = null;
            return qDR;
        }
    }

    public int hashCode() {
        return this._series ^ this._series >> 32;
    }

    public String toString() {
        return String.valueOf(String.valueOf("series=")) + this._series;
    }
}

