/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.QDR;

public class GroupComponentInfo
extends ComponentInfo {
    private int _group;
    private int m_edge;
    private int m_slice;
    private int m_layer;

    public GroupComponentInfo(int n) {
        this._group = n;
        this.m_edge = 0;
        this.m_slice = n;
    }

    public GroupComponentInfo(int n, int n2, int n3) {
        this._group = n;
        this.m_edge = n2;
        this.m_slice = n3;
    }

    public GroupComponentInfo(int n, int n2, int n3, int n4) {
        this._group = n;
        this.m_edge = n3;
        this.m_slice = n4;
        this.m_layer = n2;
    }

    public Object clone() {
        return new GroupComponentInfo(this._group, this.m_edge, this.m_slice);
    }

    public int getLayer() {
        return this.m_layer;
    }

    public int getGroup() {
        return this._group;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public int getSlice() {
        return this.m_slice;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GroupComponentInfo)) {
            return false;
        }
        return this.getGroup() == ((GroupComponentInfo)object).getGroup() && this.getEdge() == ((GroupComponentInfo)object).getEdge() && this.getSlice() == ((GroupComponentInfo)object).getSlice();
    }

    public QDR getQDR(DataAccess dataAccess, int n) {
        try {
            QDR qDR = dataAccess.getSliceQDR(this.m_edge, this.m_slice, n);
            return qDR;
        }
        catch (Exception exception) {
            QDR qDR = null;
            return qDR;
        }
    }

    public int hashCode() {
        return this._group ^ this._group >> 32;
    }

    public String toString() {
        return String.valueOf(String.valueOf("group=")) + this._group + ",layer=" + this.m_layer;
    }
}

