/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Date;
import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.ValueDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DateValueDiscriminator
extends ValueDiscriminator
implements DiscriminatorState {
    private java.sql.Date m_date = new java.sql.Date(0L);
    protected static final String S_NAME_DATE_VAL_DISC = "DD";
    protected static final String s_date = "d";
    protected static final String a_date = "date";
    public static final String NAME_DATE_VAL_DISC = "DateValDisc";
    private static final boolean PERSIST_DATE_IN_LONG = true;

    public DateValueDiscriminator() {
    }

    public DateValueDiscriminator(java.sql.Date date, int n) {
        super(n);
        this.m_date = date;
    }

    public Object clone() {
        return new DateValueDiscriminator(this.m_date, this.m_relOperator);
    }

    public void setDate(java.sql.Date date) {
        if (date == null) {
            return;
        }
        this.m_date = date;
    }

    public java.sql.Date getDate() {
        return this.m_date;
    }

    public boolean applies(RuleContext ruleContext) {
        java.sql.Date date = null;
        Object v = ruleContext.get("DATE_VALUE");
        if (v instanceof java.sql.Date) {
            date = (java.sql.Date)v;
        } else if (v instanceof Date) {
            Date date2 = (Date)v;
            date = new java.sql.Date(date2.getTime());
        } else {
            date = v instanceof String ? java.sql.Date.valueOf((String)v) : new java.sql.Date(0L);
        }
        if (date == null) {
            return false;
        }
        int n = date.compareTo(this.m_date);
        switch (this.m_relOperator) {
            default: {
                return n == 0;
            }
            case 1: {
                return n < 0;
            }
            case 2: {
                return n <= 0;
            }
            case 3: {
                return n > 0;
            }
            case 4: {
                return n >= 0;
            }
            case 5: 
        }
        return n != 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateValueDiscriminator)) {
            return false;
        }
        DateValueDiscriminator dateValueDiscriminator = (DateValueDiscriminator)object;
        return this.getDate() != null && this.getDate().equals(dateValueDiscriminator.getDate()) && this.getRelOperator() == dateValueDiscriminator.getRelOperator();
    }

    public boolean setXML(ObjectNode objectNode, ComponentTypeConverter componentTypeConverter, String string, int n) {
        PropertyNode propertyNode = objectNode.getProperty("relOp");
        if (propertyNode != null) {
            String string2 = propertyNode.getValueAsString();
            this.setRelOperator(this.convertRelOperatorToInt(string2));
        }
        if ((propertyNode = objectNode.getProperty(a_date)) != null) {
            this.setDate(new java.sql.Date(propertyNode.getValueAsLong()));
        }
        return true;
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter, boolean bl2) {
        ObjectNode objectNode = new ObjectNode(NAME_DATE_VAL_DISC);
        objectNode.addProperty("relOp", this.convertRelOperatorToString(this.getRelOperator()));
        if (this.getDate() != null) {
            objectNode.addProperty(a_date, this.getDate().getTime());
        }
        return objectNode;
    }

    public void setStateAsObjectNode(List list, ObjectNode objectNode, DiscriminatorState discriminatorState) {
        DateValueDiscriminator dateValueDiscriminator;
        PropertyNode propertyNode = objectNode.getProperty("r");
        DateValueDiscriminator dateValueDiscriminator2 = dateValueDiscriminator = discriminatorState instanceof DateValueDiscriminator ? (DateValueDiscriminator)discriminatorState : null;
        if (propertyNode != null) {
            this.setRelOperator(propertyNode.getValueAsInteger());
        } else if (dateValueDiscriminator != null) {
            this.setRelOperator(dateValueDiscriminator.getRelOperator());
        } else {
            this.setRelOperator(0);
        }
        propertyNode = objectNode.getProperty(s_date);
        if (propertyNode != null) {
            this.setDate(new java.sql.Date(propertyNode.getValueAsLong()));
        } else if (dateValueDiscriminator != null) {
            this.setDate(dateValueDiscriminator.getDate());
        } else {
            this.setDate(new java.sql.Date(0L));
        }
    }

    public ObjectNode getStateAsObjectNode(List list, DiscriminatorState discriminatorState) {
        DateValueDiscriminator dateValueDiscriminator;
        ObjectNode objectNode = new ObjectNode(S_NAME_DATE_VAL_DISC);
        boolean bl = false;
        DateValueDiscriminator dateValueDiscriminator2 = dateValueDiscriminator = discriminatorState instanceof DateValueDiscriminator ? (DateValueDiscriminator)discriminatorState : new DateValueDiscriminator();
        if (dateValueDiscriminator.getRelOperator() != this.getRelOperator()) {
            objectNode.addProperty("r", this.getRelOperator());
            bl = true;
        }
        if (dateValueDiscriminator.getDate() != this.getDate()) {
            objectNode.addProperty(s_date, this.getDate().getTime());
            bl = true;
        }
        return bl ? objectNode : null;
    }
}

