/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundleEvent;
import oracle.dss.rules.RuleBundleListener;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.RuleException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class RuleBundle
implements Serializable,
Cloneable {
    private Vector m_rules = new Vector();
    private Vector m_listeners = new Vector();
    private boolean stopAtFirstMatch;
    protected Hashtable m_context;
    public static final String NAME_BUNDLE = "Bundle";
    private static final String a_type = "type";
    private static final String a_id = "id";
    private String id = "";
    private String d_id = "";

    public Object clone() {
        RuleBundle ruleBundle = new RuleBundle();
        Enumeration enumeration = this.m_rules.elements();
        while (enumeration.hasMoreElements()) {
            ruleBundle.m_rules.addElement((Rule)((Rule)enumeration.nextElement()).clone());
        }
        ruleBundle.m_listeners = (Vector)this.m_listeners.clone();
        return ruleBundle;
    }

    public Rule getRule(int n) {
        return (Rule)this.m_rules.elementAt(n);
    }

    public void addRule(Rule rule) {
        this.m_rules.addElement((Rule)rule.clone());
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void addRule(Rule rule, int n) {
        this.m_rules.insertElementAt((Rule)rule.clone(), n);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void addRuleBundleListener(RuleBundleListener ruleBundleListener) {
        this.m_listeners.addElement(ruleBundleListener);
    }

    public boolean runRules(RuleContext ruleContext, Mergeable mergeable) throws RuleException {
        Enumeration enumeration = this.m_rules.elements();
        Rule rule = null;
        boolean bl = false;
        boolean bl2 = false;
        while (!(!enumeration.hasMoreElements() || this.stopAtFirstMatch && bl2)) {
            rule = (Rule)enumeration.nextElement();
            bl = rule.runRule(ruleContext, mergeable);
            boolean bl3 = bl2 = bl2 || bl;
        }
        return bl2;
    }

    public int getCount() {
        return this.m_rules.size();
    }

    public void removeRuleBundleListener(RuleBundleListener ruleBundleListener) {
        this.m_listeners.removeElement(ruleBundleListener);
    }

    public void fireEvent(RuleBundleEvent ruleBundleEvent) {
        Vector vector = (Vector)this.m_listeners.clone();
        RuleBundleListener ruleBundleListener = null;
        int n = 0;
        while (n < vector.size()) {
            ruleBundleListener = (RuleBundleListener)vector.elementAt(n);
            ruleBundleListener.ruleBundleModified(ruleBundleEvent);
            ++n;
        }
    }

    public void removeRule(Rule rule) {
        this.m_rules.removeElement(rule);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void removeRule(int n) {
        this.m_rules.removeElementAt(n);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void removeRulesThatApply(RuleContext ruleContext, Mergeable mergeable) throws RuleException {
        Rule rule = null;
        boolean bl = false;
        int n = 0;
        while (n < this.getCount()) {
            rule = this.getRule(n);
            if (rule.applies(ruleContext, mergeable)) {
                bl = true;
                this.m_rules.removeElement(rule);
                continue;
            }
            ++n;
        }
        if (bl) {
            this.fireEvent(new RuleBundleEvent(this, 0));
        }
    }

    public void replaceRule(Rule rule, int n) {
        this.m_rules.removeElementAt(n);
        this.m_rules.insertElementAt((Rule)rule.clone(), n);
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public void setStopAtFirstMatch(boolean bl) {
        this.stopAtFirstMatch = bl;
        this.fireEvent(new RuleBundleEvent(this, 0));
    }

    public boolean isStopAtFirstMatch() {
        return this.stopAtFirstMatch;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    public void setContext(Hashtable hashtable) {
        this.m_context = hashtable;
    }

    public void setXML(ContainerNode containerNode, ComponentTypeConverter componentTypeConverter, String string, int n) {
        PropertyNode propertyNode = containerNode.getProperty(a_id);
        if (propertyNode != null) {
            this.setID(propertyNode.getValueAsString());
        }
        Enumeration enumeration = containerNode.getContainedObject();
        while (enumeration.hasMoreElements()) {
            Object object;
            ObjectNode objectNode = (ObjectNode)enumeration.nextElement();
            if (objectNode == null) continue;
            if (objectNode.getName().equals("DiscRule")) {
                object = new DiscriminatorRule();
                if (this.m_context != null) {
                    ((DiscriminatorRule)object).setContext(this.m_context);
                }
                ((DiscriminatorRule)object).setXML(objectNode, componentTypeConverter, string, n);
                this.addRule((Rule)object);
                continue;
            }
            PropertyNode propertyNode2 = objectNode.getProperty(a_type);
            if (propertyNode2 == null) {
                return;
            }
            object = propertyNode2.getValueAsString();
            try {
                Class<?> clazz = Class.forName((String)object);
                Rule rule = (Rule)clazz.newInstance();
                rule.setXML(objectNode, string, n);
                this.addRule(rule);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter) {
        return this.getXML(bl, componentTypeConverter, NAME_BUNDLE);
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter, String string) {
        ObjectNode objectNode = new ObjectNode(string);
        boolean bl2 = false;
        if (this.m_rules != null) {
            int n = 0;
            while (n < this.m_rules.size()) {
                if (this.m_rules.elementAt(n) instanceof Rule) {
                    ObjectNode objectNode2;
                    if ((Rule)this.m_rules.elementAt(n) instanceof DiscriminatorRule && this.m_context != null) {
                        ((DiscriminatorRule)this.m_rules.elementAt(n)).setContext(this.m_context);
                    }
                    if ((objectNode2 = ((Rule)this.m_rules.elementAt(n)).getXML(bl, componentTypeConverter)) != null) {
                        objectNode.addProperty(objectNode2);
                        bl2 = true;
                    }
                }
                ++n;
            }
        }
        if (bl || !this.d_id.equals(this.id)) {
            objectNode.addProperty(a_id, this.id);
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }
}

