/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.utilities;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class TDGTimer
implements Runnable,
Serializable {
    protected boolean repeat;
    protected boolean execute;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener;
    protected transient Thread thread;

    public TDGTimer() {
        this(1000, false);
    }

    public TDGTimer(int n) {
        this(n, false);
    }

    public TDGTimer(boolean bl) {
        this(1000, bl);
    }

    public TDGTimer(int n, boolean bl) {
        this.delay = n;
        this.repeat = bl;
        this.execute = false;
        this.thread = null;
    }

    public void setDelay(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = new Integer(this.delay);
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        Boolean bl3 = new Boolean(this.repeat);
        this.repeat = bl;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean getRepeat() {
        return this.isRepeat();
    }

    public synchronized void start() {
        this.execute = true;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.resume();
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void start(int n) {
        this.setDelay(n);
        this.start();
    }

    public synchronized void start(boolean bl) {
        this.setRepeat(bl);
        this.start();
    }

    public synchronized void start(int n, boolean bl) {
        this.setDelay(n);
        this.setRepeat(bl);
        this.start();
    }

    public synchronized void stop() {
        this.execute = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void run() {
        do {
            try {
                Thread.sleep(this.delay);
                if (!this.execute) continue;
                this.sourceActionEvent();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        } while (this.repeat);
    }

    public void finalize() {
        try {
            if (this.thread != null) {
                this.thread.destroy();
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.thread = null;
        this.actionListener = null;
    }

    public void setActionCommand(String string) {
        String string2 = this.actionCommand;
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.execute = false;
        this.thread = new Thread(this);
    }
}

