/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class SimpleBlackBoxObj
implements BlackBoxIF,
Serializable {
    private Perspective m_Perspective;
    private IdentObj m_id;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    private Color m_borderColor;
    private Color m_fillColor;

    public SimpleBlackBoxObj(Perspective perspective, IdentObj identObj, boolean bl) {
        this.m_Perspective = perspective;
        this.m_id = identObj;
        this.m_bTransparentBorderColor = !bl || this.m_Perspective.getTransparentBorderColor(identObj);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(identObj);
        this.m_borderColor = this.m_bTransparentBorderColor ? null : this.m_Perspective.getBorderColor(identObj);
        this.m_fillColor = this.m_bTransparentFillColor ? null : this.m_Perspective.getFillColor(identObj);
    }

    public void copy(SimpleBlackBoxObj simpleBlackBoxObj) {
        this.m_Perspective = simpleBlackBoxObj.m_Perspective;
        this.m_id = simpleBlackBoxObj.m_id;
        this.m_bTransparentBorderColor = simpleBlackBoxObj.m_bTransparentBorderColor;
        this.m_bTransparentFillColor = simpleBlackBoxObj.m_bTransparentFillColor;
        this.m_borderColor = simpleBlackBoxObj.m_borderColor;
        this.m_fillColor = simpleBlackBoxObj.m_fillColor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleBlackBoxObj)) {
            return false;
        }
        SimpleBlackBoxObj simpleBlackBoxObj = (SimpleBlackBoxObj)object;
        boolean bl = this.m_bTransparentBorderColor == simpleBlackBoxObj.m_bTransparentBorderColor && this.m_bTransparentFillColor == simpleBlackBoxObj.m_bTransparentFillColor && this.m_borderColor.equals(simpleBlackBoxObj.m_borderColor) && this.m_fillColor.equals(simpleBlackBoxObj.m_fillColor);
        this.m_borderColor.equals(simpleBlackBoxObj.m_borderColor);
        return bl;
    }

    public Color getBorderColor() {
        return this.m_borderColor;
    }

    public Color getFillColor() {
        return this.m_fillColor;
    }

    public int getFillType() {
        return 1;
    }

    public void setFillType(int n) {
    }

    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    public void setTransparentFillColor(boolean bl) {
        this.m_bTransparentFillColor = bl;
    }

    public void setTransparentBorderColor(boolean bl) {
        this.m_bTransparentBorderColor = bl;
    }

    public void paint(Graphics graphics, Point point, Point point2) {
        if (!this.m_bTransparentBorderColor) {
            graphics.setColor(this.m_borderColor);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle, int n) {
    }

    public void paint(Graphics graphics, Point point, Point point2, int n) {
        if (!this.m_bTransparentBorderColor || !this.m_bTransparentFillColor) {
            double d = point2.x - point.x;
            double d2 = point2.y - point.y;
            double d3 = 1.57;
            double d4 = Math.atan2(d2, d);
            double d5 = 4.71;
            double d6 = (double)n * Math.cos(d4 + d3);
            double d7 = (double)n * Math.sin(d4 + d3);
            double d8 = (double)(n / 2) * Math.sin(d4 + d5);
            double d9 = (double)(n / 2) * Math.cos(d4 + d5);
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x + (int)Math.round(d9), point2.y + (int)Math.round(d8));
            polygon.addPoint(point2.x + (int)Math.round(d6) + (int)Math.round(d9), point2.y + (int)Math.round(d7) + (int)Math.round(d8));
            polygon.addPoint(point.x + (int)Math.round(d6) + (int)Math.round(d9), point.y + (int)Math.round(d7) + (int)Math.round(d8));
            polygon.addPoint(point.x + (int)Math.round(d9), point.y + (int)Math.round(d8));
            polygon.addPoint(point2.x + (int)Math.round(d9), point2.y + (int)Math.round(d8));
            graphics.setColor(this.m_borderColor);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setColor(this.m_fillColor);
            graphics.fillPolygon(polygon);
            graphics.fillOval(point2.x - n / 2, point2.y - n / 2, n, n);
        }
    }

    public void paint(Graphics graphics, Point point, Point point2, int n, int n2, boolean bl) {
        if (graphics instanceof Graphics2D) {
            Stroke stroke = ((Graphics2D)graphics).getStroke();
            BasicStroke basicStroke = new BasicStroke(n, 0, 0);
            float f = 10.0f;
            if (n2 != Perspective.SOLID) {
                if (n2 == Perspective.DASH) {
                    float[] fArray;
                    if (bl) {
                        fArray = new float[]{4.0f, 2.0f, 4.0f};
                        f = 2.0f;
                        n = 2;
                    } else {
                        fArray = new float[]{f, f / (float)2};
                    }
                    basicStroke = new BasicStroke(n, 0, 0, f, fArray, 0.0f);
                } else if (n2 == Perspective.DOTTED) {
                    if (bl) {
                        n = 2;
                    }
                    float[] fArray = new float[]{n};
                    basicStroke = new BasicStroke(n, 0, 0, 1.0f, fArray, 0.0f);
                } else if (n2 == Perspective.DASH_DOT) {
                    float[] fArray;
                    if (bl) {
                        fArray = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        n = 2;
                    } else {
                        fArray = new float[]{f, f / (float)2, n, f / (float)2};
                    }
                    basicStroke = new BasicStroke(n, 0, 0, 1.0f, fArray, 0.0f);
                }
            }
            ((Graphics2D)graphics).setStroke(basicStroke);
            graphics.setColor(this.getFillColor());
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            ((Graphics2D)graphics).setStroke(stroke);
        } else {
            this.paint(graphics, point, point2, n);
        }
    }

    public void paint(Graphics graphics, Polygon polygon) {
        VC vC = this.m_Perspective.getVC();
        if (!this.m_bTransparentFillColor) {
            graphics.setColor(this.m_fillColor);
            graphics.fillPolygon(polygon);
        }
        if (!this.m_bTransparentBorderColor) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.setColor(this.m_borderColor);
            graphics2D.drawPolygon(polygon);
        }
    }

    public void paint(Graphics graphics, Area area) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.m_bTransparentFillColor) {
            graphics2D.setColor(this.m_fillColor);
            graphics2D.fill(area);
        }
        if (!this.m_bTransparentBorderColor) {
            graphics2D.setColor(this.m_borderColor);
            graphics2D.draw(area);
        }
    }

    public void paint(Graphics graphics, Arc2D arc2D) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.m_bTransparentFillColor) {
            graphics2D.setColor(this.m_fillColor);
            graphics2D.fill(arc2D);
        }
        if (!this.m_bTransparentBorderColor) {
            graphics2D.setColor(this.m_borderColor);
            graphics2D.draw(arc2D);
        }
    }

    public void paint(Graphics graphics, GeneralPath generalPath) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.m_bTransparentFillColor) {
            graphics2D.setColor(this.m_fillColor);
            graphics2D.fill(generalPath);
        }
        if (!this.m_bTransparentBorderColor) {
            graphics2D.setColor(this.m_borderColor);
            graphics2D.draw(generalPath);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (!this.m_bTransparentFillColor) {
            graphics.setColor(this.m_fillColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (!this.m_bTransparentBorderColor) {
            graphics.setColor(this.m_borderColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        this.paint(graphics, rectangle, bl, bl2);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        if (bl) {
            if (!this.m_bTransparentFillColor && !bl2) {
                graphics.setColor(this.m_fillColor);
                graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!this.m_bTransparentBorderColor) {
                graphics.setColor(this.m_borderColor);
                graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            if (!this.m_bTransparentFillColor && !bl2) {
                graphics.setColor(this.m_fillColor);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!this.m_bTransparentBorderColor) {
                graphics.setColor(this.m_borderColor);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void paint(Graphics graphics, String string, Rectangle rectangle, Rectangle rectangle2, TextStyleObj textStyleObj, VC vC) {
        if (!this.m_bTransparentFillColor) {
            graphics.setColor(this.m_fillColor);
            textStyleObj.draw(graphics, null, string, rectangle2, null, null, vC);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setBorderColor(Color color) {
        this.m_borderColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setFillColor(int n, int n2, int n3, int n4) {
        this.m_fillColor = new Color(n, n2, n3, n4);
    }

    public void setFillColor(Color color) {
        this.m_fillColor = color;
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, int n) {
    }
}

