/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import oracle.dss.graph.pfj.draw.OctreeQuantizer;

class OctreeNode {
    private static final int _TRANSPARENCY_MASK = -16777216;
    private static final int _RGB_MASK = 0xFFFFFF;
    private static final int _BYTE_MASK = 255;
    private OctreeQuantizer _tree;
    private int _children;
    private OctreeNode[] _leaf;
    private int _pixels;
    private OctreeNode _parent;
    private int _level;
    private OctreeNode _next;
    private int _maxLevel;
    private long _totalRed;
    private long _totalGreen;
    private long _totalBlue;
    private int _color;
    private boolean _colorSet;

    public OctreeNode(OctreeQuantizer octreeQuantizer) {
        this._tree = octreeQuantizer;
        this._leaf = new OctreeNode[8];
        this._level = 0;
        this._maxLevel = 8;
        this._children = 0;
        this._colorSet = false;
    }

    public void addColor(int n) {
        int n2 = this._setColorVals(n, true);
        if (this._getLevel() < this._maxLevel && this._getLevel() < this._tree._getMaxDepth()) {
            if (this._leaf[n2] == null) {
                OctreeNode octreeNode;
                this._leaf[n2] = octreeNode = new OctreeNode(this);
                if (octreeNode._getLevel() == this._tree._getMaxDepth()) {
                    this._tree._incColors();
                }
                if (this._tree._getListHead(this._getLevel()) == null) {
                    this._tree._setListHead(this._getLevel(), octreeNode);
                } else {
                    this._tree._setListEnd(this._getLevel(), octreeNode);
                }
            }
            this._leaf[n2].addColor(n);
        } else if (!this._colorSet) {
            this._computeColor();
        }
    }

    public int mapColor(int n) {
        if (this._colorSet) {
            return n & 0xFF000000 | this._color & 0xFFFFFF;
        }
        int n2 = this._setColorVals(n, false);
        if (this._leaf[n2] == null) {
            return n;
        }
        return this._leaf[n2].mapColor(n);
    }

    int _getChildren() {
        return this._children;
    }

    int _getLevel() {
        return this._level;
    }

    OctreeNode _getNext() {
        return this._next;
    }

    void _setChildren(int n) {
        if (n <= 8) {
            this._children = n;
        }
    }

    void _computeColor() {
        this._color = (int)((this._totalRed / (long)this._pixels << 16) + (this._totalGreen / (long)this._pixels << 8) + this._totalBlue / (long)this._pixels);
        this._colorSet = true;
    }

    void _setMaxLevel(int n) {
        if (n < this._maxLevel) {
            this._maxLevel = n;
        }
    }

    void _setNext(OctreeNode octreeNode) {
        this._next = octreeNode;
    }

    private OctreeNode(OctreeNode octreeNode) {
        this(octreeNode._getTree());
        this._parent = octreeNode;
        this._level = octreeNode._getLevel() + 1;
        octreeNode._incChildren();
    }

    private OctreeQuantizer _getTree() {
        return this._tree;
    }

    private void _incChildren() {
        ++this._children;
    }

    private int _setColorVals(int n, boolean bl) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = 0;
        if (bl) {
            this._totalBlue += (long)n4;
            this._totalGreen += (long)n3;
            this._totalRed += (long)n2;
            ++this._pixels;
        }
        n3 <<= this._getLevel();
        n4 <<= this._getLevel();
        if ((byte)(n2 <<= this._getLevel()) < 0) {
            n5 += 4;
        }
        if ((byte)n3 < 0) {
            n5 += 2;
        }
        if ((byte)n4 < 0) {
            ++n5;
        }
        return n5;
    }
}

