/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import oracle.dss.graph.pfj.draw.OctreeFilter;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags;
    private boolean started;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props;
    private boolean bAccumulate;
    private int[] accumulator;

    public ImageEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        this.producer = imageProducer;
        this.out = outputStream;
    }

    public ImageEncoder(Image image, OutputStream outputStream) throws IOException {
        this(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new OctreeFilter(image))).getSource(), outputStream);
    }

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    abstract void encodeDone() throws IOException;

    private void encodeFinish() throws IOException {
        if (this.bAccumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.bAccumulate = false;
        }
    }

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.bAccumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.bAccumulate) {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(nArray, n7 * n6 + n5, this.accumulator, (n2 + n7) * this.width + n, n3);
                ++n7;
            }
        } else {
            this.encodePixels(n, n2, n3, n4, nArray, n5, n6);
        }
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    public void imageComplete(int n) {
        this.producer.removeConsumer(this);
        if (n == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setHints(int n) {
        this.hintflags = n;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray[n9] = colorModel.getRGB(byArray[n8 + n9] & 0xFF);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
        int[] nArray2 = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray2[n9] = colorModel.getRGB(nArray[n8 + n9]);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray2, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }
}

