/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.io.Serializable;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.ObjClassID;

public class IdentObj
implements Serializable {
    public static final int OBJECT_NA = -3;
    public static final int SERIES_OTHER = -1;
    public static final int SERIES_NEG_OTHER = -2;
    public static final int SERIES_NA = -3;
    public static final int GROUP_NA = -3;
    public static final int STACK_NA = -3;
    public static final int MISC_NA = -3;
    public static final IdentObj GLOBAL = new IdentObj(-3);
    int m_objectID;
    int m_seriesID;
    int m_groupID;
    int m_stackID;
    int m_miscID;

    public IdentObj(int n) {
        this(n, -3, -3, -3, -3);
    }

    public IdentObj(int n, boolean bl) {
        this(n, -3, -3, -3, -3);
    }

    public IdentObj(int n, int n2) {
        this(n, n2, -3, -3, -3);
    }

    public IdentObj(int n, int n2, int n3) {
        this(n, n2, n3, -3, -3);
    }

    public IdentObj(int n, int n2, int n3, int n4, int n5) {
        this.m_objectID = n;
        this.m_seriesID = n2;
        this.m_groupID = n3;
        this.m_stackID = n4;
        this.m_miscID = n5;
    }

    public IdentObj(IdentObj identObj) {
        this.copy(identObj);
    }

    public void copy(IdentObj identObj) {
        this.m_objectID = identObj.m_objectID;
        this.m_seriesID = identObj.m_seriesID;
        this.m_groupID = identObj.m_groupID;
        this.m_stackID = identObj.m_stackID;
        this.m_miscID = identObj.m_miscID;
    }

    public int hashCode() {
        return this.m_objectID + this.m_seriesID + this.m_groupID + this.m_stackID + this.m_miscID;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IdentObj)) {
            return false;
        }
        IdentObj identObj = (IdentObj)object;
        if (this.m_objectID != identObj.m_objectID) {
            return false;
        }
        if (this.m_seriesID != identObj.m_seriesID) {
            return false;
        }
        if (this.m_groupID != identObj.m_groupID) {
            return false;
        }
        if (this.m_stackID != identObj.m_stackID) {
            return false;
        }
        return this.m_miscID == identObj.m_miscID;
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public int getMiscID() {
        return this.m_miscID;
    }

    public int getObjectID() {
        return this.m_objectID;
    }

    public int getSeriesID() {
        return this.m_seriesID;
    }

    public int getStackID() {
        return this.m_stackID;
    }

    public void incrMiscID(int n) {
        this.m_miscID += n;
    }

    public boolean isGROUP_NA() {
        return this.m_groupID == -3;
    }

    public boolean isExceptional() {
        return ObjClassID.isExceptional(this.m_objectID);
    }

    public boolean isMISC_NA() {
        return this.m_miscID == -3;
    }

    public boolean isSTACK_NA() {
        return this.m_stackID == -3;
    }

    public boolean isOBJECT_NA() {
        return this.m_objectID == -3;
    }

    public boolean isPartOf3DCube() {
        boolean bl;
        switch (this.m_objectID) {
            case 514: 
            case 515: 
            case 516: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isLegend() {
        boolean bl;
        switch (this.m_objectID) {
            case 12: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isScrollerThumb() {
        boolean bl;
        switch (this.m_objectID) {
            case 20: 
            case 26: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isLegendScrollerThumb() {
        boolean bl;
        switch (this.m_objectID) {
            case 66: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isParetoRelated() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 477: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 498: 
            case 499: 
            case 500: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isReferenceLineRelated() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 358: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isSERIES_NA() {
        return this.m_seriesID == -3;
    }

    public boolean isColorByHeightRelated() {
        boolean bl;
        switch (this.m_objectID) {
            case 18: 
            case 330: 
            case 517: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isGroupRelated() {
        boolean bl;
        switch (this.m_objectID) {
            case 331: 
            case 334: 
            case 335: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean canBeExceptional() {
        boolean bl;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 256: 
            case 258: 
            case 259: 
            case 277: 
            case 298: 
            case 299: 
            case 303: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 331: 
            case 334: 
            case 335: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 513: 
            case 517: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isSeriesRelated() {
        boolean bl;
        switch (this.m_objectID) {
            case -3: 
            case 13: 
            case 256: 
            case 258: 
            case 259: 
            case 277: 
            case 298: 
            case 299: 
            case 303: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 332: 
            case 354: 
            case 473: 
            case 474: 
            case 475: 
            case 476: 
            case 513: 
            case 517: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isText() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 42: 
            case 232: 
            case 233: 
            case 235: 
            case 248: 
            case 260: 
            case 266: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 512: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isLine() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 17: 
            case 40: 
            case 41: 
            case 258: 
            case 262: 
            case 267: 
            case 268: 
            case 269: 
            case 271: 
            case 272: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 301: 
            case 304: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 321: 
            case 322: 
            case 327: 
            case 328: 
            case 358: 
            case 439: 
            case 473: 
            case 521: 
            case 522: 
            case 523: 
            case 524: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isRiser() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 256: 
            case 277: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 319: 
            case 320: 
            case 354: 
            case 517: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isDataLabel() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 512: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isGridLine() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 271: 
            case 272: 
            case 275: 
            case 276: 
            case 281: 
            case 282: 
            case 285: 
            case 286: 
            case 289: 
            case 290: 
            case 518: 
            case 519: 
            case 520: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean matches(IdentObj identObj) {
        boolean bl = true;
        if (this.m_objectID != identObj.m_objectID && this.m_objectID != -3 && identObj.m_objectID != -3) {
            bl = false;
        }
        if (this.m_seriesID != identObj.m_seriesID && this.m_seriesID != -3 && identObj.m_seriesID != -3) {
            bl = false;
        }
        if (this.m_groupID != identObj.m_groupID && this.m_groupID != -3 && identObj.m_groupID != -3) {
            bl = false;
        }
        if (this.m_stackID != identObj.m_stackID && this.m_stackID != -3 && identObj.m_stackID != -3) {
            bl = false;
        }
        if (this.m_miscID != identObj.m_miscID && this.m_miscID != -3 && identObj.m_miscID != -3) {
            bl = false;
        }
        return bl;
    }

    public boolean matches(IdentObj identObj, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6 = true;
        if (bl && this.m_objectID != identObj.m_objectID) {
            bl6 = false;
        }
        if (bl2 && this.m_seriesID != identObj.m_seriesID) {
            bl6 = false;
        }
        if (bl3 && this.m_groupID != identObj.m_groupID) {
            bl6 = false;
        }
        if (bl4 && this.m_stackID != identObj.m_stackID) {
            bl6 = false;
        }
        if (bl5 && this.m_miscID != identObj.m_miscID) {
            bl6 = false;
        }
        return bl6;
    }

    public boolean needsStripping() {
        boolean bl = false;
        switch (this.m_objectID) {
            case 14: 
            case 248: 
            case 294: 
            case 297: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 319: 
            case 320: {
                bl = true;
            }
        }
        return bl;
    }

    public void setGroupID(int n) {
        this.m_groupID = n;
    }

    public void setMiscID(int n) {
        this.m_miscID = n;
    }

    public void setObjectID(int n) {
        this.m_objectID = n;
    }

    public void setSeriesID(int n) {
        this.m_seriesID = n;
    }

    public void setStackID(int n) {
        this.m_stackID = n;
    }

    public IdentObj stripExceptional() {
        IdentObj identObj = new IdentObj(this);
        identObj.setObjectID(ObjClassID.stripExceptionalOffset(this.m_objectID));
        return identObj;
    }

    public String toString() {
        return String.valueOf(String.valueOf("+1.0+")) + this.m_objectID + "+" + this.m_seriesID + "+" + this.m_groupID + "+" + this.m_stackID + "+" + this.m_miscID + "+";
    }

    public String getIdentObjMethod() {
        String string = "";
        boolean bl = false;
        Integer n = new Integer(this.m_seriesID);
        Integer n2 = new Integer(this.m_groupID);
        Integer n3 = new Integer(this.m_stackID);
        Integer n4 = new Integer(this.m_miscID);
        if (this.isOBJECT_NA() && this.isSTACK_NA()) {
            string = !this.isSERIES_NA() && this.isGROUP_NA() ? String.valueOf(String.valueOf("getSeries(")) + n.toString() : (this.isSERIES_NA() && !this.isGROUP_NA() ? String.valueOf(String.valueOf("getGroup(")) + n2.toString() : String.valueOf(String.valueOf("getSeriesGroup(")) + n.toString() + "," + n2.toString());
        } else {
            if (!this.isOBJECT_NA()) {
                string = String.valueOf(ObjClassID.getObjMethodName(this.m_objectID)) + "(";
            }
            if (!(this.isSERIES_NA() && this.isGROUP_NA() && this.isSTACK_NA())) {
                if (bl) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + n.toString();
                if (!this.isGROUP_NA() || !this.isSTACK_NA()) {
                    string = String.valueOf(string) + "," + n2.toString();
                    if (this.m_stackID != -3) {
                        string = String.valueOf(string) + "," + n3.toString();
                    }
                }
            }
        }
        string = String.valueOf(string) + ")";
        if (this.m_objectID == 2000) {
            string = "GLOBAL_SCALAR_PROPERTY";
        }
        return string;
    }

    public boolean useFillColor() {
        boolean bl = true;
        switch (this.m_objectID) {
            case 41: 
            case 257: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 275: 
            case 276: 
            case 278: 
            case 279: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 304: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 321: 
            case 322: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean useBorderColor() {
        boolean bl = true;
        switch (this.m_objectID) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 232: 
            case 233: 
            case 248: 
            case 258: 
            case 260: 
            case 266: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 297: 
            case 473: 
            case 512: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean useLineWidth() {
        return this.isLine();
    }

    public boolean isDeadZoneObj(JGraphType jGraphType) {
        boolean bl;
        switch (this.m_objectID) {
            case 256: 
            case 258: 
            case 314: 
            case 318: 
            case 473: 
            case 475: {
                bl = true;
                break;
            }
            case 517: {
                if (jGraphType.is3DRiser() || jGraphType.isRiserUnspecified()) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

