/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillSfxObj;

public class FillTextureObj
extends FillSfxObj {
    public static final int DISPLAY_TILE = 0;
    public static final int DISPLAY_STRETCH = 1;
    public static final int FLIP_NORMAL = 0;
    public static final int FLIP_VERTICAL = 1;
    public static final int FLIP_HORIZONTAL = 2;
    public static final int FLIP_BOTH = 3;
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private int m_nTilingMode;
    private int m_nFlippingMode;
    private int m_nRotation;
    private Perspective m_Perspective;
    private transient Image m_Texture;

    public FillTextureObj() {
        this.m_nTilingMode = 0;
        this.m_nFlippingMode = 0;
        this.m_nRotation = 0;
        this.m_Texture = null;
    }

    public FillTextureObj(Perspective perspective, Image image, int n, int n2, int n3) {
        this.m_nTilingMode = n;
        this.m_nFlippingMode = n2;
        this.m_nRotation = n3;
        this.m_Texture = image;
        this.m_Perspective = perspective;
    }

    public void copy(FillObj fillObj) {
        this.m_nTilingMode = ((FillTextureObj)fillObj).m_nTilingMode;
        this.m_nFlippingMode = ((FillTextureObj)fillObj).m_nFlippingMode;
        this.m_nRotation = ((FillTextureObj)fillObj).m_nRotation;
        this.m_Texture = ((FillTextureObj)fillObj).m_Texture;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof FillTextureObj) {
            FillTextureObj fillTextureObj = (FillTextureObj)object;
            boolean bl2 = bl = this.m_nTilingMode == fillTextureObj.m_nTilingMode && this.m_nFlippingMode == fillTextureObj.m_nFlippingMode && this.m_nRotation == fillTextureObj.m_nRotation;
            if (bl) {
                if (this.m_Texture == null != (fillTextureObj.m_Texture == null)) {
                    bl = false;
                }
                if (this.m_Texture != null && fillTextureObj.m_Texture != null && !this.m_Texture.equals(fillTextureObj.m_Texture)) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean is2DTech(Graphics graphics) {
        boolean bl = false;
        if (graphics instanceof PrinterGraphics) {
            if (this.m_Perspective.isSFXPrintingSmooth()) {
                bl = true;
            }
        } else if (graphics instanceof Graphics2D) {
            bl = true;
        }
        return bl;
    }

    public void fillPolygon(Graphics graphics, Component component, Area area) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, area, false);
        } else {
            super.fillPolygon(graphics, component, area);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, Arc2D arc2D) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, arc2D, false);
        } else {
            super.fillPolygon(graphics, component, arc2D);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, Polygon polygon) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, polygon, false);
        } else {
            super.fillPolygon(graphics, component, polygon);
        }
    }

    public void fillPolygon(Graphics graphics, Component component, GeneralPath generalPath) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, generalPath, false);
        } else {
            super.fillPolygon(graphics, component, generalPath);
        }
    }

    public void fillRect(Graphics graphics, Component component, Rectangle rectangle) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, rectangle, false);
        } else {
            super.fillRect(graphics, component, rectangle);
        }
    }

    public void fillOval(Graphics graphics, Component component, Rectangle rectangle) {
        if (this.is2DTech(graphics)) {
            this.fill((Graphics2D)graphics, component, rectangle, true);
        } else {
            super.fillOval(graphics, component, rectangle);
        }
    }

    public void fill(Graphics2D graphics2D, Component component, Shape shape, boolean bl) {
        if (!this.waitForImage(component, this.m_Texture)) {
            return;
        }
        int n = this.m_Texture.getHeight(null);
        int n2 = this.m_Texture.getWidth(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.drawImage(this.m_Texture, 0, 0, null);
        graphics2D2.dispose();
        Rectangle rectangle = shape instanceof Arc2D ? shape.getBounds2D().getBounds() : shape.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        TexturePaint texturePaint = this.m_nTilingMode == 1 ? new TexturePaint(bufferedImage, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) : new TexturePaint(bufferedImage, new Rectangle(0, 0, n2, n2));
        graphics2D.setPaint(texturePaint);
        if (bl) {
            Rectangle rectangle2 = (Rectangle)shape;
            graphics2D.fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            graphics2D.fill(shape);
        }
    }

    protected void fillSfxRect(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (!this.waitForImage(component, this.m_Texture)) {
            return;
        }
        int n5 = this.m_Texture.getHeight(null);
        int n6 = this.m_Texture.getWidth(null);
        if (this.m_nTilingMode == 0) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                block1: while (n8 < n4) {
                    int n9 = 0;
                    while (n9 < 10000) {
                        if (this.m_nFlippingMode == 0) {
                            bl = graphics.drawImage(this.m_Texture, n7, n8, n6, n5, null);
                        } else if (this.m_nFlippingMode == 1) {
                            bl = graphics.drawImage(this.m_Texture, n7, n8, n7 + n6, n8 + n5, 0, n5, n6, 0, null);
                        } else if (this.m_nFlippingMode == 2) {
                            bl = graphics.drawImage(this.m_Texture, n7, n8, n7 + n6, n8 + n5, n5, 0, 0, n6, null);
                        } else if (this.m_nFlippingMode == 3) {
                            bl = graphics.drawImage(this.m_Texture, n7, n8, n7 + n6, n8 + n5, n6, n5, 0, 0, null);
                        }
                        if (bl) {
                            n8 += n5;
                            continue block1;
                        }
                        ++n9;
                    }
                }
                n7 += n6;
            }
        } else {
            boolean bl2 = false;
            do {
                if (this.m_nFlippingMode == 0) {
                    bl2 = graphics.drawImage(this.m_Texture, n, n2, n3, n4, null);
                    continue;
                }
                if (this.m_nFlippingMode == 1) {
                    bl2 = graphics.drawImage(this.m_Texture, n, n2, n + n3, n2 + n4, n2, n2 + n5, n + n6, n, null);
                    continue;
                }
                if (this.m_nFlippingMode == 2) {
                    bl2 = graphics.drawImage(this.m_Texture, n, n2, n + n3, n2 + n4, n2 + n5, n2, n, n + n6, null);
                    continue;
                }
                if (this.m_nFlippingMode != 3) continue;
                bl2 = graphics.drawImage(this.m_Texture, n, n2, n + n3, n2 + n4, n + n6, n2 + n5, n, n2, null);
            } while (!bl2);
        }
    }
}

