/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetLine
extends DetObj {
    protected static final int SLOP_FACTOR = 40;
    public static final int THIN_LINE = 0;
    protected Point m_pt1;
    protected Point m_pt2;
    protected Polygon m_polyLine;
    protected int m_nLineWidth;
    protected int m_lineStyle = Perspective.SOLID;
    protected boolean m_isMarker;

    public DetLine(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, int n5) {
        super(detectiv, identObj, blackBoxIF, rectangle, false, true, true);
        this.m_pt1 = new Point(n, n2);
        this.m_pt2 = new Point(n3, n4);
        this.m_nLineWidth = n5;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (identObj.getObjectID() == 249 || identObj.getObjectID() == 13) {
            this.m_isMarker = true;
        }
    }

    public DetLine(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, int n5, int n6) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, n5);
        this.m_lineStyle = n6;
    }

    public DetLine(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, bl, bl2, 0);
    }

    public DetLine(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, int n5) {
        super(detectiv, identObj, blackBoxIF, rectangle, bl, bl2, true);
        this.m_pt1 = new Point(n, n2);
        this.m_pt2 = new Point(n3, n4);
        this.m_nLineWidth = n5;
        this.m_polyLine = null;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (identObj.getObjectID() == 249 || identObj.getObjectID() == 13) {
            this.m_isMarker = true;
        }
    }

    public DetLine(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, int n5, int n6) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, rectangle, bl, bl2, n5);
        this.m_lineStyle = n6;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DetLine)) {
            return false;
        }
        DetLine detLine = (DetLine)object;
        return this.m_id.equals(detLine.m_id);
    }

    public Point getBeginPoint() {
        return this.m_pt1;
    }

    public Point getEndPoint() {
        return this.m_pt2;
    }

    public Rectangle getBounds() {
        return new Rectangle(Math.min(this.m_pt1.x, this.m_pt2.x), Math.min(this.m_pt1.y, this.m_pt2.y), Math.abs(this.m_pt1.x - this.m_pt2.x), Math.abs(this.m_pt1.y - this.m_pt2.y));
    }

    public void hilite(Graphics graphics, VC vC) {
        Point point = vC.virtToDest(new Point(this.m_pt1.x, this.m_pt1.y));
        Point point2 = vC.virtToDest(new Point(this.m_pt2.x, this.m_pt2.y));
        graphics.setXORMode(Color.yellow);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setPaintMode();
    }

    public boolean isPointInObj(int n, int n2, VC vC) {
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_polyLine == null) {
            this.m_polyLine = this.calcLine(Math.max(this.m_nLineWidth, 5), vC, false);
        }
        return this.m_polyLine.contains(n, n2);
    }

    public boolean isPointInObj(Point point, VC vC) {
        return this.isPointInObj(point.x, point.y, vC);
    }

    public void paintIt(Graphics graphics, VC vC) {
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == Perspective.SOLID) {
                    this.m_blackBox.paint(graphics, vC.virtToDest(this.m_pt1), vC.virtToDest(this.m_pt2));
                    break;
                }
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_pt1), vC.virtToDest(this.m_pt2), 1, this.m_lineStyle, this.m_isMarker);
                break;
            }
            default: {
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_pt1), vC.virtToDest(this.m_pt2), this.m_nLineWidth, this.m_lineStyle, this.m_isMarker);
            }
        }
        this.m_polyLine = null;
    }

    public void setBeginPoint(Point point) {
        this.m_pt1 = point;
    }

    public void setEndPoint(Point point) {
        this.m_pt2 = point;
    }

    public void setBounds(Rectangle rectangle) {
    }

    private Polygon calcLine(int n, VC vC, boolean bl) {
        Point point;
        Point point2;
        Polygon polygon = new Polygon();
        if (this.m_pt1.x < this.m_pt2.x) {
            point2 = vC.virtToDest(this.m_pt1);
            point = vC.virtToDest(this.m_pt2);
        } else {
            point = vC.virtToDest(this.m_pt1);
            point2 = vC.virtToDest(this.m_pt2);
        }
        PfjAssert.pfjAssert(point2.x <= point.x);
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.atan2(d2, d) * 57.29577951308232;
        if (bl) {
            Point point3;
            double d4 = 90.0;
            while (FP.lessThan(d4, 272.0)) {
                point3 = vC.destToVirt(MathExt.polToCart(d3 + d4, n, point2));
                polygon.addPoint(point3.x, point3.y);
                d4 += 10.0;
            }
            d4 = -90.0;
            while (FP.lessThan(d4, 92.0)) {
                point3 = vC.destToVirt(MathExt.polToCart(d3 + d4, n, point));
                polygon.addPoint(point3.x, point3.y);
                d4 += 10.0;
            }
        } else {
            double d5 = (d3 + (double)90) * (Math.PI / 180);
            int n2 = point2.x + (int)Math.round((double)n * Math.cos(d5));
            int n3 = point2.y + (int)Math.round((double)n * Math.sin(d5));
            polygon.addPoint(n2, n3);
            d5 = (d3 + (double)270) * (Math.PI / 180);
            int n4 = point2.x + (int)Math.round((double)n * Math.cos(d5));
            int n5 = point2.y + (int)Math.round((double)n * Math.sin(d5));
            polygon.addPoint(n4, n5);
            d5 = (d3 - (double)90) * (Math.PI / 180);
            int n6 = point.x + (int)Math.round((double)n * Math.cos(d5));
            int n7 = point.y + (int)Math.round((double)n * Math.sin(d5));
            polygon.addPoint(n6, n7);
            d5 = (d3 + (double)90) * (Math.PI / 180);
            int n8 = point.x + (int)Math.round((double)n * Math.cos(d5));
            int n9 = point.y + (int)Math.round((double)n * Math.sin(d5));
            polygon.addPoint(n8, n9);
            polygon.addPoint(n2, n3);
            polygon = vC.destToVirt(polygon);
        }
        return polygon;
    }

    public Polygon getShape(VC vC) {
        return this.calcLine(Math.max(this.m_nLineWidth, 5), vC, false);
    }
}

