/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ZoomState;

public class ZoomStateList
implements Serializable {
    public static final int UNZOOMED = 0;
    private Vector m_states;
    private int m_currentState;

    public ZoomStateList() {
        this.clearList();
    }

    public void addZoomState(ZoomState zoomState) {
        int n = this.m_states.size() - 1;
        while (n > this.m_currentState) {
            this.m_states.removeElementAt(n);
            --n;
        }
        this.m_states.addElement(zoomState);
        this.m_currentState = this.m_states.size() - 1;
    }

    public void clearList() {
        this.m_states = new Vector();
        this.addZoomState(ZoomState.UNZOOMED);
        this.m_currentState = 0;
    }

    public int getCurrentIndex() {
        return this.m_currentState;
    }

    public ZoomState getZoomState() {
        return this.getZoomState(this.m_currentState);
    }

    public ZoomState getZoomState(int n) {
        PfjAssert.pfjAssert(n >= 0 && n < this.m_states.size());
        ZoomState zoomState = (ZoomState)this.m_states.elementAt(n);
        return zoomState;
    }

    public boolean isValid() {
        boolean bl = !this.m_states.isEmpty() && this.m_currentState >= 0 && this.m_currentState < this.m_states.size();
        return bl;
    }

    public boolean isCurrentlyZoomed() {
        boolean bl = this.isValid() && this.getZoomState().isZoomed();
        return bl;
    }

    public boolean isValidIndex(int n) {
        boolean bl = !this.m_states.isEmpty() && n >= 0 && n < this.m_states.size();
        return bl;
    }

    public void setCurrentIndex(int n) {
        PfjAssert.pfjAssert(n >= 0 && n < this.m_states.size());
        if (n >= 0 && n < this.m_states.size()) {
            this.m_currentState = n;
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf("list = ")) + this.m_states.toString() + ", current state = " + this.m_currentState;
    }
}

