/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

public class TDGToken {
    public static final int NEW = 1;
    public static final int BOOLEAN = 2;
    public static final int METHOD_NAME = 3;
    public static final int OPEN_PARENTHESES = 4;
    public static final int CLOSE_PARENTHESES = 5;
    public static final int SEMI_COLON = 6;
    public static final int COMMA = 7;
    public static final int STRING = 8;
    public static final int NUMBER = 9;
    public static final int NULL_PARAM = 10;
    private int m_nTokenType;
    private Object m_Object;

    public TDGToken(int n) {
        this.m_nTokenType = n;
        this.m_Object = null;
    }

    public TDGToken(int n, Object object) {
        this.m_nTokenType = n;
        this.m_Object = object;
    }

    public String toString() {
        String string = "Token Type = ";
        switch (this.m_nTokenType) {
            case 1: {
                string = String.valueOf(string) + "NEW";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "BOOLEAN";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "METHOD NAME";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "(";
                break;
            }
            case 5: {
                string = String.valueOf(string) + ")";
                break;
            }
            case 6: {
                string = String.valueOf(string) + ";";
                break;
            }
            case 7: {
                string = String.valueOf(string) + ",";
                break;
            }
            case 8: {
                string = String.valueOf(string) + "STRING";
                break;
            }
            case 9: {
                string = String.valueOf(string) + "NUMBER";
                break;
            }
            case 10: {
                string = String.valueOf(string) + "NULL_PARAM";
            }
        }
        string = String.valueOf(string) + "\t Parameter = " + (this.m_Object != null ? this.m_Object.toString() : "null");
        return string;
    }

    public int getType() {
        return this.m_nTokenType;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public boolean isNewParameter() {
        return this.m_nTokenType == 1 || this.m_nTokenType == 2 || this.m_nTokenType == 3 || this.m_nTokenType == 8 || this.m_nTokenType == 9 || this.m_nTokenType == 10;
    }
}

