/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.ObjectString;

public class TDGMouseState {
    public static final int DEADZONEMOUSELOCATION_UNKNOWN = 0;
    public static final int DEADZONEMOUSELOCATION_LEFTOFDEADZONE = 1;
    public static final int DEADZONEMOUSELOCATION_INDEADZONE = 2;
    public static final int DEADZONEMOUSELOCATION_RIGHTOFDEADZONE = 3;
    MouseEvent m_evt;
    DetObj m_DetObj;
    boolean m_ShiftKey;
    boolean m_ControlKey;
    boolean m_DragHappened;
    int m_nDeadZoneMouseLocation = 0;

    public TDGMouseState(MouseEvent mouseEvent, DetObj detObj) {
        this.m_evt = mouseEvent;
        this.m_DetObj = detObj;
        this.m_ShiftKey = (mouseEvent.getModifiers() & 1) != 0;
        this.m_ControlKey = (mouseEvent.getModifiers() & 2) != 0;
    }

    public TDGMouseState(MouseEvent mouseEvent, DetObj detObj, boolean bl) {
        this(mouseEvent, detObj);
        this.m_DragHappened = bl;
    }

    public IdentObj getIdentObj() {
        return this.m_DetObj.getIdentID();
    }

    public MouseEvent getMouseEvent() {
        return this.m_evt;
    }

    public int getMouseX() {
        if (this.m_evt != null) {
            return this.m_evt.getX();
        }
        return -1;
    }

    public int getMouseY() {
        if (this.m_evt != null) {
            return this.m_evt.getY();
        }
        return -1;
    }

    public boolean isShiftKey() {
        return this.m_ShiftKey;
    }

    public boolean isControlKey() {
        return this.m_ControlKey;
    }

    public boolean isDrag() {
        return this.m_DragHappened;
    }

    public Rectangle getElementBounds() {
        return this.m_DetObj.getBounds();
    }

    public int getElementObjectID() {
        int n = this.m_DetObj.getObjectID();
        if (ObjClassID.isExceptional(n)) {
            n = ObjClassID.stripExceptionalOffset(n);
        }
        return n;
    }

    public int getElementInstanceID() {
        return this.m_DetObj.getIdentID().getMiscID();
    }

    public int getElementSeriesID() {
        return this.m_DetObj.getSeriesID();
    }

    public int getElementGroupID() {
        return this.m_DetObj.getGroupID();
    }

    public String getElementName() {
        return ObjectString.objectName(this.getElementObjectID());
    }

    public String getElementDesc() {
        return ObjectString.objectDescription(this.getElementObjectID());
    }

    public String getElementText() {
        String string = null;
        if (this.m_DetObj.getIdentID().isText() && this.m_DetObj instanceof DetLabel && (string = ((DetLabel)this.m_DetObj).getFullText()) == null) {
            string = ((DetLabel)this.m_DetObj).getLabelString();
        }
        return string;
    }

    public void setDeadZoneMouseLocation(int n) {
        this.m_nDeadZoneMouseLocation = n;
    }

    public int getDeadZoneMouseLocation() {
        return this.m_nDeadZoneMouseLocation;
    }
}

