/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class ScrollData
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptScrollRect;
    public Rectangle m_rOldScroll;

    public ScrollData(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mousePressedScroll(Point point) {
        this.m_ptScrollRect = point;
        this.m_rOldScroll = null;
    }

    public void drawScroller(Graphics graphics) {
        graphics.setXORMode(Color.yellow);
        if (this.m_rOldScroll != null) {
            graphics.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
        }
        graphics.setPaintMode();
    }

    public void mouseReleasedScroll(MouseEvent mouseEvent, int n, Graphics graphics) {
        if (n == 20 || n == 26) {
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            Rectangle rectangle = n == 20 ? this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getGroupScroller())) : this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getSeriesScroller()));
            this.drawScroller(graphics);
            if (this.m_rOldScroll != null) {
                boolean bl = n == 20 ? jGraphType.isOrientHorz() : this.m_Perspective.m_chart.m_Legend.isHorz();
                double d = bl ? (double)(this.m_rOldScroll.y - rectangle.y) / (double)(rectangle.height - this.m_rOldScroll.height) : (double)(this.m_rOldScroll.x - rectangle.x) / (double)(rectangle.width - this.m_rOldScroll.width);
                if (n == 20) {
                    int n2 = (int)Math.round(d * (double)(this.m_Perspective.getNumTotalGroups() - this.m_Perspective.getNumGroups()));
                    this.m_Perspective.setScrollOffsetGroup(n2);
                } else {
                    int n3 = (int)Math.round(d * (double)(this.m_Perspective.getNumTotalSeries() - this.m_Perspective.getNumSeries()));
                    this.m_Perspective.setScrollOffsetSeries(n3);
                }
            }
            this.m_rOldScroll = null;
        }
    }

    public void mouseDraggedScroll(MouseEvent mouseEvent, IdentObj identObj, Graphics graphics) {
        int n;
        int n2 = n = identObj == null ? -3 : identObj.getObjectID();
        if (identObj.isScrollerThumb()) {
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            DetObj detObj = this.m_Perspective.m_selList.firstDetObjElement();
            PfjAssert.pfjAssert(detObj);
            Rectangle rectangle = this.m_Perspective.m_VC.virtToDest(detObj.getBounds());
            Rectangle rectangle2 = n == 20 ? this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getGroupScroller())) : this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getSeriesScroller()));
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            boolean bl = n == 20 ? jGraphType.isOrientHorz() : this.m_Perspective.m_chart.m_Legend.isHorz();
            if (bl) {
                int n3 = point.y - this.m_ptScrollRect.y;
                rectangle.y += n3;
                if (rectangle.y < rectangle2.y) {
                    rectangle.y = rectangle2.y;
                } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
                }
            } else {
                int n4 = point.x - this.m_ptScrollRect.x;
                rectangle.x += n4;
                if (rectangle.x < rectangle2.x) {
                    rectangle.x = rectangle2.x;
                } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
                }
            }
            graphics.setXORMode(Color.yellow);
            if (this.m_rOldScroll != null) {
                graphics.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
            }
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
            this.m_rOldScroll = rectangle;
        }
    }

    public boolean keyEditOfScroller(int n, int n2) {
        int n3 = this.m_Perspective.getEffectiveViewableGroups();
        int n4 = this.m_Perspective.getEffectiveViewableSeries();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        block0 : switch (n) {
            case 37: {
                switch (n2) {
                    case 22: {
                        this.decrementScrollOffset(bl3);
                        bl = true;
                        break;
                    }
                    case 23: {
                        if (n3 > 1) {
                            this.m_Perspective.setViewableGroups(n3 - 1);
                        }
                        bl = true;
                        break;
                    }
                    case 24: {
                        this.incrementScrollOffset(bl3);
                        bl = true;
                        break;
                    }
                    case 28: {
                        this.decrementScrollOffset(bl2);
                        bl = true;
                        break;
                    }
                    case 29: {
                        if (n4 > 1) {
                            this.m_Perspective.setViewableSeries(n4 - 1);
                        }
                        bl = true;
                        break;
                    }
                    case 30: {
                        this.incrementScrollOffset(bl2);
                        bl = true;
                    }
                }
                break;
            }
            case 39: {
                switch (n2) {
                    case 22: {
                        this.incrementScrollOffset(bl3);
                        bl = true;
                        break block0;
                    }
                    case 23: {
                        if (n3 < this.m_Perspective.getNumTotalGroups()) {
                            this.m_Perspective.setViewableGroups(++n3);
                            if (this.m_Perspective.getEffectiveGroupOffset() + n3 > this.m_Perspective.getNumTotalGroups()) {
                                this.m_Perspective.setScrollOffsetGroup(this.m_Perspective.getEffectiveGroupOffset() - 1);
                            }
                        }
                        bl = true;
                        break block0;
                    }
                    case 24: {
                        this.decrementScrollOffset(bl3);
                        bl = true;
                        break block0;
                    }
                    case 28: {
                        this.incrementScrollOffset(bl2);
                        bl = true;
                        break block0;
                    }
                    case 29: {
                        if (n4 < this.m_Perspective.getNumTotalSeries()) {
                            this.m_Perspective.setViewableSeries(++n4);
                            if (this.m_Perspective.getEffectiveSeriesOffset() + n4 > this.m_Perspective.getNumTotalSeries()) {
                                this.m_Perspective.setScrollOffsetSeries(this.m_Perspective.getEffectiveSeriesOffset() - 1);
                            }
                        }
                        bl = true;
                        break block0;
                    }
                    case 30: {
                        this.decrementScrollOffset(bl2);
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public boolean keyEditOfVDR(int n) {
        boolean bl = false;
        boolean bl2 = this.m_Perspective.getSeriesAreRows();
        switch (n) {
            case 38: {
                this.decrementScrollOffset(bl2);
                bl = true;
                break;
            }
            case 40: {
                this.incrementScrollOffset(bl2);
                bl = true;
                break;
            }
            case 37: {
                this.decrementScrollOffset(!bl2);
                bl = true;
                break;
            }
            case 39: {
                this.incrementScrollOffset(!bl2);
                bl = true;
            }
        }
        return bl;
    }

    private void decrementScrollOffset(boolean bl) {
        if (bl) {
            if (this.m_Perspective.getScrollOffsetSeries() > 0) {
                this.m_Perspective.setScrollOffsetSeries(this.m_Perspective.getScrollOffsetSeries() - 1);
            }
        } else if (this.m_Perspective.getScrollOffsetGroup() > 0) {
            this.m_Perspective.setScrollOffsetGroup(this.m_Perspective.getScrollOffsetGroup() - 1);
        }
    }

    private void incrementScrollOffset(boolean bl) {
        int n = this.m_Perspective.getEffectiveGroupOffset();
        int n2 = this.m_Perspective.getEffectiveSeriesOffset();
        int n3 = this.m_Perspective.getEffectiveViewableGroups();
        int n4 = this.m_Perspective.getEffectiveViewableSeries();
        if (bl) {
            if (n2 + n4 < this.m_Perspective.getNumTotalSeries()) {
                this.m_Perspective.setScrollOffsetSeries(n2 + 1);
            }
        } else if (n + n3 < this.m_Perspective.getNumTotalGroups()) {
            this.m_Perspective.setScrollOffsetGroup(n + 1);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

