/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class ReferenceLineObj
implements Serializable {
    protected Perspective m_Perspective;
    protected IdentObj m_id;
    protected Point pt1;
    protected Point pt2;
    protected int m_nLineWidth = 1;
    protected int m_lineStyle;
    protected int m_nNdx;
    protected Point m_frameDepthOffset;
    protected String m_szLabel;
    protected IdentObj m_AxisObj;
    protected double m_nValue;
    protected boolean m_bDrawWithDepth;
    protected Rectangle m_frameRect;
    protected int m_nAxisID;
    protected int m_axisLineObjID;
    protected int m_nSIndex;
    private String m_szFontName;
    private int m_nFontStyle;
    private int m_nFontSize;
    private int m_nFontSizeVC;
    private TextStyleObj m_textStyle;
    private Rectangle m_rFrameVC = new Rectangle();
    private Point m_centerFramePosVC = new Point(0, 0);
    private double m_relVal;
    DetLine m_LineObj;
    int m_nWidthVC;
    JChart_Base m_chart;
    int sID;

    public ReferenceLineObj(Perspective perspective, IdentObj identObj, int n, double d) {
        this.m_Perspective = perspective;
        this.m_nAxisID = identObj.getObjectID();
        IdentObj identObj2 = null;
        boolean bl = false;
        switch (this.m_nAxisID) {
            case 2004: {
                identObj2 = this.m_Perspective.getY1AxisLine();
                break;
            }
            case 2005: {
                identObj2 = this.m_Perspective.getY2AxisLine();
                break;
            }
            case 2003: {
                identObj2 = this.m_Perspective.getX1AxisLine();
            }
        }
        this.m_axisLineObjID = identObj2.getObjectID();
        this.m_id = new IdentObj(358, n, this.m_axisLineObjID);
        this.m_nNdx = n;
        this.m_AxisObj = identObj;
        this.m_nValue = d;
        this.m_Perspective.setDisplay(this.m_Perspective.getReferenceLineLegendText(this.m_AxisObj, this.m_nNdx), false);
        this.m_Perspective.setFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx), new Color(0, 0, 0));
        switch (this.m_nAxisID) {
            case 2004: {
                this.sID = 3000;
                break;
            }
            case 2005: {
                this.sID = 4000;
                break;
            }
            case 2003: {
                this.sID = 5000;
                break;
            }
            default: {
                this.sID = this.m_nAxisID;
            }
        }
        this.m_nSIndex = this.sID + this.m_nNdx + (int)this.m_nValue + 1;
    }

    public void calc() {
        double d;
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        this.m_chart = this.m_Perspective.getGraphObject();
        if (!(jGraphType.isBLAType() || jGraphType.isPolar() || jGraphType.isRadarType() || jGraphType.isScatter() || jGraphType.isBubble())) {
            return;
        }
        if (!this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_chart)) {
            return;
        }
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_id);
        this.m_nLineWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        this.m_lineStyle = this.m_Perspective.getLineStyle(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        int n = this.m_nLineWidth;
        if (this.m_nLineWidth == 0) {
            n = 1;
        }
        this.m_nWidthVC = this.m_Perspective.m_VC.destToVirtWidth(n);
        blackBoxObj.setBorderColor(this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx)));
        blackBoxObj.setFillColor(this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx)));
        this.m_bDrawWithDepth = this.m_Perspective.getDepthRadius() > 0;
        this.m_frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        this.m_frameRect = this.m_Perspective.getFrameRect(true);
        this.m_szLabel = this.m_Perspective.getTextString(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        this.m_frameRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        JChart_2D_Standard jChart_2D_Standard = (JChart_2D_Standard)this.m_chart;
        RelativeAxisObj relativeAxisObj = null;
        if (this.m_nAxisID == 2004) {
            relativeAxisObj = jChart_2D_Standard.getY1Axis();
            if (relativeAxisObj != null) {
                int n2;
                d = this.m_nValue;
                if (jGraphType.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    d = this.m_nValue / 100.0;
                }
                if (relativeAxisObj.isVertical()) {
                    n2 = (int)relativeAxisObj.getValueCoord(d);
                    this.pt1 = new Point(this.m_frameRect.x, n2);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, n2);
                    this.m_relVal = relativeAxisObj.getValueRelCoord(d);
                } else {
                    n2 = (int)relativeAxisObj.getValueCoord(d);
                    this.pt1 = new Point(n2, this.m_frameRect.y);
                    this.pt2 = new Point(n2, this.m_frameRect.y + this.m_frameRect.height);
                    this.m_relVal = relativeAxisObj.getValueRelCoord(d);
                }
            }
        } else if (this.m_nAxisID == 2003) {
            relativeAxisObj = jChart_2D_Standard.getX1Axis();
            if (relativeAxisObj != null) {
                int n3;
                d = this.m_nValue;
                if (jGraphType.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    d = this.m_nValue / 100.0;
                }
                if (relativeAxisObj.isVertical()) {
                    n3 = (int)relativeAxisObj.getValueCoord(d);
                    this.pt1 = new Point(this.m_frameRect.x, n3);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, n3);
                    this.m_relVal = relativeAxisObj.getValueRelCoord(d);
                } else {
                    n3 = (int)relativeAxisObj.getValueCoord(d);
                    this.pt1 = new Point(n3, this.m_frameRect.y);
                    this.pt2 = new Point(n3, this.m_frameRect.y + this.m_frameRect.height);
                    this.m_relVal = relativeAxisObj.getValueRelCoord(d);
                }
            }
        } else if (this.m_nAxisID == 2005 && (relativeAxisObj = jChart_2D_Standard.getY2Axis()) != null) {
            int n4;
            d = this.m_nValue;
            if (jGraphType.isParetoType() || jGraphType.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                d = this.m_nValue / 100.0;
            }
            if (relativeAxisObj.isVertical()) {
                if (jGraphType.isParetoType()) {
                    double d2 = relativeAxisObj.getValueFromRelCoord(d);
                    n4 = (int)relativeAxisObj.getValueCoord(d2);
                    this.pt1 = new Point(this.m_frameRect.x, n4);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, n4);
                    this.m_relVal = d;
                } else {
                    int n5 = (int)relativeAxisObj.getValueCoord(d);
                    this.pt1 = new Point(this.m_frameRect.x, n5);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, n5);
                    this.m_relVal = relativeAxisObj.getValueRelCoord(d);
                }
            } else if (jGraphType.isParetoType()) {
                double d3 = relativeAxisObj.getValueFromRelCoord(d);
                n4 = (int)relativeAxisObj.getValueCoord(d3);
                this.pt1 = new Point(n4, this.m_frameRect.y);
                this.pt2 = new Point(n4, this.m_frameRect.y + this.m_frameRect.height);
                this.m_relVal = d;
            } else {
                int n6 = (int)relativeAxisObj.getValueCoord(d);
                this.pt1 = new Point(n6, this.m_frameRect.y);
                this.pt2 = new Point(n6, this.m_frameRect.y + this.m_frameRect.height);
                this.m_relVal = relativeAxisObj.getValueRelCoord(d);
            }
        }
        if (relativeAxisObj != null) {
            d = relativeAxisObj.getMaxValue();
            double d4 = relativeAxisObj.getMinValue();
            if (jGraphType.isParetoType() && this.m_nAxisID == 2005) {
                double d5 = this.m_nValue / 100.0;
                double d6 = relativeAxisObj.getValueFromRelCoord(d5);
                if (d6 > d || d6 < d4) {
                    return;
                }
            } else {
                double d7 = this.m_nValue;
                if (jGraphType.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    d7 = this.m_nValue / 100.0;
                }
                if (d7 > d || d7 < d4) {
                    return;
                }
            }
        }
        if (this.pt1 != null && this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx))) {
            if (jGraphType.isPolar() || jGraphType.isRadarType()) {
                this.m_rFrameVC.width = this.m_frameRect.width;
                this.m_rFrameVC.height = this.m_frameRect.height;
                this.m_centerFramePosVC.x = this.m_frameRect.x + this.m_frameRect.width / 2;
                this.m_centerFramePosVC.y = this.m_frameRect.y + this.m_frameRect.height / 2;
                if (this.m_nAxisID == 2004) {
                    Rectangle rectangle = new Rectangle(this.getValueOval(this.m_relVal));
                    DetOval detOval = new DetOval(this.m_Perspective.m_Detectiv, this.m_id, rectangle.x, rectangle.y, rectangle.width, rectangle.height, blackBoxObj, null, false, true, true, this.m_nLineWidth, this.m_nWidthVC);
                    detOval.setReferenceData(this.m_nValue);
                    detOval.setReferenceObject();
                } else if (this.m_nAxisID == 2003) {
                    relativeAxisObj = jChart_2D_Standard.getX1Axis();
                    Rectangle rectangle = this.m_Perspective.getFrameRect(false);
                    Point point = new Point(0, 0);
                    double d8 = relativeAxisObj.getValueCoord(this.m_nValue);
                    Dimension dimension = new Dimension(rectangle.width, rectangle.height);
                    CircularAxisObj circularAxisObj = (CircularAxisObj)relativeAxisObj;
                    CircularAxisObj.polarToCartesian(point, d8, 1.0, dimension, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, point.x, point.y, (BlackBoxIF)blackBoxObj, null, this.m_nLineWidth, this.m_lineStyle);
                    this.m_LineObj.setReferenceData(this.m_nValue);
                    this.m_LineObj.setReferenceObject();
                }
            } else if (!this.m_bDrawWithDepth) {
                this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.pt1.x, this.pt1.y, this.pt2.x, this.pt2.y, blackBoxObj, null, false, true, this.m_nLineWidth, this.m_lineStyle);
                this.m_LineObj.setReferenceData(this.m_nValue);
                this.m_LineObj.setReferenceObject();
            } else {
                this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.pt1.x - this.m_frameDepthOffset.x, this.pt1.y - this.m_frameDepthOffset.y, this.pt2.x - this.m_frameDepthOffset.x, this.pt2.y - this.m_frameDepthOffset.y, blackBoxObj, null, false, true, this.m_nLineWidth, this.m_lineStyle);
                this.m_LineObj.setReferenceData(this.m_nValue);
                this.m_LineObj.setReferenceObject();
            }
        }
    }

    public IdentObj getIdentObj() {
        return this.m_AxisObj;
    }

    public double getPosition() {
        return this.m_nValue;
    }

    public void setLineLabel(String string) {
        this.m_szLabel = string;
    }

    public String getLineLabel() {
        return this.m_szLabel;
    }

    public int getObjectID() {
        return this.m_AxisObj.getObjectID() * this.m_nNdx;
    }

    public int getAxisLineObjID() {
        return this.m_axisLineObjID;
    }

    public int getAxisID() {
        return this.m_nAxisID;
    }

    public int getIndex() {
        return this.m_nNdx;
    }

    public int getSID() {
        return this.sID;
    }

    public int getRelativeXPos() {
        return this.pt1.x;
    }

    public int getSortIndex() {
        return this.m_nSIndex;
    }

    public Rectangle getValueOval(double d) {
        return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_rFrameVC.width / 2) * d), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_rFrameVC.height / 2) * d), (int)((double)(2 * this.m_rFrameVC.width / 2) * d), (int)((double)(2 * this.m_rFrameVC.height / 2) * d));
    }

    private boolean checkValidAxis(IdentObj identObj, int n, JChart_Base jChart_Base) {
        boolean bl = false;
        if (jChart_Base != null) {
            JChart_2D_Standard jChart_2D_Standard = (JChart_2D_Standard)jChart_Base;
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            AxisDescriptor axisDescriptor = jGraphType.getAxisDescriptor();
            if (axisDescriptor != null) {
                if (n == 2004) {
                    if (axisDescriptor.hasY1()) {
                        bl = true;
                    }
                } else if (n == 2003) {
                    if (axisDescriptor.hasX1()) {
                        bl = true;
                    }
                } else if (n == 2005 && axisDescriptor.hasY2()) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean IsReferenceLineAxisValid() {
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (!(jGraphType.isBLAType() || jGraphType.isPolar() || jGraphType.isRadarType() || jGraphType.isScatter() || jGraphType.isBubble())) {
            return this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_chart);
        }
        return false;
    }

    public boolean IsValidAxis() {
        return this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_Perspective.getGraphObject());
    }
}

