/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Polar
extends JChart_2D_Circular {
    public void calc() {
        super.calc();
        if (this.m_nDepthRadius > 0) {
            this.drawAllMarkersWithDepth(false);
        } else {
            this.drawMarkers();
        }
        this.drawLabels();
    }

    public boolean wantLegend() {
        return true;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        string2 = this.ReplaceMacro(string2, "[X]", stringArray[0]);
        string2 = this.ReplaceMacro(string2, "[Y]", stringArray[1]);
        return string2;
    }

    public double getLabelXValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_LBL_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getLabelYValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_LBL_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_XValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_YValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_ZValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_Z;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getYValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    protected void drawLabels() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vector = null;
        IdentObj identObj = this.m_Perspective.getDataText();
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n = dataFormat.getNumDataItems();
        Rectangle rectangle = this.m_Perspective.getFrameRect(true);
        if (this.m_bDataTextDisplay) {
            int n2;
            int n3;
            vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2]) continue;
                    vector.addElement(this.m_DataLabel[n3][n2]);
                }
            }
            Dimension dimension = new Dimension(5000, 1600);
            boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
            TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), 0, this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
            int n4 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n4, vector, dimension, this.m_Perspective.m_VC);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2] || this.m_DataLabel[n3][n2] == null) continue;
                    BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
                    Rectangle rectangle2 = this.calcDataValuePosition(n3, n2, dimension);
                    if (rectangle2 == null) continue;
                    IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n3, n2);
                    new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n3][n2], rectangle2, textStyleObj, (BlackBoxIF)blackBoxObj, false, rectangle);
                }
            }
        }
    }

    protected Rectangle calcDataValuePosition(int n, int n2, Dimension dimension) {
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = this.m_numXCoords[n][n2];
        int n6 = this.m_numYCoords[n][n2];
        Rectangle rectangle = new Rectangle(n5, n6, n3, n4);
        return rectangle;
    }
}

