/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.event.TDGErrorManager;
import oracle.dss.graph.pfj.event.TDGEventManager;

public class JChart_2D_Hilo
extends JChart_2D_Standard {
    public static final int TICK_LENGTH = 5;
    public static final int RISER_TICK_THICKNESS = 3;
    public static final int MA_SCIENTIFIC = 0;
    public static final int MA_FINANCIAL = 1;
    public static final int MISC_LOWER = 1;
    public static final int kMAX_HILO_ITEMS = 4;
    public static final int STOCK_SPLITBAR = 0;
    public static final int STOCK_TICKS = 1;
    public static final int VOLUME_SERIES = 1;
    protected DataFormat m_df;
    protected boolean m_bHasOpen;
    protected boolean m_bHasClose;
    protected boolean m_bHasVolume;
    protected int m_nLineWidthMA;
    protected int m_nLineWidthCloseTick;
    protected int m_nLineWidthOpenTick;
    protected int m_nLineWidthHighWick;
    protected int m_nLineWidthLowWick;
    protected boolean m_bCloseSplitDisplay;
    protected boolean m_bCloseTicksDisplay;
    protected boolean m_bOpenTicksDisplay;
    protected boolean m_bInterpretAsHLOC;
    String[] m_VolumeDataLabel;
    GroupsEnumerator m_gEnumReadOnly;

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_df = this.m_Access.getDataFormat();
        this.m_bHasOpen = this.hasOpenValue(this.m_df);
        this.m_bHasClose = this.hasCloseValue(this.m_df);
        this.m_bHasVolume = this.hasVolumeValue(this.m_df);
    }

    protected void calc52WeekLines() {
        int n;
        int n2;
        int n3;
        int n4;
        IdentObj identObj = new IdentObj(304);
        IdentObj identObj2 = new IdentObj(305);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        BlackBoxObj blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj2);
        Rectangle rectangle = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isBipolar()) {
            return;
        }
        if (this.m_Perspective.getStock52WeekHighDisplay()) {
            double d = this.m_Perspective.getStock52WeekHighValue();
            n3 = n4 = (int)this.m_Y1Axis.getValueCoord(d);
            n2 = rectangle.x;
            n = rectangle.x + rectangle.width;
            new DetLine(this.m_Detectiv, identObj, n2, n4, n, n3, blackBoxObj, this.m_rClip, this.m_Perspective.getLineWidth(this.m_Perspective.getStock52WeekHighLine()));
        }
        if (this.m_Perspective.getStock52WeekLowDisplay()) {
            double d = (int)this.m_Perspective.getStock52WeekLowValue();
            n3 = n4 = (int)this.m_Y1Axis.getValueCoord(d);
            n2 = rectangle.x;
            n = rectangle.x + rectangle.width;
            new DetLine(this.m_Detectiv, identObj2, n2, n4, n, n3, blackBoxObj2, this.m_rClip, this.m_Perspective.getLineWidth(this.m_Perspective.getStock52WeekLowLine()));
        }
    }

    protected void calcDataAbsolute() {
        this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_gEnumReadOnly = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        if (this.m_gt.isStockCandleType()) {
            this.drawCandleRisers();
        } else {
            this.drawRisersAndTicks();
        }
        if ((this.m_gt.isBipolar() || this.m_bHasVolume) && this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double d = (double)this.m_Perspective.getDualAxisSplitPosition() / (double)100;
            this.m_Frame.drawSeparator(this.m_bHorz, d);
        }
        this.calc52WeekLines();
        if (this.m_Perspective.getStockMovingAverageDisplay()) {
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (seriesEnumerator.hasMoreElements()) {
                int n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
                this.calcMovingAverageLine(n);
            }
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
            if (this.m_bHasVolume) {
                this.drawVolumeDataValues();
            }
        }
    }

    protected void drawDataValues() {
        int n;
        int n2;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        IdentObj identObj = this.m_Perspective.getDataText();
        Vector<String> vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension dimension = new Dimension(3000, 3000);
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        while (seriesEnumerator.hasMoreElements()) {
            n2 = seriesEnumerator.nextSeries();
            if (n2 >= this.m_nTotalSeries) break;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                vector.addElement(this.m_DataLabel[n2][n]);
            }
        }
        int n3 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n3, vector, dimension, this.m_Perspective.m_VC);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            n2 = seriesEnumerator.nextSeries();
            if (n2 >= this.m_nTotalSeries) break;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                if (!this.m_dataOK[n2][n] || this.m_DataLabel[n2][n] == null) continue;
                Rectangle rectangle = this.calcHiLoDataValuePosition(n2, n, dimension);
                IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n2, n);
                new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n2][n], rectangle, textStyleObj, blackBoxObj, false);
            }
        }
    }

    protected Rectangle calcHiLoDataValuePosition(int n, int n2, Dimension dimension) {
        Point point = this.getCoords(n, n2);
        Point point2 = this.getBottomCoords(n, n2);
        Rectangle rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double d = this.m_Perspective.getDataTextAngle(n, n2);
                double d2 = this.m_Perspective.getDataTextRadius(n, n2);
                rectangle.x += (int)(Math.cos(d * (Math.PI / 180)) * d2 * (double)40);
                rectangle.y += (int)(Math.sin(d * (Math.PI / 180)) * d2 * (double)40);
                break;
            }
            case 1: {
                if (this.isAxisAscending(n)) {
                    rectangle.y += dimension.height / 2;
                    break;
                }
                rectangle.y -= dimension.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(n)) {
                    rectangle.y -= dimension.height / 2;
                    break;
                }
                rectangle.y += dimension.height / 2;
                break;
            }
            case 4: {
                rectangle.y = Math.min(point.y, point2.y) + (Math.abs(point.y - point2.y) - dimension.height) / 2;
                break;
            }
            case 5: {
                rectangle.y = point2.y;
            }
        }
        Point point3 = new Point(0, 0);
        if (this.m_Frame != null) {
            point3 = this.m_Frame.getDepthOffset(1.0);
        }
        rectangle.x -= point3.x;
        rectangle.y -= point3.y;
        return rectangle;
    }

    protected void drawVolumeDataValues() {
        int n;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        IdentObj identObj = this.m_Perspective.getDataText();
        Vector<String> vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension dimension = new Dimension(3000, 3000);
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        while (groupsEnumerator.hasMoreElements()) {
            n = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
            vector.addElement(this.m_VolumeDataLabel[n]);
        }
        int n2 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n2, vector, dimension, this.m_Perspective.m_VC);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        while (seriesEnumerator.hasMoreElements()) {
            int n3 = seriesEnumerator.nextSeries();
            if (n3 >= this.m_nTotalSeries) break;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                if (!this.m_dataOK[n3][n] || this.m_VolumeDataLabel[n] == null) continue;
                Rectangle rectangle = this.calcVolumeDataValuePosition(n3, n, dimension);
                IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n3, n);
                new DetLabel(this.m_Detectiv, identObj2, this.m_VolumeDataLabel[n], rectangle, textStyleObj, blackBoxObj, false);
            }
        }
    }

    protected Rectangle calcVolumeDataValuePosition(int n, int n2, Dimension dimension) {
        boolean bl = this.m_Y2Axis.isDescending();
        int n3 = this.m_gEnumReadOnly.getRelativeGroup(n2);
        PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nGroups);
        double d = this.getVolumeValue(n, n2);
        int n4 = (int)(bl ? this.m_Y2Axis.getValueCoord(d) : this.m_Y2Axis.getBaseCoord());
        int n5 = (int)(bl ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(d));
        int n6 = (int)this.m_O1Axis.getLowCoord(0, n3);
        int n7 = (int)this.m_O1Axis.getHighCoord(0, n3);
        Point point = new Point(n6 + (n7 - n6) / 2, n5);
        int n8 = n4;
        Rectangle rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double d2 = this.m_Perspective.getDataTextAngle(n, n2);
                double d3 = this.m_Perspective.getDataTextRadius(n, n2);
                rectangle.x += (int)(Math.cos(d2 * (Math.PI / 180)) * d3 * (double)40);
                rectangle.y += (int)(Math.sin(d2 * (Math.PI / 180)) * d3 * (double)40);
                break;
            }
            case 1: {
                if (this.isAxisAscending(n)) {
                    rectangle.y += dimension.height / 2;
                    break;
                }
                rectangle.y -= dimension.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(n)) {
                    rectangle.y -= dimension.height / 2;
                    break;
                }
                rectangle.y += dimension.height / 2;
                break;
            }
            case 4: {
                rectangle.y = Math.min(point.y, n8) + (Math.abs(point.y - n8) - dimension.height) / 2;
                break;
            }
            case 5: {
                rectangle.y = n8;
            }
        }
        Point point2 = null;
        if (this.m_Frame != null) {
            point2 = this.m_Frame.getDepthOffset(1.0);
        }
        rectangle.x -= point2.x;
        rectangle.y -= point2.y;
        return rectangle;
    }

    protected void calcMovingAverageLine(int n) {
        Object object;
        RelativeAxisObj relativeAxisObj = this.getAxisAssignment(n) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        int n2 = 1;
        int n3 = 6;
        double[] dArray = new double[this.m_nTotalGroups];
        double[] dArray2 = new double[this.m_nTotalGroups];
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        if (n2 != 0 && n2 != 1) {
            throw new AssertionException(String.valueOf(String.valueOf("calcMovingAverageLine: unknown moving average type = ")) + n2);
        }
        if (n3 < 1) {
            throw new AssertionException("calcMovingAverageLine: cannot average fewer than 1 point :-)");
        }
        if (n3 >= this.m_nGroups) {
            object = this.m_Perspective.getErrorManager();
            ((TDGErrorManager)object).notifyErrorListener(this, 3971, "WARNING: nOrder set to data points - 1.", null);
            n3 = this.m_nGroups - 1;
        }
        DataItem dataItem = this.m_bHasClose ? this.getCloseItem() : this.getHighItem();
        int n6 = 0;
        while (n6 < this.m_nTotalGroups) {
            object = this.getDataValue(n, n6, dataItem);
            dArray[n6] = ((DatumObj)object).m_fValue;
            this.m_dataOK[n][n6] = ((DatumObj)object).m_bOK;
            dArray2[n6] = n6 == 0 ? dArray[n6] : dArray2[n6 - 1] + dArray[n6];
            ++n6;
        }
        IdentObj identObj = new IdentObj(309);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        n6 = n3 - 1;
        while (n6 < this.m_nTotalGroups) {
            int n7 = this.m_gEnumReadOnly.getRelativeGroup(n6);
            if (n7 != -1) {
                PfjAssert.pfjAssert(n7 >= 0 && n7 < this.m_nGroups);
                double d = n6 < n3 ? dArray2[n6] : dArray2[n6] - dArray2[n6 - n3];
                double d2 = d / (double)n3;
                int n8 = n2 == 0 ? (int)this.m_O1Axis.getCenterCoord(n7) : (int)((this.m_O1Axis.getCenterCoord(n7) + this.m_O1Axis.getCenterCoord(n7 - n3 + 1)) / (double)2);
                int n9 = (int)relativeAxisObj.getValueCoord(d2);
                if (n4 != Integer.MIN_VALUE) {
                    IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n, n6);
                    new DetLine(this.m_Detectiv, identObj2, n4, n5, n8, n9, blackBoxObj, this.m_rClip, this.m_nLineWidthMA);
                }
                n4 = n8;
                n5 = n9;
            }
            ++n6;
        }
    }

    protected void calcVolumeBar(int n, double d) {
        boolean bl = this.m_Y2Axis.isDescending();
        int n2 = this.m_gEnumReadOnly.getRelativeGroup(n);
        PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nGroups);
        int n3 = (int)(bl ? this.m_Y2Axis.getValueCoord(d) : this.m_Y2Axis.getBaseCoord());
        int n4 = (int)(bl ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(d));
        int n5 = (int)this.m_O1Axis.getLowCoord(0, n2);
        int n6 = (int)this.m_O1Axis.getHighCoord(0, n2);
        Rectangle rectangle = new Rectangle(n5, n3, n6 - n5, n4 - n3);
        IdentObj identObj = new IdentObj(310, 1, n);
        BlackBoxIF blackBoxIF = this.m_autoGradient && (this.m_Perspective.m_VC.virtToDestWidth(rectangle.width) <= 3 || this.m_Perspective.m_VC.virtToDestHeight(rectangle.height) <= 3) ? new SimpleBlackBoxObj(this.m_Perspective, new IdentObj(310), this.m_bWantRiserBorder) : new BlackBoxObj(this.m_Perspective, new IdentObj(310));
        new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF, this.m_rClip);
    }

    protected void copyParams() {
        super.copyParams();
        this.m_nLineWidthMA = this.m_Perspective.getLineWidth(this.m_Perspective.getStockMALine());
        this.m_nLineWidthCloseTick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockCloseTick());
        this.m_nLineWidthOpenTick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockOpenTick());
        this.m_nLineWidthHighWick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockHighLine());
        this.m_nLineWidthLowWick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockLowLine());
        this.m_bCloseSplitDisplay = this.m_Perspective.getStockCloseSplitDisplay();
        this.m_bCloseTicksDisplay = this.m_Perspective.getStockCloseTicksDisplay();
        this.m_bOpenTicksDisplay = this.m_Perspective.getStockOpenTicksDisplay();
        this.m_bInterpretAsHLOC = this.m_Perspective.getInterpretAsHLOC();
        if (this.isSingleSeriesOnly() && this.m_nSeries > 1) {
            this.m_nSeries = 1;
            this.m_nTotalSeries = 1;
        }
    }

    protected void createAxes() {
        int n;
        int n2 = n = this.m_gt.isBipolar() || this.m_bHasVolume ? this.m_Perspective.getDualAxisSplitPosition() : 0;
        int n3 = 100 - n2;
        int n4 = this.m_gt.isBipolar() ? 0 : n2;
        int n5 = this.m_gt.isBipolar() ? 100 - n3 : n3;
        boolean bl = this.m_gt.getOrientation() == 2;
        int n6 = 1;
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, n6, !bl, bl);
        boolean bl2 = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj minMaxObj = this.findLimits(0, bl2);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl, !this.m_Perspective.getY1AxisDescending(), n2, n3);
        if (this.m_gt.isDualY()) {
            bl2 = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj minMaxObj2 = this.findLimits(1, bl2);
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj2, bl, !this.m_Perspective.getY2AxisDescending(), n4, n5);
        } else if (this.m_bHasVolume) {
            bl2 = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj minMaxObj3 = this.findVolumeLimits(bl2);
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj3, bl, !this.m_Perspective.getY2AxisDescending(), 0, n);
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calc();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calc();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calc();
        }
    }

    protected void drawCandleRisers() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        IdentObj identObj = new IdentObj(319);
        IdentObj identObj2 = new IdentObj(320);
        IdentObj identObj3 = new IdentObj(321);
        IdentObj identObj4 = new IdentObj(322);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        boolean bl = this.m_Y1Axis.isDescending();
        boolean bl2 = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        boolean bl3 = this.m_Perspective.isNumberFormatCallBack();
        String[] stringArray = new String[4];
        String string = "";
        int n = this.m_Perspective.getDataTextFormat();
        String string2 = this.m_Perspective.getDataTextFormatPattern();
        if (!this.m_bHasClose || !this.m_bHasOpen) {
            return;
        }
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        string = this.m_Perspective.getDataTextTemplateHiLo();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        BlackBoxObj blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj2);
        BlackBoxObj blackBoxObj3 = new BlackBoxObj(this.m_Perspective, identObj3);
        BlackBoxObj blackBoxObj4 = new BlackBoxObj(this.m_Perspective, identObj4);
        int n2 = 0;
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            IdentObj identObj5;
            int n3;
            int n4;
            int n5;
            int n6;
            double d6;
            double d7;
            double d8;
            int n7;
            int n8;
            block37: {
                n8 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n8 >= 0 && n8 < this.m_nTotalGroups);
                n7 = groupsEnumerator.getRelativeGroup(n8);
                PfjAssert.pfjAssert(n7 >= 0 && n7 < this.m_nGroups);
                this.m_dataOK[n2][n8] = true;
                try {
                    if (this.m_bHasOpen) {
                        d3 = this.getOpenValue(n2, n8);
                    }
                    if (bl2) {
                        d = this.getHighValue(n2, n8);
                        d2 = this.getLowValue(n2, n8);
                        if (d2 > d) {
                            double d9 = d2;
                            d2 = d;
                            d = d9;
                        }
                    }
                    if (this.m_bHasClose) {
                        d4 = this.getCloseValue(n2, n8);
                    }
                    if (!this.m_bHasVolume) break block37;
                    d5 = this.getVolumeValue(n2, n8);
                }
                catch (AssertionException assertionException) {
                    this.m_dataOK[n2][n8] = false;
                    continue;
                }
            }
            if (d4 > d3) {
                d8 = d3;
                d7 = d4;
            } else {
                d8 = d4;
                d7 = d3;
            }
            double d10 = d6 = bl2 && d > d7 ? d : d7;
            if (this.isIgnoredOffScale(this.m_Y1Axis, d6)) {
                this.m_dataOK[n2][n8] = false;
                continue;
            }
            d6 = this.m_bHasClose ? d4 : d;
            int n9 = (int)(bl ? this.m_Y1Axis.getValueCoord(d7) : this.m_Y1Axis.getValueCoord(d8));
            int n10 = (int)(bl ? this.m_Y1Axis.getValueCoord(d8) : this.m_Y1Axis.getValueCoord(d7));
            int n11 = (int)this.m_O1Axis.getLowCoord(0, n7);
            int n12 = (int)this.m_O1Axis.getHighCoord(0, n7);
            int n13 = (int)this.m_O1Axis.getCenterCoord(n7);
            Rectangle rectangle = new Rectangle(n11, n9, n12 - n11, n10 - n9);
            Rectangle rectangle2 = this.m_Perspective.m_VC.virtToDest(rectangle);
            if (rectangle2.height < 2) {
                rectangle2.height = 2;
                rectangle = this.m_Perspective.m_VC.destToVirt(rectangle2);
            }
            if (bl2 && d > d7) {
                n6 = n13;
                n5 = bl ? n9 : n10;
                n4 = n13;
                n3 = (int)this.m_Y1Axis.getValueCoord(d);
                identObj5 = new IdentObj(identObj3.getObjectID(), n2, n8);
                new DetLine(this.m_Detectiv, identObj5, n6, n5, n4, n3, blackBoxObj3, this.m_rClip, this.m_nLineWidthHighWick);
            }
            if (bl2 && d2 < d8) {
                n6 = n13;
                n5 = bl ? n10 : n9;
                n4 = n13;
                n3 = (int)this.m_Y1Axis.getValueCoord(d2);
                identObj5 = new IdentObj(identObj4.getObjectID(), n2, n8);
                new DetLine(this.m_Detectiv, identObj5, n6, n5, n4, n3, blackBoxObj4, this.m_rClip, this.m_nLineWidthLowWick);
            }
            if (d4 >= d3) {
                if (this.m_autoGradient && (rectangle2.height <= 3 || rectangle2.width <= 3)) {
                    SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj, this.m_bWantRiserBorder);
                    new DetRect(this.m_Detectiv, new IdentObj(319, n2, n8), rectangle, (BlackBoxIF)simpleBlackBoxObj, this.m_rClip);
                } else {
                    new DetRect(this.m_Detectiv, new IdentObj(319, n2, n8), rectangle, (BlackBoxIF)blackBoxObj, this.m_rClip);
                }
            } else if (this.m_autoGradient && (rectangle2.height <= 3 || rectangle2.width <= 3)) {
                SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj2, this.m_bWantRiserBorder);
                new DetRect(this.m_Detectiv, new IdentObj(320, n2, n8), rectangle, (BlackBoxIF)simpleBlackBoxObj, this.m_rClip);
            } else {
                new DetRect(this.m_Detectiv, new IdentObj(320, n2, n8), rectangle, (BlackBoxIF)blackBoxObj2, this.m_rClip);
            }
            if (this.m_bDataTextDisplay) {
                if (this.m_bHasOpen) {
                    if (bl3) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n8, "OPEN", -1, -3);
                        stringArray[0] = this.m_Perspective.getNumberFormatCallBack().toString(d3);
                    } else {
                        stringArray[0] = TDGNumberFormat.toString(this.m_Perspective, n, d3, string2);
                    }
                }
                if (bl2) {
                    if (bl3) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n8, "HIGH", -1, -3);
                        stringArray[1] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                    } else {
                        stringArray[1] = TDGNumberFormat.toString(this.m_Perspective, n, d, string2);
                    }
                    if (bl3) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n8, "LOW", -1, -3);
                        stringArray[2] = this.m_Perspective.getNumberFormatCallBack().toString(d2);
                    } else {
                        stringArray[2] = TDGNumberFormat.toString(this.m_Perspective, n, d2, string2);
                    }
                }
                if (this.m_bHasClose) {
                    if (bl3) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n2, n8, "CLOSE", -1, -3);
                        stringArray[3] = this.m_Perspective.getNumberFormatCallBack().toString(d4);
                    } else {
                        stringArray[3] = TDGNumberFormat.toString(this.m_Perspective, n, d4, string2);
                    }
                }
                if (string == null || string.length() < 1) {
                    string = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                }
                this.m_DataLabel[n2][n8] = this.processDataTextTemplate(stringArray, string);
                if (this.m_bHasVolume) {
                    if (bl3) {
                        this.m_Perspective.getNumberFormatCallBack().setState(5, n2, n8, "VOLUME", -1, -3);
                        this.m_VolumeDataLabel[n8] = this.m_Perspective.getNumberFormatCallBack().toString(d5);
                    } else {
                        this.m_VolumeDataLabel[n8] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), d5, this.m_Perspective.getDataTextFormatPattern());
                    }
                }
            }
            if (!this.m_bHasVolume) continue;
            this.calcVolumeBar(n8, d5);
        }
    }

    protected void drawRisersAndTicks() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        IdentObj identObj = new IdentObj(307);
        IdentObj identObj2 = new IdentObj(308);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = this.m_Perspective.getStockTickLength();
        boolean bl = this.m_Perspective.isNumberFormatCallBack();
        String[] stringArray = new String[4];
        String string = "";
        int n2 = this.m_Perspective.getDataTextFormat();
        String string2 = this.m_Perspective.getDataTextFormatPattern();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        string = this.m_Perspective.getDataTextTemplateHiLo();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        BlackBoxObj blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj2);
        while (seriesEnumerator.hasMoreElements()) {
            int n3 = seriesEnumerator.nextSeries();
            if (n3 >= this.m_nTotalSeries) break;
            IdentObj identObj3 = new IdentObj(-3, n3);
            RelativeAxisObj relativeAxisObj = this.getAxisAssignment(n3) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
            boolean bl4 = relativeAxisObj.isDescending();
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                IdentObj identObj4;
                int n4;
                double d4;
                double d5;
                boolean bl5;
                boolean bl6;
                BlackBoxIF blackBoxIF;
                int n5;
                int n6;
                block46: {
                    n6 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
                    n5 = groupsEnumerator.getRelativeGroup(n6);
                    PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nGroups);
                    this.m_dataOK[n3][n6] = true;
                    blackBoxIF = this.assignSeriesColor(n3, n6);
                    blackBoxIF.setTransparentBorderColor(false);
                    if (blackBoxIF.getFillColor() != null) {
                        blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
                    }
                    if (this.m_Perspective.getTransparentFillColor(identObj3)) {
                        blackBoxIF.setTransparentBorderColor(true);
                    }
                    bl6 = false;
                    bl5 = false;
                    try {
                        boolean bl7;
                        boolean bl8;
                        TDGEventManager tDGEventManager;
                        if (this.m_bHasOpen) {
                            try {
                                d = this.getOpenValue(n3, n6);
                            }
                            catch (AssertionException assertionException) {
                                bl5 = true;
                            }
                        }
                        d5 = this.getHighValue(n3, n6);
                        d4 = this.getLowValue(n3, n6);
                        if (d4 > d5) {
                            double d6 = d4;
                            d4 = d5;
                            d5 = d6;
                            if (!bl2) {
                                tDGEventManager = this.m_Perspective.getEventManager();
                                tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3980, null);
                                bl2 = true;
                            }
                        }
                        if (this.m_bHasClose) {
                            try {
                                d2 = this.getCloseValue(n3, n6);
                            }
                            catch (AssertionException assertionException) {
                                bl6 = true;
                            }
                        }
                        if (this.m_bHasVolume) {
                            d3 = this.getVolumeValue(n3, n6);
                        }
                        if (!this.m_bHasOpen || !this.m_bHasClose || bl3) break block46;
                        if (bl5) {
                            bl8 = false;
                        } else {
                            boolean bl9 = bl8 = d > d5 || d < d4;
                        }
                        if (bl6) {
                            bl7 = false;
                        } else {
                            boolean bl10 = bl7 = d2 > d5 || d2 < d4;
                        }
                        if (!bl8 && !bl7) break block46;
                        bl3 = true;
                        tDGEventManager = this.m_Perspective.getEventManager();
                        tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3984, null);
                    }
                    catch (AssertionException assertionException) {
                        this.m_dataOK[n3][n6] = false;
                        continue;
                    }
                }
                if (this.isIgnoredOffScale(this.m_Y1Axis, d5)) {
                    this.m_dataOK[n3][n6] = false;
                    continue;
                }
                int n7 = (int)(bl4 ? relativeAxisObj.getValueCoord(d5) : relativeAxisObj.getValueCoord(d4));
                int n8 = (int)(bl4 ? relativeAxisObj.getValueCoord(d4) : relativeAxisObj.getValueCoord(d5));
                int n9 = n4 = (int)this.m_O1Axis.getCenterCoord(n5);
                int n10 = n4;
                int n11 = n7;
                int n12 = n8;
                if (n8 == n7) {
                    Rectangle rectangle = new Rectangle(n9 - this.m_Perspective.getVC().destToVirtWidth(2), n11, this.m_Perspective.getVC().destToVirtWidth(3), this.m_Perspective.getVC().destToVirtHeight(3));
                    new DetRect(this.m_Detectiv, new IdentObj(303, n3, n6), rectangle, blackBoxIF, null, 2);
                } else {
                    new DetLine(this.m_Detectiv, new IdentObj(303, n3, n6), n9, n11, n10, n12, blackBoxIF, this.m_rClip, 3);
                }
                if (this.m_bHasClose && !bl6) {
                    int n13 = (int)relativeAxisObj.getValueCoord(d2);
                    if (this.m_bCloseSplitDisplay) {
                        if (bl4) {
                            n7 = n13;
                        } else {
                            n8 = n13;
                        }
                        int n14 = (int)this.m_O1Axis.getLowCoord(0, n5);
                        int n15 = (int)this.m_O1Axis.getHighCoord(0, n5);
                        Rectangle rectangle = new Rectangle(n14, n7, n15 - n14, n8 - n7);
                        IdentObj identObj5 = new IdentObj(306, n3, n6, -3, 1);
                        BlackBoxObj blackBoxObj3 = new BlackBoxObj(this.m_Perspective, identObj5);
                        new DetRect(this.m_Detectiv, identObj5, rectangle, (BlackBoxIF)blackBoxObj3, this.m_rClip);
                    }
                    if (this.m_bCloseTicksDisplay) {
                        n9 = n4;
                        n11 = n13;
                        n10 = n4 + this.m_Perspective.getVC().destToVirtWidth(6);
                        n12 = n11;
                        identObj4 = new IdentObj(identObj.getObjectID(), n3, n6);
                        new DetLine(this.m_Detectiv, identObj4, n9, n11, n10, n12, blackBoxIF, this.m_rClip, 3);
                    }
                }
                if (this.m_bHasOpen && this.m_bOpenTicksDisplay && !bl5) {
                    n9 = n4 - this.m_Perspective.getVC().destToVirtWidth(5);
                    n11 = (int)relativeAxisObj.getValueCoord(d);
                    n10 = n4;
                    n12 = n11;
                    identObj4 = new IdentObj(identObj2.getObjectID(), n3, n6);
                    new DetLine(this.m_Detectiv, identObj4, n9, n11, n10, n12, blackBoxIF, this.m_rClip, 3);
                }
                if (this.m_bDataTextDisplay) {
                    if (this.m_bHasOpen && !bl5) {
                        if (bl) {
                            this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n6, "OPEN", -1, -3);
                            stringArray[0] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                        } else {
                            stringArray[0] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string2);
                        }
                    }
                    if (bl) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n6, "HIGH", -1, -3);
                        stringArray[1] = this.m_Perspective.getNumberFormatCallBack().toString(d5);
                    } else {
                        stringArray[1] = TDGNumberFormat.toString(this.m_Perspective, n2, d5, string2);
                    }
                    if (bl) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n6, "LOW", -1, -3);
                        stringArray[2] = this.m_Perspective.getNumberFormatCallBack().toString(d4);
                    } else {
                        stringArray[2] = TDGNumberFormat.toString(this.m_Perspective, n2, d4, string2);
                    }
                    if (this.m_bHasClose && !bl6) {
                        if (bl) {
                            this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n6, "CLOSE", -1, -3);
                            stringArray[3] = this.m_Perspective.getNumberFormatCallBack().toString(d2);
                        } else {
                            stringArray[3] = TDGNumberFormat.toString(this.m_Perspective, n2, d2, string2);
                        }
                    }
                    if (bl6) {
                        this.m_DataLabel[n3][n6] = null;
                    } else {
                        if (string == null || string.length() < 1) {
                            string = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                        }
                        this.m_DataLabel[n3][n6] = this.processDataTextTemplate(stringArray, string);
                    }
                    if (this.m_bHasVolume) {
                        if (bl) {
                            this.m_Perspective.getNumberFormatCallBack().setState(5, n3, n6, "VOLUME", -1, -3);
                            this.m_VolumeDataLabel[n6] = this.m_Perspective.getNumberFormatCallBack().toString(d3);
                        } else {
                            this.m_VolumeDataLabel[n6] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), d3, this.m_Perspective.getDataTextFormatPattern());
                        }
                    }
                }
                if (!this.m_bHasVolume) continue;
                this.calcVolumeBar(n6, d3);
            }
        }
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        string2 = this.ReplaceMacro(string2, "[OPEN]", stringArray[0]);
        string2 = this.ReplaceMacro(string2, "[HIGH]", stringArray[1]);
        string2 = this.ReplaceMacro(string2, "[LOW]", stringArray[2]);
        string2 = this.ReplaceMacro(string2, "[CLOSE]", stringArray[3]);
        return string2;
    }

    protected MinMaxObj findLimits(int n, boolean bl) {
        int n2 = this.m_gt.getScalingMethod();
        MinMaxObj minMaxObj = this.findPreScaledLimits(n, n2, bl);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bl);
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n3 = dataFormat.getNumDataItems();
        if (n2 == 1) {
            if (this.m_Perspective.getStock52WeekHighDisplay() && !this.m_gt.isBipolar()) {
                double d = this.m_Perspective.getStock52WeekHighValue();
                minMaxObj.testRawValue(d);
            }
            if (this.m_Perspective.getStock52WeekLowDisplay() && !this.m_gt.isBipolar()) {
                double d = this.m_Perspective.getStock52WeekLowValue();
                minMaxObj.testRawValue(d);
            }
            int n4 = 0;
            while (n4 < this.m_nTotalSeries) {
                if (n != 0 && n != 1 || this.getAxisAssignment(n4) == n) {
                    if (n == 1) {
                        this.m_dualY = true;
                    }
                    int n5 = 0;
                    while (n5 < this.m_nTotalGroups) {
                        int n6 = 0;
                        while (n6 < n3) {
                            DataItem dataItem = dataFormat.getDataItem(n6);
                            if (!dataItem.ignoreInScaling() && AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) {
                                DatumObj datumObj = this.getDataValue(n4, n5, dataItem);
                                double d = datumObj.m_fValue;
                                if (d == 0.0 && !datumObj.m_bOK) {
                                    if (n == 0) {
                                        this.m_nullValY1 = true;
                                    } else if (n == 1) {
                                        this.m_nullValY2 = true;
                                    }
                                }
                                if (d <= 0.0 && this.isBadValueInLogscale(n, d)) {
                                    if (n == 0) {
                                        if (d == 0.0 && datumObj.m_bOK) {
                                            this.m_zeroValY1 = true;
                                        } else if (d == 0.0 && !datumObj.m_bOK) {
                                            this.m_nullValY1 = true;
                                        } else {
                                            this.m_negativeValY1 = true;
                                        }
                                    } else if (n == 1) {
                                        if (d == 0.0 && datumObj.m_bOK) {
                                            this.m_zeroValY2 = true;
                                        } else if (d == 0.0 && !datumObj.m_bOK) {
                                            this.m_nullValY2 = true;
                                        } else {
                                            this.m_negativeValY2 = true;
                                        }
                                    }
                                } else if (n == 0) {
                                    this.m_positiveValY1 = true;
                                } else if (n == 1) {
                                    this.m_positiveValY2 = true;
                                }
                                if (datumObj.m_bOK) {
                                    minMaxObj.testRawValue(d);
                                }
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
        } else {
            throw new AssertionException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    protected MinMaxObj findVolumeLimits(boolean bl) {
        MinMaxObj minMaxObj = new MinMaxObj(bl);
        int n = this.m_gt.getScalingMethod();
        if (n == 1) {
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            int n2 = seriesEnumerator.getFirstSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            int n3 = 0;
            while (n3 < this.m_nTotalGroups) {
                block5: {
                    double d;
                    try {
                        d = this.getVolumeValue(n2, n3);
                    }
                    catch (AssertionException assertionException) {
                        break block5;
                    }
                    minMaxObj.testRawValue(d);
                }
                ++n3;
            }
        } else {
            throw new AssertionException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    private DataItem getCloseItem() {
        DataItem dataItem;
        if (this.m_df == DataFormat.DF_HLC) {
            dataItem = DataItem.DI_HLC_C;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            dataItem = DataItem.DI_HLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            dataItem = DataItem.DI_OHLC_C;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            dataItem = DataItem.DI_OHLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OC) {
            dataItem = DataItem.DI_OC_C;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            dataItem = DataItem.DI_OC_VOL_C;
        } else {
            throw new AssertionException(String.valueOf(String.valueOf("getCloseItem used with wrong dataFormat: ")) + this.m_df.toString());
        }
        return dataItem;
    }

    public double getCloseValue(int n, int n2) throws AssertionException {
        DataItem dataItem = this.getCloseItem();
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    protected Point getCoords(int n, int n2) {
        int n3;
        RelativeAxisObj relativeAxisObj = this.getAxisAssignment(n) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        boolean bl = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int n4 = this.m_gEnumReadOnly.getRelativeGroup(n2);
        PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nGroups);
        int n5 = (int)this.m_O1Axis.getCenterCoord(n4);
        try {
            if (bl) {
                n3 = (int)relativeAxisObj.getValueCoord(this.getHighValue(n, n2));
            } else {
                double d = this.getCloseValue(n, n2);
                double d2 = this.getOpenValue(n, n2);
                n3 = (int)relativeAxisObj.getValueCoord(Math.max(d, d2));
            }
        }
        catch (Exception exception) {
            n3 = 0;
        }
        Point point = this.m_bHorz ? new Point(n3, n5) : new Point(n5, n3);
        return point;
    }

    protected Point getBottomCoords(int n, int n2) {
        int n3;
        RelativeAxisObj relativeAxisObj = this.getAxisAssignment(n) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        boolean bl = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int n4 = this.m_gEnumReadOnly.getRelativeGroup(n2);
        PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nGroups);
        int n5 = (int)this.m_O1Axis.getCenterCoord(n4);
        try {
            if (bl) {
                n3 = (int)relativeAxisObj.getValueCoord(this.getLowValue(n, n2));
            } else {
                double d = this.getCloseValue(n, n2);
                double d2 = this.getOpenValue(n, n2);
                n3 = (int)relativeAxisObj.getValueCoord(Math.min(d, d2));
            }
        }
        catch (Exception exception) {
            n3 = 0;
        }
        Point point = this.m_bHorz ? new Point(n3, n5) : new Point(n5, n3);
        return point;
    }

    private DataItem getHighItem() {
        DataItem dataItem;
        if (this.m_df == DataFormat.DF_HL) {
            dataItem = DataItem.DI_HL_H;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            dataItem = DataItem.DI_HL_VOL_H;
        } else if (this.m_df == DataFormat.DF_HLC) {
            dataItem = DataItem.DI_HLC_H;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            dataItem = DataItem.DI_HLC_VOL_H;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            dataItem = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_H : DataItem.DI_OHLC_H;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            dataItem = DataItem.DI_OHLC_VOL_H;
        } else {
            throw new AssertionException(String.valueOf(String.valueOf("getHighItem used with wrong dataFormat: ")) + this.m_df.toString());
        }
        return dataItem;
    }

    public double getHighValue(int n, int n2) throws AssertionException {
        DataItem dataItem = this.getHighItem();
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getLowItem() {
        DataItem dataItem;
        if (this.m_df == DataFormat.DF_HL) {
            dataItem = DataItem.DI_HL_L;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            dataItem = DataItem.DI_HL_VOL_L;
        } else if (this.m_df == DataFormat.DF_HLC) {
            dataItem = DataItem.DI_HLC_L;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            dataItem = DataItem.DI_HLC_VOL_L;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            dataItem = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_L : DataItem.DI_OHLC_L;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            dataItem = DataItem.DI_OHLC_VOL_L;
        } else {
            throw new AssertionException(String.valueOf(String.valueOf("getLowItem used with wrong dataFormat: ")) + this.m_df.toString());
        }
        return dataItem;
    }

    public double getLowValue(int n, int n2) throws AssertionException {
        DataItem dataItem = this.getLowItem();
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getOpenItem() {
        DataItem dataItem;
        if (this.m_df == DataFormat.DF_OHLC) {
            dataItem = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_O : DataItem.DI_OHLC_O;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            dataItem = DataItem.DI_OHLC_VOL_O;
        } else if (this.m_df == DataFormat.DF_OC) {
            dataItem = DataItem.DI_OC_O;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            dataItem = DataItem.DI_OC_VOL_O;
        } else {
            throw new AssertionException(String.valueOf(String.valueOf("getOpenItem used with wrong dataFormat: ")) + this.m_df.toString());
        }
        return dataItem;
    }

    public double getOpenValue(int n, int n2) throws AssertionException {
        DataItem dataItem = this.getOpenItem();
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getVolumeItem() {
        DataItem dataItem;
        if (this.m_df == DataFormat.DF_HL_VOL) {
            dataItem = DataItem.DI_HL_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            dataItem = DataItem.DI_HLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            dataItem = DataItem.DI_OHLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            dataItem = DataItem.DI_OC_VOL_VOL;
        } else {
            throw new AssertionException(String.valueOf(String.valueOf("getVolumeItem used with wrong dataFormat: ")) + this.m_df.toString());
        }
        return dataItem;
    }

    public double getVolumeValue(int n, int n2) throws AssertionException {
        DataItem dataItem = this.getVolumeItem();
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public boolean isSingleSeriesOnly() {
        boolean bl = false;
        if (this.m_gt.isStockCandleType()) {
            bl = true;
        }
        if (this.m_bHasVolume) {
            bl = true;
        }
        return bl;
    }

    public boolean wantLegend() {
        boolean bl = true;
        if (this.m_gt.isStockCandleType()) {
            bl = false;
        }
        return bl;
    }

    public boolean hasHighValue(DataFormat dataFormat) {
        boolean bl = dataFormat == DataFormat.DF_HL || dataFormat == DataFormat.DF_HLC || dataFormat == DataFormat.DF_OHLC || dataFormat == DataFormat.DF_HL_VOL || dataFormat == DataFormat.DF_HLC_VOL || dataFormat == DataFormat.DF_OHLC_VOL;
        return bl;
    }

    public boolean hasLowValue(DataFormat dataFormat) {
        boolean bl = dataFormat == DataFormat.DF_HL || dataFormat == DataFormat.DF_HLC || dataFormat == DataFormat.DF_OHLC || dataFormat == DataFormat.DF_HL_VOL || dataFormat == DataFormat.DF_HLC_VOL || dataFormat == DataFormat.DF_OHLC_VOL;
        return bl;
    }

    public boolean hasOpenValue(DataFormat dataFormat) {
        boolean bl = dataFormat == DataFormat.DF_OHLC || dataFormat == DataFormat.DF_OHLC_VOL || dataFormat == DataFormat.DF_OC || dataFormat == DataFormat.DF_OC_VOL;
        return bl;
    }

    public boolean hasCloseValue(DataFormat dataFormat) {
        boolean bl = dataFormat == DataFormat.DF_HLC || dataFormat == DataFormat.DF_OHLC || dataFormat == DataFormat.DF_HLC_VOL || dataFormat == DataFormat.DF_OHLC_VOL || dataFormat == DataFormat.DF_OC || dataFormat == DataFormat.DF_OC_VOL;
        return bl;
    }

    public boolean hasVolumeValue(DataFormat dataFormat) {
        boolean bl = dataFormat == DataFormat.DF_HL_VOL || dataFormat == DataFormat.DF_HLC_VOL || dataFormat == DataFormat.DF_OHLC_VOL || dataFormat == DataFormat.DF_OC_VOL;
        return bl;
    }
}

