/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Spec;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ZoomState;

public class ChartFrameZoom
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_Base m_Chart;

    public ChartFrameZoom(Perspective perspective, JChart_Base jChart_Base) {
        this.m_Perspective = perspective;
        this.m_Chart = jChart_Base;
    }

    public void doZoomIn(ZoomState zoomState, Rectangle rectangle) {
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.m_Perspective.getEffectiveViewableGroups();
        int n2 = this.m_Perspective.getEffectiveViewableSeries();
        int n3 = this.m_Perspective.getEffectiveGroupOffset();
        int n4 = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Chart != null && this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Scat) {
            int n5;
            int n6;
            JChart_2D_Standard jChart_2D_Standard = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor axisDescriptor = jGraphType.getAxisDescriptor();
            if (jChart_2D_Standard.m_X1Axis != null) {
                if (jGraphType.isOrientHorz()) {
                    n6 = rectangle.y;
                    n5 = rectangle.y + rectangle.height;
                } else {
                    n6 = rectangle.x;
                    n5 = rectangle.x + rectangle.width;
                }
                d = (double)n6 <= jChart_2D_Standard.m_X1Axis.getMinCoord() ? jChart_2D_Standard.m_X1Axis.getMinValue() : jChart_2D_Standard.m_X1Axis.getValueFromCoord(n6);
                d4 = (double)n5 >= jChart_2D_Standard.m_X1Axis.getMaxCoord() ? jChart_2D_Standard.m_X1Axis.getMaxValue() : jChart_2D_Standard.m_X1Axis.getValueFromCoord(n5);
            }
            if (jGraphType.isOrientHorz()) {
                n6 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
            } else {
                n6 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
            }
            if (jChart_2D_Standard.m_Y1Axis != null) {
                d2 = (double)n6 <= jChart_2D_Standard.m_Y1Axis.getMinCoord() ? jChart_2D_Standard.m_Y1Axis.getMinValue() : jChart_2D_Standard.m_Y1Axis.getValueFromCoord(n6);
                d5 = (double)n5 <= jChart_2D_Standard.m_Y1Axis.getMinCoord() ? jChart_2D_Standard.m_Y1Axis.getMinValue() : ((double)n5 >= jChart_2D_Standard.m_Y1Axis.getMaxCoord() ? jChart_2D_Standard.m_Y1Axis.getMaxValue() : jChart_2D_Standard.m_Y1Axis.getValueFromCoord(n5));
            }
            if (jChart_2D_Standard.m_Y2Axis != null) {
                d3 = (double)n6 <= jChart_2D_Standard.m_Y2Axis.getMinCoord() ? jChart_2D_Standard.m_Y2Axis.getMinValue() : jChart_2D_Standard.m_Y2Axis.getValueFromCoord(n6);
                d6 = (double)n5 <= jChart_2D_Standard.m_Y2Axis.getMinCoord() ? jChart_2D_Standard.m_Y2Axis.getMinValue() : ((double)n5 >= jChart_2D_Standard.m_Y2Axis.getMaxCoord() ? jChart_2D_Standard.m_Y2Axis.getMaxValue() : jChart_2D_Standard.m_Y2Axis.getValueFromCoord(n5));
            }
            if (jChart_2D_Standard.m_O1Axis != null) {
                int n7;
                int n8;
                if (jGraphType.isOrientHorz()) {
                    n8 = jChart_2D_Standard.m_O1Axis.getGroupBelowCoord(rectangle.y + rectangle.height);
                    n7 = jChart_2D_Standard.m_O1Axis.getGroupAboveCoord(rectangle.y);
                } else {
                    n8 = jChart_2D_Standard.m_O1Axis.getGroupAboveCoord(rectangle.x);
                    n7 = jChart_2D_Standard.m_O1Axis.getGroupBelowCoord(rectangle.x + rectangle.width);
                }
                if ((n7 += n3) < (n8 += n3)) {
                    n7 = n8;
                }
                n = n7 - n8 + 1;
                n3 = n8;
                this.m_Perspective.setViewableGroups(n);
                this.m_Perspective.setScrollOffsetGroup(n3);
            }
            if (jChart_2D_Standard instanceof JChart_2D_Spec) {
                JChart_2D_Spec jChart_2D_Spec = (JChart_2D_Spec)jChart_2D_Standard;
                if (jChart_2D_Spec.m_O2Axis != null) {
                    int n9 = jChart_2D_Spec.m_O2Axis.getGroupAboveCoord(rectangle.y);
                    int n10 = jChart_2D_Spec.m_O2Axis.getGroupBelowCoord(rectangle.y + rectangle.height);
                    if ((n10 += n4) < (n9 += n4)) {
                        n10 = n9;
                    }
                    n2 = n10 - n9 + 1;
                    n4 = n9;
                    this.m_Perspective.setViewableSeries(n2);
                    this.m_Perspective.setScrollOffsetSeries(n4);
                }
            }
            zoomState.ChartFrame(d, d4, d2, d5, d3, d6, n, n3, n2, n4, axisDescriptor);
        }
    }

    public void doZoomOut(ZoomState zoomState, int n, int n2) {
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        Rectangle rectangle = this.m_Perspective.getFrameRect(false);
        double d = this.m_Perspective.getZoomPercentage();
        PfjAssert.pfjAssert(d >= (double)20 && d <= (double)100);
        int n3 = (int)((double)rectangle.width * 100.0 / d);
        int n4 = (int)((double)rectangle.height * 100.0 / d);
        int n5 = n - n3 / 2;
        int n6 = n2 - n4 / 2;
        Rectangle rectangle2 = new Rectangle(n5, n6, n3, n4);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n7 = this.m_Perspective.getEffectiveViewableGroups();
        int n8 = this.m_Perspective.getEffectiveViewableSeries();
        int n9 = this.m_Perspective.getEffectiveGroupOffset();
        int n10 = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Chart != null && this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Scat) {
            int n11;
            int n12;
            JChart_2D_Standard jChart_2D_Standard = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor axisDescriptor = jGraphType.getAxisDescriptor();
            if (jChart_2D_Standard.m_X1Axis != null) {
                if (jGraphType.isOrientHorz()) {
                    n12 = rectangle2.y;
                    n11 = rectangle2.y + rectangle2.height;
                } else {
                    n12 = rectangle2.x;
                    n11 = rectangle2.x + rectangle2.width;
                }
                d2 = (double)n12 <= jChart_2D_Standard.m_X1Axis.getMinCoord() ? jChart_2D_Standard.m_X1Axis.getMinValue() : jChart_2D_Standard.m_X1Axis.getValueFromCoord(n12);
                d5 = (double)n11 >= jChart_2D_Standard.m_X1Axis.getMaxCoord() ? jChart_2D_Standard.m_X1Axis.getMaxValue() : jChart_2D_Standard.m_X1Axis.getValueFromCoord(n11);
            }
            if (jGraphType.isOrientHorz()) {
                n12 = rectangle2.x;
                n11 = rectangle2.x + rectangle2.width;
            } else {
                n12 = rectangle2.y;
                n11 = rectangle2.y + rectangle2.height;
            }
            if (jChart_2D_Standard.m_Y1Axis != null) {
                d3 = (double)n12 <= jChart_2D_Standard.m_Y1Axis.getMinCoord() ? jChart_2D_Standard.m_Y1Axis.getMinValue() : jChart_2D_Standard.m_Y1Axis.getValueFromCoord(n12);
                d6 = (double)n11 >= jChart_2D_Standard.m_Y1Axis.getMaxCoord() ? jChart_2D_Standard.m_Y1Axis.getMaxValue() : jChart_2D_Standard.m_Y1Axis.getValueFromCoord(n11);
            }
            if (jChart_2D_Standard.m_Y2Axis != null) {
                d4 = (double)rectangle2.y <= jChart_2D_Standard.m_Y2Axis.getMinCoord() ? jChart_2D_Standard.m_Y2Axis.getMinValue() : jChart_2D_Standard.m_Y2Axis.getValueFromCoord(n12);
                d7 = (double)n11 >= jChart_2D_Standard.m_Y2Axis.getMaxCoord() ? jChart_2D_Standard.m_Y2Axis.getMaxValue() : jChart_2D_Standard.m_Y2Axis.getValueFromCoord(n11);
            }
            if (jChart_2D_Standard.m_O1Axis != null) {
                int n13;
                int n14;
                if (jGraphType.isOrientHorz()) {
                    n14 = jChart_2D_Standard.m_O1Axis.getGroupAboveCoord(rectangle2.y);
                    n13 = jChart_2D_Standard.m_O1Axis.getGroupBelowCoord(rectangle2.y + rectangle2.height);
                } else {
                    n14 = jChart_2D_Standard.m_O1Axis.getGroupAboveCoord(rectangle2.x);
                    n13 = jChart_2D_Standard.m_O1Axis.getGroupBelowCoord(rectangle2.x + rectangle2.width);
                }
                if ((n13 += n9) < (n14 += n9)) {
                    n13 = n14;
                }
                n7 = n13 - n14 + 1;
                n9 = n14;
                this.m_Perspective.setViewableGroups(n7);
                this.m_Perspective.setScrollOffsetGroup(n9);
            }
            if (jChart_2D_Standard instanceof JChart_2D_Spec) {
                JChart_2D_Spec jChart_2D_Spec = (JChart_2D_Spec)jChart_2D_Standard;
                if (jChart_2D_Spec.m_O2Axis != null) {
                    int n15 = jChart_2D_Spec.m_O2Axis.getGroupAboveCoord(rectangle2.y);
                    int n16 = jChart_2D_Spec.m_O2Axis.getGroupBelowCoord(rectangle2.y + rectangle2.height);
                    if ((n16 += n10) < (n15 += n10)) {
                        n16 = n15;
                    }
                    n8 = n16 - n15 + 1;
                    n10 = n15;
                    this.m_Perspective.setViewableSeries(n8);
                    this.m_Perspective.setScrollOffsetSeries(n10);
                }
            }
            zoomState.ChartFrame(d2, d5, d3, d6, d4, d7, n7, n9, n8, n10, axisDescriptor);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

