/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UISeries;
import oracle.dss.graph.gui.UIGraphAdapter;
import oracle.dss.util.SeriesOutOfRangeException;

public class UISeriesAdapter
implements UISeries {
    private UIGraphAdapter m_UIGraphAdapter;
    private Color[] colors;
    private int[] markerType;
    private int[] markerShape;
    private int[] lineWidth;
    private int[] lineStyle;
    private boolean[] assigned;
    private int[] fitlineType;
    private int m_seriesCount;
    private int markerShapeAfterSix;
    private int bubbleMarkerShape;
    private int defaultMarkerType;
    private int[] defaultColor;
    private int defaultMarkerShape;
    private int defaultLineWidth;
    private int defaultLineStyle;
    private boolean assignedToY2All;
    private boolean assignedToY2For1;
    private int defaultFitlineType;
    private Color defaultSeriesColor;
    private int defaultSeriesMarkerType;
    private int defaultSeriesMarkerShape;
    private int defaultSeriesLineWidth;
    private int defaultSeriesAssigned;
    private int defaultSeriesFitlineType;
    private boolean[] colorChanged;
    private boolean[] markerTypeChanged;
    private boolean[] markerShapeChanged;
    private boolean[] lineWidthChanged;
    private boolean[] lineStyleChanged;
    private boolean[] assignedChanged;
    private boolean[] fitlineTypeChanged;
    private boolean defaultColorChanged;
    private boolean defaultMarkerTypeChanged;
    private boolean defaultMarkerShapeChanged;
    private boolean defaultLineWidthChanged;
    private boolean defaultAssignedChanged;
    private boolean defaultFitlineTypeChanged;

    public UISeriesAdapter(UIGraphAdapter uIGraphAdapter) {
        this.m_UIGraphAdapter = uIGraphAdapter;
        this.init();
    }

    private void init() {
        this.defaultSeriesColor = GraphDefaultValues.getSeriesDefaultColor() == "" ? null : new Color(Integer.parseInt(GraphDefaultValues.getSeriesDefaultColor().substring(1), 16));
        this.defaultSeriesMarkerType = GraphDefaultValues.getSeriesDefaultMarkerType();
        this.defaultSeriesMarkerShape = GraphDefaultValues.getSeriesDefaultMarkerShape();
        this.defaultSeriesLineWidth = GraphDefaultValues.getSeriesDefaultLineWidth();
        this.defaultSeriesAssigned = GraphDefaultValues.getSeriesDefaultAssignedToY2();
        this.defaultSeriesFitlineType = GraphDefaultValues.getSeriesDefaultFitlineType();
        this.bubbleMarkerShape = GraphDefaultValues.getBubbleMarkerShape();
        this.defaultMarkerType = GraphDefaultValues.getDefaultSeriesMarkerType();
        this.defaultColor = GraphDefaultValues.getDefaultSeriesColor();
        this.defaultMarkerShape = GraphDefaultValues.getDefaultSeriesMarkerShape();
        this.defaultLineWidth = GraphDefaultValues.getSeriesDefaultLineWidth();
        this.defaultLineStyle = GraphDefaultValues.getSeriesDefaultLineStyle();
        this.assignedToY2All = GraphDefaultValues.isAssignedToY2All();
        this.assignedToY2For1 = GraphDefaultValues.isAssignedToY2For1();
        this.defaultFitlineType = GraphDefaultValues.getDefaultSeriesFitlineType();
        this.m_seriesCount = this.m_UIGraphAdapter.getSeriesObjectCount();
        this.colors = new Color[this.m_seriesCount];
        this.markerType = new int[this.m_seriesCount];
        this.markerShape = new int[this.m_seriesCount];
        this.lineWidth = new int[this.m_seriesCount];
        this.lineStyle = new int[this.m_seriesCount];
        this.assigned = new boolean[this.m_seriesCount];
        this.fitlineType = new int[this.m_seriesCount];
        this.colorChanged = new boolean[this.m_seriesCount];
        this.markerTypeChanged = new boolean[this.m_seriesCount];
        this.markerShapeChanged = new boolean[this.m_seriesCount];
        this.lineWidthChanged = new boolean[this.m_seriesCount];
        this.lineStyleChanged = new boolean[this.m_seriesCount];
        this.assignedChanged = new boolean[this.m_seriesCount];
        this.fitlineTypeChanged = new boolean[this.m_seriesCount];
        int n = 0;
        while (n < this.m_seriesCount) {
            this.colors[n] = new Color(this.defaultColor[n % 30]);
            this.colorChanged[n] = false;
            this.markerType[n] = this.defaultMarkerType;
            this.markerTypeChanged[n] = false;
            this.markerShape[n] = this.defaultMarkerShape;
            this.markerShapeChanged[n] = false;
            this.lineWidth[n] = this.defaultLineWidth;
            this.lineWidthChanged[n] = false;
            this.lineStyle[n] = this.defaultLineStyle;
            this.lineStyleChanged[n] = false;
            this.assigned[n] = n == 1 ? this.assignedToY2For1 : this.assignedToY2All;
            this.assignedChanged[n] = false;
            this.fitlineType[n] = this.defaultFitlineType;
            this.fitlineTypeChanged[n] = false;
            ++n;
        }
    }

    public void setColor(Color color, int n) throws SeriesOutOfRangeException {
        this.setColorChanged(true, n);
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.colors[n] = color;
    }

    public Color getColor(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.colors[n];
    }

    public void setColorChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.colorChanged[n] = bl;
    }

    public boolean isColorChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.colorChanged[n];
    }

    public void setMarkerType(int n, int n2) throws SeriesOutOfRangeException {
        this.setMarkerTypeChanged(true, n2);
        if (n2 >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n2, this.m_seriesCount);
        }
        this.markerType[n2] = n;
    }

    public int getMarkerType(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.markerType[n];
    }

    public void setMarkerTypeChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.markerTypeChanged[n] = bl;
    }

    public boolean isMarkerTypeChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.markerTypeChanged[n];
    }

    public void setMarkerShape(int n, int n2) throws SeriesOutOfRangeException {
        this.setMarkerShapeChanged(true, n2);
        if (n2 >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n2, this.m_seriesCount);
        }
        this.markerShape[n2] = n;
    }

    public int getMarkerShape(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.markerShape[n];
    }

    public void setMarkerShapeChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.markerShapeChanged[n] = bl;
    }

    public boolean isMarkerShapeChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.markerShapeChanged[n];
    }

    public void setLineWidth(int n, int n2) throws SeriesOutOfRangeException {
        this.setLineWidthChanged(true, n2);
        if (n2 >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n2, this.m_seriesCount);
        }
        this.lineWidth[n2] = n;
    }

    public int getLineWidth(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.lineWidth[n];
    }

    public void setLineWidthChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.lineWidthChanged[n] = bl;
    }

    public boolean isLineWidthChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.lineWidthChanged[n];
    }

    public void setLineStyle(int n, int n2) throws SeriesOutOfRangeException {
        this.setLineStyleChanged(true, n2);
        if (n2 >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n2, this.m_seriesCount);
        }
        this.lineStyle[n2] = n;
    }

    public int getLineStyle(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.lineStyle[n];
    }

    public void setLineStyleChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.lineStyleChanged[n] = bl;
    }

    public boolean isLineStyleChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.lineStyleChanged[n];
    }

    public void setAssignedToY2(boolean bl, int n) throws SeriesOutOfRangeException {
        this.setAssignedToY2Changed(true, n);
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.assigned[n] = bl;
    }

    public boolean isAssignedToY2(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.assigned[n];
    }

    public void setAssignedToY2Changed(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.assignedChanged[n] = bl;
    }

    public boolean isAssignedToY2Changed(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.assignedChanged[n];
    }

    public void setFitlineType(int n, int n2) throws SeriesOutOfRangeException {
        this.setFitlineTypeChanged(true, n2);
        if (n2 >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n2, this.m_seriesCount);
        }
        this.fitlineType[n2] = n;
    }

    public int getFitlineType(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.fitlineType[n];
    }

    public void setFitlineTypeChanged(boolean bl, int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        this.fitlineTypeChanged[n] = bl;
    }

    public boolean isFitlineTypeChanged(int n) throws SeriesOutOfRangeException {
        if (n >= this.m_seriesCount) {
            throw new SeriesOutOfRangeException(n, this.m_seriesCount);
        }
        return this.fitlineTypeChanged[n];
    }

    public void setDefaultColor(Color color) {
        this.setDefaultColorChanged(true);
        this.defaultSeriesColor = color;
    }

    public Color getDefaultColor() {
        return this.defaultSeriesColor;
    }

    public void setDefaultColorChanged(boolean bl) {
        this.defaultColorChanged = bl;
    }

    public boolean isDefaultColorChanged() {
        return this.defaultColorChanged;
    }

    public void setDefaultMarkerType(int n) {
        this.setDefaultMarkerTypeChanged(true);
        this.defaultSeriesMarkerType = n;
        try {
            int n2 = 0;
            while (n2 < this.m_UIGraphAdapter.getSeriesObjectCount()) {
                this.setMarkerType(n, n2);
                ++n2;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
    }

    public int getDefaultMarkerType() {
        return this.defaultSeriesMarkerType;
    }

    public void setDefaultMarkerTypeChanged(boolean bl) {
        this.defaultMarkerTypeChanged = bl;
    }

    public boolean isDefaultMarkerTypeChanged() {
        return this.defaultMarkerTypeChanged;
    }

    public void setDefaultMarkerShape(int n) {
        this.setDefaultMarkerShapeChanged(true);
        this.defaultSeriesMarkerShape = n;
    }

    public int getDefaultMarkerShape() {
        return this.defaultSeriesMarkerShape;
    }

    public void setDefaultMarkerShapeChanged(boolean bl) {
        this.defaultMarkerShapeChanged = bl;
    }

    public boolean isDefaultMarkerShapeChanged() {
        return this.defaultMarkerShapeChanged;
    }

    public void setDefaultLineWidth(int n) {
        this.setDefaultLineWidthChanged(true);
        this.defaultSeriesLineWidth = n;
    }

    public int getDefaultLineWidth() {
        return this.defaultSeriesLineWidth;
    }

    public void setDefaultLineWidthChanged(boolean bl) {
        this.defaultLineWidthChanged = bl;
    }

    public boolean isDefaultLineWidthChanged() {
        return this.defaultLineWidthChanged;
    }

    public void setDefaultAssignedToY2(int n) {
        this.setDefaultAssignedToY2Changed(true);
        this.defaultSeriesAssigned = n;
    }

    public int getDefaultAssignedToY2() {
        return this.defaultSeriesAssigned;
    }

    public void setDefaultAssignedToY2Changed(boolean bl) {
        this.defaultAssignedChanged = bl;
    }

    public boolean isDefaultAssignedToY2Changed() {
        return this.defaultAssignedChanged;
    }

    public void setDefaultFitlineType(int n) {
        this.setDefaultFitlineTypeChanged(true);
        this.defaultSeriesFitlineType = n;
    }

    public int getDefaultFitlineType() {
        return this.defaultSeriesFitlineType;
    }

    public void setDefaultFitlineTypeChanged(boolean bl) {
        this.defaultFitlineTypeChanged = bl;
    }

    public boolean isDefaultFitlineTypeChanged() {
        return this.defaultFitlineTypeChanged;
    }

    protected void cleanUp() {
        this.m_UIGraphAdapter = null;
        this.defaultSeriesColor = null;
        if (this.colors != null) {
            int n = 0;
            while (n < this.colors.length) {
                this.colors[n] = null;
                ++n;
            }
        }
        this.colors = null;
        this.markerType = null;
        this.markerShape = null;
        this.lineWidth = null;
        this.assigned = null;
        this.fitlineType = null;
        this.defaultColor = null;
        this.colorChanged = null;
        this.markerTypeChanged = null;
        this.markerShapeChanged = null;
        this.lineWidthChanged = null;
        this.assignedChanged = null;
        this.fitlineTypeChanged = null;
    }

    protected void setSeriesObjectCount(int n) {
        if (n <= this.m_seriesCount) {
            return;
        }
        Color[] colorArray = new Color[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean[] blArray = new boolean[n];
        int[] nArray4 = new int[n];
        boolean[] blArray2 = new boolean[n];
        boolean[] blArray3 = new boolean[n];
        boolean[] blArray4 = new boolean[n];
        boolean[] blArray5 = new boolean[n];
        boolean[] blArray6 = new boolean[n];
        boolean[] blArray7 = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            if (n2 < this.m_seriesCount) {
                colorArray[n2] = this.colors[n2];
                nArray3[n2] = this.lineWidth[n2];
                nArray[n2] = this.markerType[n2];
                nArray2[n2] = this.markerShape[n2];
                nArray4[n2] = this.fitlineType[n2];
                blArray[n2] = this.assigned[n2];
                blArray2[n2] = this.colorChanged[n2];
                blArray3[n2] = this.markerTypeChanged[n2];
                blArray4[n2] = this.markerShapeChanged[n2];
                blArray5[n2] = this.lineWidthChanged[n2];
                blArray6[n2] = this.assignedChanged[n2];
                blArray7[n2] = this.fitlineTypeChanged[n2];
            } else {
                colorArray[n2] = new Color(this.defaultColor[n2 % 30]);
                blArray2[n2] = false;
                nArray[n2] = this.defaultMarkerType;
                blArray3[n2] = false;
                nArray2[n2] = this.defaultMarkerShape;
                blArray4[n2] = false;
                nArray3[n2] = this.defaultLineWidth;
                blArray5[n2] = false;
                blArray[n2] = n2 == 1 ? this.assignedToY2For1 : this.assignedToY2All;
                blArray6[n2] = false;
                nArray4[n2] = this.defaultFitlineType;
                blArray7[n2] = false;
            }
            ++n2;
        }
        this.m_seriesCount = n;
        this.colors = colorArray;
        this.markerType = nArray;
        this.markerShape = nArray2;
        this.lineWidth = nArray3;
        this.assigned = blArray;
        this.fitlineType = nArray4;
        this.colorChanged = blArray2;
        this.markerTypeChanged = blArray3;
        this.markerShapeChanged = blArray4;
        this.lineWidthChanged = blArray5;
        this.assignedChanged = blArray6;
        this.fitlineTypeChanged = blArray7;
    }
}

