/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.graphics.ImageUtils;

public class LineWidth
extends JComboBox {
    private ResourceBundle rBundle;
    private Filter _filter = new Filter();
    private KeyListener m_keyListener;
    protected Color m_cellColor;
    protected Color m_background;

    public LineWidth() {
        this.updateResourceBundle(null);
        this.m_background = this.m_cellColor = this.getBackground();
        int n = 1;
        while (n < 7) {
            this.addItem(new Integer(n).toString());
            ++n;
        }
        this.setMaximumRowCount(6);
        CellRenderer cellRenderer = new CellRenderer();
        this.setRenderer(cellRenderer);
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.getAccessibleContext().setAccessibleName(this.rBundle.getString("Line width"));
        this.setPreferredSize(new Dimension(110, 25));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.m_keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LineWidth.this.hidePopup();
                }
            }
        };
        this.addKeyListener(this.m_keyListener);
    }

    public void cleanUp() {
        this.removeKeyListener(this.m_keyListener);
        this.m_keyListener = null;
        this.setRenderer(null);
        this._filter = null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((CellRenderer)this.getRenderer()).setEnabled(bl);
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private Icon _getColorIcon(Image image) {
        this._filter.setColor();
        Image image2 = LineWidth._createFilteredImage(image, this._filter);
        return new ImageIcon(image2);
    }

    private static Image _createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public int getLineWidth() {
        return this.getSelectedIndex() + 1;
    }

    public void setLineWidth(int n) {
        if (n > 0) {
            this.setSelectedIndex(n - 1);
        } else if (n == 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setCellColor(Color color) {
        this.m_cellColor = color;
        if (this.getBackground() != null && this.getBackground().getRGB() == this.m_cellColor.getRGB()) {
            this.m_cellColor = this.getBackground().getRGB() != -16777216 ? Color.black : Color.white;
        }
        this.repaint();
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(jList.getBackground());
            }
            if (object.equals("0")) {
                this.setText(LineWidth.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(LineWidth.this.rBundle.getString("None"));
            } else {
                String string = "";
                this.setText("");
                int n2 = 1;
                if (object != null && object == "") {
                    this.setIcon(null);
                } else {
                    if (object != null) {
                        n2 = new Integer((String)object);
                    }
                    string = String.valueOf(String.valueOf("images/Line")) + n2 + ".gif";
                    this.setIcon(LineWidth.this._getColorIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.LineWidth"), (String)string)));
                    if (n2 == 1) {
                        this.getAccessibleContext().setAccessibleName(LineWidth.this.rBundle.getString("Single pixel"));
                    } else {
                        this.getAccessibleContext().setAccessibleName(MessageFormat.format(LineWidth.this.rBundle.getString("pixels"), new Integer(n2)));
                    }
                }
            }
            this.setMinimumSize(new Dimension(100, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
            this.setMaximumSize(new Dimension(100, this.getMaximumSize().height));
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor() {
            Color color = LineWidth.this.m_cellColor;
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._sCOLOR) {
                return this._color;
            }
            return n3;
        }
    }
}

