/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.UIGraph;

public class GridLineTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_GRIDLINE_VISIBLE = "GridLineVisible";
    protected Object m_currentDataView;
    protected boolean m_bRolloverIconEnabled;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    private MouseListener m_mouseListener;
    private static final int HORIZ_VERT_BOTH = 0;
    private static final int HORIZ_ONLY = 1;
    private static final int VERT_ONLY = 2;
    private int gridlineState;

    public GridLineTool() {
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_grid_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowGridLine"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!GridLineTool.this.isRolloverIconEnabled()) {
                        GridLineTool.this.setBorderPainted(true);
                    }
                    if (!GridLineTool.this.isEnabled()) {
                        GridLineTool.this.setBorderPainted(GridLineTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!GridLineTool.this.isRolloverIconEnabled()) {
                        GridLineTool.this.setBorderPainted(GridLineTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("ShowGridLine"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        this.m_enable = false;
        if (uIDataview instanceof UIGraph) {
            boolean bl;
            this.m_currentDataView = uIDataview;
            int n = ((UIGraph)uIDataview).getGraphType();
            boolean bl2 = bl = ((UIGraph)uIDataview).getUIY1MajorTick().isVisible() || ((UIGraph)uIDataview).getUIY2MajorTick().isVisible();
            if (!this._isO1AxisSupported()) {
                boolean bl3 = ((UIGraph)uIDataview).getUIX1MajorTick().isVisible();
                this.setSelected(bl3 || bl);
            } else {
                this.setSelected(bl);
            }
            this.setBorderPainted(this.isSelected());
            this.setEnabled(this._isGridLineSupport(uIDataview));
        } else {
            this.m_currentDataView = null;
        }
        this.m_enable = true;
    }

    private boolean _isGridLineSupport(UIDataview uIDataview) {
        if (!(uIDataview instanceof UIGraph)) {
            return false;
        }
        UIGraph uIGraph = (UIGraph)uIDataview;
        switch (uIGraph.getGraphType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 35: 
            case 40: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 93: 
            case 94: {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            if (!(this._isO1AxisSupported() || this.gridlineState != 2 && this.gridlineState != 0)) {
                ((UIGraph)this.m_currentDataView).getUIX1MajorTick().setVisible(this.isSelected());
            }
            if (this.gridlineState == 1 || this.gridlineState == 0) {
                ((UIGraph)this.m_currentDataView).getUIY1MajorTick().setVisible(this.isSelected());
                ((UIGraph)this.m_currentDataView).getUIY2MajorTick().setVisible(this.isSelected());
            }
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_GRIDLINE_VISIBLE, !this.isSelected(), this.isSelected());
        }
    }

    public void update() {
        boolean bl;
        if (this.m_currentDataView == null) {
            return;
        }
        int n = ((UIGraph)this.m_currentDataView).getGraphType();
        if (n >= 55 && n <= 60 || n == 93 || n == 94 || n >= 0 && n <= 14 || n == 35 || n == 40) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        boolean bl2 = false;
        boolean bl3 = bl = ((UIGraph)this.m_currentDataView).getUIY1MajorTick().isVisible() || ((UIGraph)this.m_currentDataView).getUIY2MajorTick().isVisible();
        if (!this._isO1AxisSupported()) {
            bl2 = ((UIGraph)this.m_currentDataView).getUIX1MajorTick().isVisible();
            this.setSelected(bl2 || bl);
        } else {
            this.setSelected(bl);
        }
        this.gridlineState = !this._isO1AxisSupported() ? (this.isSelected() == bl2 && this.isSelected() == bl ? 0 : (this.isSelected() == bl2 ? 2 : 1)) : 1;
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GridLineTool"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private boolean _isO1AxisSupported() {
        int n = ((UIGraph)this.m_currentDataView).getGraphType();
        return !(n >= 55 && n <= 66 || n >= 85 && n <= 87) && (n < 89 || n > 94);
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.setIcon(this.makeImage("images/s_grid.gif"));
            this.setRolloverIcon(this.makeImage("images/l_grid.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_grid.gif"));
        } else {
            this.setIcon(this.makeImage("images/s_grid_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }
}

