/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphUtils;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.GraphStandardStyles;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.StyleList;
import oracle.dss.graph.gui.StyleListEntry;
import oracle.dss.util.CustomStyle;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.help.HelpContext;
import oracle.dss.util.persistence.CustomObjectManager;
import oracle.dss.util.persistence.ObjectBinding;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;

public class GraphStylePanel
extends BasePanel
implements ItemListener,
HelpContext {
    private ResourceBundle rBundle;
    private boolean isSetFocus = true;
    private boolean propertyChnageFlag = true;
    protected Graph m_Graph;
    protected StyleList m_styleList1;
    protected int m_iInitToIndex;
    protected Locale m_locale;
    protected Graph m_sampleGraph = new Graph();
    protected String m_applicationName;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected JPanel m_samplePanel;
    protected JComboBox m_styleList;
    protected Vector m_styleVector = new Vector();
    protected Vector m_UIStyleVector = new Vector();
    protected CustomObjectManager m_customObjectManager;
    protected String m_strHelpContextID;
    protected CustomStyle m_customStyle;
    protected HelpProvider m_helpProvider;
    protected int m_graphType = -1;
    protected boolean isThreeDSetting;
    protected JCheckBox m_3DEffect;
    protected JCheckBox m_gradientEffect;
    private JPanel samplePanel;
    private JPanel superRightPanel;
    private FocusListener m_focusListener;
    private ListCellRenderer m_styleListCellRenderer;
    private ComponentAdapter m_compListener;
    private AncestorListener m_ancestorListener;
    private boolean m_b3DEffectChanged;
    private boolean m_bGradientEffectChanged;
    private boolean m_bStyleChanged;

    public GraphStylePanel(Graph graph) {
        super(graph);
        this.m_Graph = graph;
        this._initialize(graph);
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.m_mainPanel.removeAll();
        this._initialize(graph);
    }

    public Graph getGraph() {
        return this.m_Graph;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_styleList.removeFocusListener(this.m_focusListener);
        this.m_focusListener = null;
        this.removeComponentListener(this.m_compListener);
        this.m_compListener = null;
        this.removeAncestorListener(this.m_ancestorListener);
        this.m_ancestorListener = null;
        this.m_samplePanel.removeAll();
    }

    public StyleList getStandardStyleList() {
        return GraphStandardStyles.getStandardStyleList();
    }

    private void _initSampleGraph() {
        this.m_sampleGraph.setEnabled(false);
        this.m_sampleGraph.setGroupTooltipLabelType(0);
        this.m_sampleGraph.setSeriesTooltipLabelType(0);
        this.m_sampleGraph.setMarkerTooltipType(0);
        this.m_sampleGraph.getTitle().setText(this.rBundle.getString("sampleTitle"));
        this.m_sampleGraph.getSubtitle().setText(this.rBundle.getString("sampleSubtitle"));
        this.m_sampleGraph.getFootnote().setText(this.rBundle.getString("sampleFootnote"));
        this.m_sampleGraph.getO1Title().setText(this.rBundle.getString("sampleO1AxisTitle"));
        this.m_sampleGraph.getX1Title().setText(this.rBundle.getString("sampleX1AxisTitle"));
        this.m_sampleGraph.getY1Title().setText(this.rBundle.getString("sampleY1AxisTitle"));
        this.m_sampleGraph.getY2Title().setText(this.rBundle.getString("sampleY2AxisTitle"));
        if (this.m_graph.getGraphTypeConverter() == null) {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter(graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(this.m_graph.getLocale());
        }
        this.m_graph.getGraphTypeConverter().setTypeAndSubtype(this.m_sampleGraph, this.m_graph.getGraphTypeConverter().getTypeAndSubtype(this.m_graph));
    }

    private void _initialize(Graph graph) {
        this.m_mainPanel.removeAll();
        if (graph != null) {
            this.setLocale(graph.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this._initSampleGraph();
        this.m_styleList1 = this.getCustomStyleList();
        this._initStyleVectors(this.m_styleList1);
        this.m_iInitToIndex = this.m_styleList1.getStyleIndex(graph.getStylePath());
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        String string = this.rBundle.getString("base title");
        this.setTitleText(string);
        int n = this.getPreferredSize().width;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        string = this.rBundle.getString("style");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setAlignmentX(0.0f);
        this.m_styleList = new JComboBox(this.m_styleVector);
        this.m_styleList.setSelectedIndex(this.m_iInitToIndex);
        this.m_styleList.setAlignmentX(0.0f);
        jLabel.setLabelFor(this.m_styleList);
        this.m_styleList.setMinimumSize(this.m_styleList.getPreferredSize());
        this.m_styleList.setMaximumSize(this.m_styleList.getPreferredSize());
        this.m_styleList.addItemListener(this);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.m_styleList);
        this.samplePanel = new JPanel();
        this.samplePanel.setAlignmentX(0.0f);
        this.samplePanel.setLayout(new BoxLayout(this.samplePanel, 0));
        string = this.rBundle.getString("styleSample");
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)string));
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jLabel2);
        jPanel3.add(Box.createVerticalGlue());
        int n2 = Math.max(jLabel.getPreferredSize().width, jLabel2.getPreferredSize().width);
        jLabel.setPreferredSize(new Dimension(n2, jLabel.getPreferredSize().height));
        jLabel.setMinimumSize(jLabel.getPreferredSize());
        jLabel.setMaximumSize(jLabel.getPreferredSize());
        jLabel2.setPreferredSize(new Dimension(n2, jLabel2.getPreferredSize().height));
        jLabel2.setMinimumSize(jLabel2.getPreferredSize());
        jLabel2.setMaximumSize(jLabel2.getPreferredSize());
        this.m_samplePanel = new JPanel();
        this.m_samplePanel.setAlignmentX(0.0f);
        this.m_samplePanel.setLayout(new BorderLayout());
        this.m_samplePanel.setBackground(Color.white);
        this.m_samplePanel.add((Component)this.m_sampleGraph, "Center");
        this.samplePanel.add(jPanel3);
        this.samplePanel.add(Box.createHorizontalStrut(5));
        this.samplePanel.add(this.m_samplePanel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.samplePanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalStrut(n2 + 5));
        jPanel4.setAlignmentX(0.0f);
        string = this.rBundle.getString("Gradient Effect");
        this.m_gradientEffect = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_gradientEffect.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_gradientEffect.setAlignmentX(0.0f);
        if (this.m_graph.getSeriesEffect() == 0) {
            this.m_gradientEffect.setSelected(false);
        } else {
            this.m_gradientEffect.setSelected(true);
        }
        this.m_gradientEffect.setVisible(!GraphUtils.isGradientDisabled(this.m_graph));
        this.m_gradientEffect.addItemListener(this);
        this.m_styleList.setNextFocusableComponent(this.m_gradientEffect);
        jPanel4.add(this.m_gradientEffect);
        jPanel.add(jPanel4);
        jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createHorizontalStrut(n2 + 5));
        jPanel4.setAlignmentX(0.0f);
        string = this.rBundle.getString("3D Effect");
        this.m_3DEffect = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_3DEffect.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_3DEffect.setAlignmentX(0.0f);
        this.m_3DEffect.setSelected(this.m_graph.is3DEffect());
        int n3 = this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraph)this.m_graph).type;
        Type type = ((GraphTypeConverterAdapter)this.m_graph.getGraphTypeConverter()).getType(n3);
        if (type.supports3D && type.supportsNon3D && this.m_graph.getGraphType() != 67 && this.m_graph.getGraphType() != 69) {
            this.m_3DEffect.setVisible(true);
        } else {
            this.m_3DEffect.setVisible(false);
        }
        this.m_b3DEffectChanged = false;
        this.m_3DEffect.addItemListener(this);
        jPanel4.add(this.m_3DEffect);
        jPanel.add(jPanel4);
        this.m_mainPanel.add(jPanel);
        this._init();
        this.m_compListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GraphStylePanel.this.setScaledFontSizes();
            }
        };
        this.addComponentListener(this.m_compListener);
        this.m_ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                GraphStylePanel.this.setScaledFontSizes();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                GraphStylePanel.this.setScaledFontSizes();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        };
        this.addAncestorListener(this.m_ancestorListener);
    }

    protected void setScaledFontSizes() {
        float f = (float)this.m_samplePanel.getSize().height / 400.0f;
        this.m_sampleGraph.applyFontSizes(f);
    }

    private void updateResourceBundle(Locale locale) {
        this.m_locale = locale;
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _init() {
        if (!this.m_UIStyleVector.isEmpty()) {
            Style style = (Style)this.m_UIStyleVector.elementAt(this.m_iInitToIndex);
            CustomStyle customStyle = style.style;
            this.updateSampleGraph(customStyle);
        }
    }

    private void _initStyleVectors(StyleList styleList) {
        if (styleList == null) {
            return;
        }
        this.m_UIStyleVector.removeAllElements();
        this.m_styleVector.removeAllElements();
        int n = 0;
        while (n < styleList.size()) {
            String string = "";
            String string2 = "";
            StyleListEntry styleListEntry = styleList.getStyleListEntry(n);
            CustomStyle customStyle = new CustomStyle();
            string = styleListEntry.getStyleName();
            customStyle.setTitle(string);
            string2 = styleListEntry.getStylePath();
            customStyle.setXMLAsString(string2);
            this.m_UIStyleVector.addElement(null.new Style(customStyle, 0));
            this.m_styleVector.addElement(string);
            ++n;
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.m_sampleGraph.setLocale(locale);
    }

    public void apply() {
        try {
            boolean bl = this.m_Graph.is3DEffect();
            int n = this.m_Graph.getSeriesEffect();
            if (this.m_bStyleChanged && !this.m_UIStyleVector.isEmpty()) {
                Style style = (Style)this.m_UIStyleVector.elementAt(this.m_styleList.getSelectedIndex());
                CustomStyle customStyle = style.style;
                String string = customStyle.getXMLAsString();
                this.m_Graph.setStylePath(string);
            }
            if (this.m_b3DEffectChanged) {
                this.m_Graph.set3DEffect(this.m_3DEffect.isSelected());
            } else if (this.m_bStyleChanged && this.m_Graph.is3DEffect() != bl) {
                this.m_Graph.set3DEffect(bl);
            }
            if (this.m_bGradientEffectChanged) {
                if (this.m_gradientEffect.isSelected()) {
                    this.m_Graph.setSeriesEffect(2);
                } else {
                    this.m_Graph.setSeriesEffect(0);
                }
            } else if (this.m_bStyleChanged && this.m_Graph.getSeriesEffect() != n) {
                this.m_Graph.setSeriesEffect(n);
            }
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(String.valueOf("error ")) + iOException.toString());
        }
        catch (BIParseException bIParseException) {
            System.out.println(String.valueOf(String.valueOf("LineNumber ")) + bIParseException.getLineNumber());
            System.out.println(String.valueOf(String.valueOf("ColumnNumber ")) + bIParseException.getColumnNumber());
            System.out.println(String.valueOf(String.valueOf("error ")) + bIParseException.toString());
        }
        catch (BIIOException bIIOException) {
            System.out.println(String.valueOf(String.valueOf("error ")) + bIIOException.toString());
        }
        catch (BISAXException bISAXException) {
            System.out.println(String.valueOf(String.valueOf("SAX error in the XML ")) + bISAXException.toString());
        }
    }

    private void addStyleToList(CustomStyle customStyle) {
        this.addStyleToList(customStyle, 0);
    }

    private void addStyleToList(CustomStyle customStyle, int n) {
        if (customStyle == null) {
            return;
        }
        this.m_UIStyleVector.addElement(null.new Style(customStyle, n));
        this.m_styleVector.addElement(customStyle.getTitle());
        this.m_styleList.addItem(customStyle.getTitle());
    }

    private void insertStyleInList(CustomStyle customStyle, int n) {
        if (customStyle == null) {
            return;
        }
        this.m_UIStyleVector.insertElementAt(null.new Style(customStyle, 0), n);
        this.m_styleVector.insertElementAt(customStyle.getTitle(), n);
        this.m_styleList.insertItemAt(customStyle.getTitle(), n);
    }

    private void removeStyleFromList(int n) {
        if (n >= this.m_UIStyleVector.size()) {
            return;
        }
        this.m_UIStyleVector.removeElementAt(n);
        this.m_styleVector.removeElementAt(n);
        this.m_styleList.removeItemAt(n);
    }

    private CustomStyle getStyleFromList(int n) {
        if (n >= this.m_UIStyleVector.size()) {
            return null;
        }
        Style style = (Style)this.m_UIStyleVector.elementAt(n);
        CustomStyle customStyle = style.style;
        return customStyle;
    }

    public void setCustomObjectManager(CustomObjectManager customObjectManager) {
        block8: {
            block7: {
                this.m_customObjectManager = customObjectManager;
                if (this.m_customStyle == null) break block7;
                Vector vector = customObjectManager.listAllObjects("GraphStyle");
                if (vector == null) break block8;
                int n = 0;
                while (n < vector.size()) {
                    CustomStyle customStyle = (CustomStyle)((ObjectBinding)vector.elementAt(n)).getObject();
                    String string = ((ObjectBinding)vector.elementAt(n)).getLabelName();
                    if (string.indexOf("/") != -1) {
                        customStyle.setTitle(string.substring(string.lastIndexOf("/") + 1, string.length()));
                    } else {
                        customStyle.setTitle(string);
                    }
                    this.addStyleToList(customStyle);
                    ++n;
                }
                break block8;
            }
            Vector vector = customObjectManager.listAllObjects("GraphStyle");
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    CustomStyle customStyle = (CustomStyle)((ObjectBinding)vector.elementAt(n)).getObject();
                    String string = ((ObjectBinding)vector.elementAt(n)).getLabelName();
                    if (string.indexOf("/") != -1) {
                        customStyle.setTitle(string.substring(string.lastIndexOf("/") + 1, string.length()));
                    } else {
                        customStyle.setTitle(string);
                    }
                    this.addStyleToList(customStyle);
                    ++n;
                }
            }
        }
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.m_customObjectManager;
    }

    public Dimension getPreferredSize() {
        int n = Integer.parseInt(this.rBundle.getString("GraphStylePanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("GraphStylePanelHeight"));
        return new Dimension(n, n2);
    }

    public void setApplicationName(String string) {
        this.m_applicationName = string;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_styleList) {
            this.m_bStyleChanged = true;
            int n = this.m_styleList.getSelectedIndex();
            if (!this.m_UIStyleVector.isEmpty()) {
                CustomStyle customStyle;
                Style style = (Style)this.m_UIStyleVector.elementAt(n);
                this.m_customStyle = customStyle = style.style;
                if (customStyle == null) {
                    this.m_samplePanel.removeAll();
                    JLabel jLabel = new JLabel(this.rBundle.getString("No Sample"));
                    this.m_samplePanel.add((Component)jLabel, "Center");
                } else {
                    this.updateSampleGraph(customStyle);
                }
            } else {
                this.m_samplePanel.removeAll();
                JLabel jLabel = new JLabel(this.rBundle.getString("No Sample"));
                this.m_samplePanel.add((Component)jLabel, "Center");
            }
        } else if (itemEvent.getSource() == this.m_3DEffect) {
            this.m_b3DEffectChanged = true;
            this.m_sampleGraph.set3DEffect(this.m_3DEffect.isSelected());
        } else {
            this.m_bGradientEffectChanged = true;
            if (this.m_gradientEffect.isSelected()) {
                this.m_sampleGraph.setSeriesEffect(2);
            } else {
                this.m_sampleGraph.setSeriesEffect(0);
            }
        }
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public StyleList getCustomStyleList() {
        if (this.m_styleList1 == null) {
            this.m_styleList1 = GraphStandardStyles.getStandardStyleList();
        }
        this.updateCustomStyleList();
        return this.m_styleList1;
    }

    public void setCustomStyleList(StyleList styleList) {
        this.m_styleList1 = new StyleList(styleList);
        this.m_styleList1.addRequiredStyles();
        this.updateCustomStyleList();
    }

    private void updateCustomStyleList() {
        if (this.m_styleList1 != null) {
            this.m_styleList1.setLocale(this.m_locale);
        }
    }

    private void updateSampleGraph(CustomStyle customStyle) {
        try {
            String string = customStyle.getXMLAsString();
            this.m_sampleGraph.setStylePath(string);
            this.m_sampleGraph.saveFontSizes();
            this.setScaledFontSizes();
            if (this.m_sampleGraph.getGraphType() != this.m_graphType) {
                this.m_graphType = this.m_Graph.getGraphType();
                this.m_sampleGraph.setGraphType(this.m_graphType);
            }
            this._initSampleGraph();
            this.m_sampleGraph.set3DEffect(this.m_3DEffect.isSelected());
            if (this.m_gradientEffect.isSelected()) {
                this.m_sampleGraph.setSeriesEffect(2);
            } else {
                this.m_sampleGraph.setSeriesEffect(0);
            }
            boolean bl = true;
            if (this.m_graphType >= 0 && this.m_graphType <= 14) {
                bl = false;
            }
            this.m_sampleGraph.getY1Title().setVisible(bl);
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(String.valueOf("error ")) + iOException.toString());
        }
        catch (BIParseException bIParseException) {
            System.out.println(String.valueOf(String.valueOf("LineNumber ")) + bIParseException.getLineNumber());
            System.out.println(String.valueOf(String.valueOf("ColumnNumber ")) + bIParseException.getColumnNumber());
            System.out.println(String.valueOf(String.valueOf("error ")) + bIParseException.toString());
        }
        catch (BIIOException bIIOException) {
            System.out.println(String.valueOf(String.valueOf("error ")) + bIIOException.toString());
        }
        catch (BISAXException bISAXException) {
            System.out.println(String.valueOf(String.valueOf("SAX error in the XML ")) + bISAXException.toString());
        }
    }

    class StyleListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel m_label = new JLabel();

        public StyleListCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.m_label);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setPreferredSize(new Dimension(this.getToolkit().getFontMetrics(this.m_label.getFont()).stringWidth((String)object) + 20, 18));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.m_label.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.m_label.setForeground(jList.getForeground());
            }
            this.m_label.setText((String)object);
            this.getAccessibleContext().setAccessibleName((String)object);
            return this;
        }
    }

    class Style {
        CustomStyle style;
        int type;

        public Style(CustomStyle customStyle, int n) {
            this.style = customStyle;
            this.type = n;
        }
    }
}

